/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.idgen.ws.rs;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.ldap.model.LdapDummyEntry;
import org.xdi.oxauth.idgen.ws.rs.IdGenerator;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.model.config.BaseDnConfiguration;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.INumGenerator;

@Scope(value=ScopeType.STATELESS)
@Name(value="inumGenerator")
@AutoCreate
public class InumGenerator
implements IdGenerator {
    public static final String SEPARATOR = "!";
    private static final int MAX = 100;
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    @Override
    public String generateId(String p_idType, String p_idPrefix) {
        IdType idType = IdType.fromString((String)p_idType);
        if (idType != null) {
            return this.generateId(idType, p_idPrefix);
        }
        this.log.error((Object)"Unable to identify id type: {0}", new Object[]{p_idType});
        return "";
    }

    public String generateId(IdType p_idType, String p_idPrefix) {
        String inum;
        int counter = 0;
        try {
            while (true) {
                StringBuilder sb = new StringBuilder();
                sb.append(p_idPrefix).append(SEPARATOR).append(p_idType.getInum()).append(SEPARATOR).append(INumGenerator.generate((int)2));
                inum = sb.toString();
                if (StringUtils.isBlank((String)inum)) {
                    this.log.error((Object)"Unable to generate inum: {0}", new Object[]{inum});
                } else if (this.contains(inum, p_idType)) {
                    if (counter > 100) {
                        this.log.error((Object)"Infinite loop problem while generating new inum", new Object[0]);
                        return "";
                    }
                    ++counter;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            inum = e.getMessage();
        }
        this.log.trace((Object)"Generated inum: {0}", new Object[]{inum});
        return inum;
    }

    public boolean contains(String inum, IdType type) {
        String baseDn = this.baseDn(type);
        try {
            Filter filter = Filter.create((String)String.format("inum=%s", inum));
            List entries = this.ldapEntryManager.findEntries(baseDn, LdapDummyEntry.class, filter);
            return entries != null && !entries.isEmpty();
        }
        catch (LDAPException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
    }

    public String baseDn(IdType p_type) {
        BaseDnConfiguration baseDn = ConfigurationFactory.instance().getBaseDn();
        switch (p_type) {
            case CLIENTS: {
                return baseDn.getClients();
            }
            case APPLIANCE: {
                return baseDn.getAppliance();
            }
            case ATTRIBUTE: {
                return baseDn.getAttributes();
            }
            case PEOPLE: {
                return baseDn.getPeople();
            }
        }
        try {
            DN dnObj = new DN(baseDn.getClients());
            RDN[] rdns = dnObj.getRDNs();
            RDN rdn = rdns[rdns.length - 1];
            return rdn.toNormalizedString();
        }
        catch (LDAPException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            this.log.error((Object)"Use fallback DN: o=gluu, for ID generator, please check oxAuth configuration, clientDn must be valid DN", new Object[0]);
            return "o=gluu";
        }
    }

    public static InumGenerator instance() {
        return (InumGenerator)ServerUtil.instance(InumGenerator.class);
    }
}

