/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.idgen.ws.rs;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.idgen.ws.rs.IdGenerator;
import org.xdi.oxauth.idgen.ws.rs.InumGenerator;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.service.external.ExternalIdGeneratorService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="idGenService")
@AutoCreate
public class IdGenService
implements IdGenerator {
    public static final String PYTHON_CLASS_NAME = "PythonExternalIdGenerator";
    @Logger
    private Log log;
    @In
    private InumGenerator inumGenerator;
    @In
    private ExternalIdGeneratorService externalIdGeneratorService;

    public static IdGenService instance() {
        return (IdGenService)ServerUtil.instance(IdGenService.class);
    }

    public String generateId(IdType p_idType, String p_idPrefix) {
        return this.generateId(p_idType.getType(), p_idPrefix);
    }

    @Override
    public String generateId(String p_idType, String p_idPrefix) {
        String generatedId;
        if (this.externalIdGeneratorService.isEnabled() && StringHelper.isNotEmpty((String)(generatedId = this.externalIdGeneratorService.executeExternalDefaultGenerateIdMethod("oxauth", p_idType, p_idPrefix)))) {
            return generatedId;
        }
        return this.inumGenerator.generateId(p_idType, p_idPrefix);
    }
}

