/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.federation.ws.rs;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.federation.ws.rs.FederationMetadataWS;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.signature.RSAKeyFactory;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.federation.FederationErrorResponseType;
import org.xdi.oxauth.model.federation.FederationMetadata;
import org.xdi.oxauth.model.federation.FederationOP;
import org.xdi.oxauth.model.federation.FederationRP;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwt.JwtHeader;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.service.FederationMetadataService;

@Name(value="federationMetadataWS")
public class FederationMetadataWSImpl
implements FederationMetadataWS {
    @Logger
    private Log log;
    @In
    private FederationMetadataService federationMetadataService;
    @In
    private ErrorResponseFactory errorResponseFactory;

    @Override
    public Response requestMetadata(String federationId, String signed, HttpServletRequest request, SecurityContext sec) {
        this.log.debug((Object)"Called federation metadata endpoint federation_id: {0}", new Object[]{federationId});
        try {
            if (FederationMetadataWSImpl.isRequestValid(request)) {
                if (StringUtils.isBlank((String)federationId)) {
                    String entity = FederationMetadataWSImpl.asJSON(this.federationMetadataService.getMetadataList());
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).build();
                }
                FederationMetadata metadata = this.federationMetadataService.getMetadata(federationId, true);
                String entity = Boolean.FALSE.toString().equalsIgnoreCase(signed) ? FederationMetadataWSImpl.asJSON(metadata).toString() : this.asSignedJSON(metadata);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).build();
            }
        }
        catch (FederationMetadataService.InvalidIdException e) {
            return this.errorResponse(FederationErrorResponseType.INVALID_FEDERATION_ID);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return this.errorResponse(FederationErrorResponseType.INVALID_REQUEST);
    }

    public Response errorResponse(FederationErrorResponseType p_type) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)p_type).toJSonString()).build();
    }

    private String asSignedJSON(FederationMetadata p_metadata) throws JSONException, InvalidJwtException {
        try {
            String keyId = ConfigurationFactory.instance().getConfiguration().getFederationSigningKid();
            SignatureAlgorithm algorithm = SignatureAlgorithm.fromName((String)ConfigurationFactory.instance().getConfiguration().getFederationSigningAlg());
            JSONWebKey JSONWebKey2 = ConfigurationFactory.instance().getWebKeys().getKey(keyId);
            RSAKeyFactory factory = RSAKeyFactory.valueOf((JSONWebKey)JSONWebKey2);
            JSONObject jsonHeader = JwtHeader.instance().setType(JwtType.JWT).setAlgorithm(algorithm).setKeyId(keyId).toJsonObject();
            JSONObject jsonPayload = FederationMetadataWSImpl.asJSON(p_metadata);
            return JwtUtil.encodeJwt((JSONObject)jsonHeader, (JSONObject)jsonPayload, (SignatureAlgorithm)algorithm, (RSAPrivateKey)factory.getPrivateKey());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return FederationMetadataWSImpl.asJSON(p_metadata).toString();
        }
    }

    private static JSONObject asJSON(FederationMetadata p_metadata) throws JSONException {
        JSONArray rps = new JSONArray();
        if (p_metadata.getRpList() != null) {
            for (FederationRP rp : p_metadata.getRpList()) {
                JSONObject j = new JSONObject();
                j.put("display_name", (Object)rp.getDisplayName());
                List redirectUris = rp.getRedirectUri();
                if (redirectUris != null && !redirectUris.isEmpty()) {
                    int size = redirectUris.size();
                    if (size == 1) {
                        j.put("redirect_uri", redirectUris.get(0));
                    } else {
                        j.put("redirect_uri", (Collection)redirectUris);
                    }
                }
                rps.put((Object)j);
            }
        }
        JSONArray ops = new JSONArray();
        if (p_metadata.getOpList() != null) {
            for (FederationOP op : p_metadata.getOpList()) {
                JSONObject j = new JSONObject();
                j.put("display_name", (Object)op.getDisplayName());
                j.put("op_id", (Object)op.getOpId());
                j.put("domain", (Object)op.getDomain());
                ops.put((Object)j);
            }
        }
        JSONObject result = new JSONObject();
        result.put("federation_id", (Object)p_metadata.getId());
        result.put("display_name", (Object)p_metadata.getDisplayName());
        result.put("interval_check", (Object)p_metadata.getIntervalCheck());
        result.put("RPs", (Object)rps);
        result.put("OPs", (Object)ops);
        return result;
    }

    private static String asJSON(List<FederationMetadata> p_list) {
        JSONArray array = new JSONArray();
        if (p_list != null && !p_list.isEmpty()) {
            for (FederationMetadata m : p_list) {
                array.put((Object)m.getId());
            }
        }
        return array.toString();
    }

    private static boolean isRequestValid(HttpServletRequest request) {
        Map map;
        if (request != null && (map = request.getParameterMap()) != null) {
            Set keys = map.keySet();
            if (keys != null) {
                keys.remove("federation_id");
                keys.remove("signed");
                return keys.isEmpty();
            }
            return true;
        }
        return false;
    }
}

