/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.authorize.ws.rs;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.log.Log;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.service.external.ExternalAuthenticationService;
import org.xdi.util.StringHelper;

@Name(value="logoutAction")
@Scope(value=ScopeType.EVENT)
public class LogoutAction {
    @Logger
    private Log log;
    @In
    private FacesMessages facesMessages;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ExternalAuthenticationService externalAuthenticationService;
    private String idTokenHint;
    private String postLogoutRedirectUri;

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public void redirect() {
        boolean externalLogoutResult = this.processExternalAuthenticatorLogOut();
        if (!externalLogoutResult) {
            this.logoutFailed();
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.idTokenHint != null && !this.idTokenHint.isEmpty()) {
            sb.append("id_token_hint=").append(this.idTokenHint);
        }
        if (this.postLogoutRedirectUri != null && !this.postLogoutRedirectUri.isEmpty()) {
            sb.append("&post_logout_redirect_uri=").append(this.postLogoutRedirectUri);
        }
        FacesManager.instance().redirectToExternalURL("seam/resource/restv1/oxauth/end_session?" + sb.toString());
    }

    private boolean processExternalAuthenticatorLogOut() {
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(this.idTokenHint);
        if (authorizationGrant == null) {
            return false;
        }
        String authMode = authorizationGrant.getAcrValues();
        boolean isExternalAuthenticatorLogoutPresent = StringHelper.isNotEmpty((String)authMode);
        if (isExternalAuthenticatorLogoutPresent) {
            this.log.debug((Object)"Attemptinmg to execute logout method of '{0}' external authenticator.", new Object[]{authMode});
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfigurationByName(authMode);
            if (customScriptConfiguration == null) {
                this.log.error((Object)"Failed to get ExternalAuthenticatorConfiguration. auth_mode: {0}", new Object[]{authMode});
                return false;
            }
            boolean externalLogoutResult = this.externalAuthenticationService.executeExternalLogout(customScriptConfiguration, null);
            this.log.debug((Object)"Logout result for {0}. result: {1}", new Object[]{authorizationGrant.getUser().getUserId(), authMode, externalLogoutResult});
            return externalLogoutResult;
        }
        return true;
    }

    public void logoutFailed() {
        this.facesMessages.add(StatusMessage.Severity.ERROR, "Failed to process logout", new Object[0]);
        FacesManager.instance().redirect("/error.xhtml");
    }
}

