/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.authorize.ws.rs;

import com.google.common.collect.Maps;
import com.wordnik.swagger.annotations.Api;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.xdi.oxauth.auth.Authenticator;
import org.xdi.oxauth.authorize.ws.rs.AuthorizeRestWebService;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.authorize.AuthorizeParamsValidator;
import org.xdi.oxauth.model.authorize.Claim;
import org.xdi.oxauth.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.authorize.ScopeChecker;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseMode;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SessionIdState;
import org.xdi.oxauth.model.common.SessionState;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.ldap.ClientAuthorizations;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.AuthenticationFilterService;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.oxauth.service.ClientAuthorizationsService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.RedirectionUriService;
import org.xdi.oxauth.service.SessionStateService;
import org.xdi.oxauth.service.UserGroupService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.util.QueryStringDecoder;
import org.xdi.oxauth.util.RedirectUri;
import org.xdi.oxauth.util.RedirectUtil;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

@Name(value="requestAuthorizationRestWebService")
@Api(value="/oxauth/authorize", description="Authorization Endpoint")
public class AuthorizeRestWebServiceImpl
implements AuthorizeRestWebService {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RedirectionUriService redirectionUriService;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ClientService clientService;
    @In
    private UserService userService;
    @In
    private UserGroupService userGroupService;
    @In
    private FederationDataService federationDataService;
    @In
    private Identity identity;
    @In
    private AuthenticationFilterService authenticationFilterService;
    @In
    private SessionStateService sessionStateService;
    @In
    private ScopeChecker scopeChecker;
    @In
    private SessionState sessionUser;
    @In
    private ClientAuthorizationsService clientAuthorizationsService;
    @In
    private AuthenticationService authenticationService;

    @Override
    public Response requestAuthorizationGet(String scope, String responseType, String clientId, String redirectUri, String state, String responseMode, String nonce, String display, String prompt, Integer maxAge, String uiLocales, String idTokenHint, String loginHint, String acrValues, String amrValues, String request, String requestUri, String requestSessionState, String sessionState, String accessToken, String originHeaders, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        return this.requestAuthorization(scope, responseType, clientId, redirectUri, state, responseMode, nonce, display, prompt, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, requestSessionState, sessionState, accessToken, "GET", originHeaders, httpRequest, httpResponse, securityContext);
    }

    @Override
    public Response requestAuthorizationPost(String scope, String responseType, String clientId, String redirectUri, String state, String responseMode, String nonce, String display, String prompt, Integer maxAge, String uiLocales, String idTokenHint, String loginHint, String acrValues, String amrValues, String request, String requestUri, String requestSessionState, String sessionState, String accessToken, String originHeaders, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        return this.requestAuthorization(scope, responseType, clientId, redirectUri, state, responseMode, nonce, display, prompt, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, requestSessionState, sessionState, accessToken, "POST", originHeaders, httpRequest, httpResponse, securityContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response requestAuthorization(String scope, String responseType, String clientId, String redirectUri, String state, String respMode, String nonce, String display, String prompt, Integer maxAge, String uiLocalesStr, String idTokenHint, String loginHint, String acrValuesStr, String amrValuesStr, String request, String requestUri, String requestSessionState, String sessionState, String accessToken, String method, String originHeaders, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        scope = ServerUtil.urlDecode(scope);
        this.log.debug((Object)"Attempting to request authorization: responseType = {0}, clientId = {1}, scope = {2}, redirectUri = {3}, nonce = {4}, state = {5}, request = {6}, isSecure = {7}, requestSessionState = {8}, sessionState = {9}", new Object[]{responseType, clientId, scope, redirectUri, nonce, state, request, securityContext.isSecure(), requestSessionState, sessionState});
        this.log.debug((Object)"Attempting to request authorization: acrValues = {0}, amrValues = {1}, originHeaders = {4}", new Object[]{acrValuesStr, amrValuesStr, originHeaders});
        Response.ResponseBuilder builder = Response.ok();
        List uiLocales = null;
        if (StringUtils.isNotBlank((String)uiLocalesStr)) {
            uiLocales = Util.splittedStringAsList((String)uiLocalesStr, (String)" ");
        }
        List responseTypes = ResponseType.fromString((String)responseType, (String)" ");
        List prompts = Prompt.fromString((String)prompt, (String)" ");
        List acrValues = Util.splittedStringAsList((String)acrValuesStr, (String)" ");
        List amrValues = Util.splittedStringAsList((String)amrValuesStr, (String)" ");
        ResponseMode responseMode = ResponseMode.getByValue((String)respMode);
        User user = this.sessionUser != null && StringUtils.isNotBlank((String)this.sessionUser.getUserDn()) ? this.userService.getUserByDn(this.sessionUser.getUserDn(), new String[0]) : null;
        try {
            ClientAuthorizations clientAuthorizations;
            Claim userIdClaim;
            boolean validRedirectUri;
            this.sessionStateService.assertAuthenticatedSessionCorrespondsToNewRequest(this.sessionUser, redirectUri, acrValuesStr);
            if (!AuthorizeParamsValidator.validateParams(responseType, clientId, prompts, nonce, request, requestUri)) {
                if (clientId != null && redirectUri != null && this.redirectionUriService.validateRedirectionUri(clientId, redirectUri) != null) {
                    RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                    redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state));
                    builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                    return builder.build();
                }
                builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state));
                return builder.build();
            }
            Client client = this.clientService.getClient(clientId);
            JwtAuthorizationRequest jwtAuthorizationRequest = null;
            if (client == null) {
                builder = this.error(Response.Status.UNAUTHORIZED, AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state);
                return builder.build();
            }
            ArrayList<String> scopes = new ArrayList<String>();
            if (StringHelper.isNotEmpty((String)scope)) {
                Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(client, scope);
                scopes.addAll(grantedScopes);
            }
            boolean bl = validRedirectUri = (redirectUri = this.redirectionUriService.validateRedirectionUri(clientId, redirectUri)) != null;
            if (!AuthorizeParamsValidator.validateResponseTypes(responseTypes, client)) {
                builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNSUPPORTED_RESPONSE_TYPE, state));
                return builder.build();
            }
            if (!validRedirectUri) {
                builder = this.error(Response.Status.BAD_REQUEST, AuthorizeErrorResponseType.INVALID_REQUEST_REDIRECT_URI, state);
                return builder.build();
            }
            if (ConfigurationFactory.instance().getConfiguration().getFederationEnabled().booleanValue() && !this.federationDataService.hasAnyActiveTrust(client)) {
                this.log.debug((Object)"Forbid authorization. Client is not in any trust relationship however federation is enabled for server. Client id: {0}, client redirectUris: {1}", new Object[]{client.getClientId(), client.getRedirectUris()});
                return this.error(Response.Status.UNAUTHORIZED, AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state).build();
            }
            if (StringUtils.isNotBlank((String)accessToken)) {
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
                if (authorizationGrant == null) {
                    RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                    redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, state));
                    builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                    return builder.build();
                }
                user = this.userService.getUser(authorizationGrant.getUserId(), new String[0]);
                this.sessionUser = this.sessionStateService.generateAuthenticatedSessionState(user.getDn(), prompt);
            }
            if (StringUtils.isNotBlank((String)requestUri)) {
                boolean validRequestUri = false;
                try {
                    URI reqUri = new URI(requestUri);
                    String reqUriHash = reqUri.getFragment();
                    String reqUriWithoutFragment = reqUri.getScheme() + ":" + reqUri.getSchemeSpecificPart();
                    ClientRequest clientRequest = new ClientRequest(reqUriWithoutFragment);
                    clientRequest.setHttpMethod("GET");
                    ClientResponse clientResponse = clientRequest.get(String.class);
                    int status = clientResponse.getStatus();
                    if (status == 200) {
                        request = (String)clientResponse.getEntity(String.class);
                        if (StringUtils.isBlank((String)reqUriHash)) {
                            validRequestUri = true;
                        } else {
                            String hash = JwtUtil.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)request));
                            validRequestUri = StringUtils.equals((String)reqUriHash, (String)hash);
                        }
                    }
                    if (!validRequestUri) {
                        RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_URI, state));
                        builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                        return builder.build();
                    }
                    requestUri = null;
                }
                catch (URISyntaxException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                }
                catch (UnknownHostException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                }
                catch (ConnectException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                }
            }
            boolean invalidOpenidRequestObject = false;
            if (StringUtils.isNotBlank((String)request)) {
                try {
                    jwtAuthorizationRequest = new JwtAuthorizationRequest(request, client);
                    if (!jwtAuthorizationRequest.getResponseTypes().containsAll(responseTypes)) throw new InvalidJwtException("The responseType parameter is not the same in the JWT");
                    if (!responseTypes.containsAll(jwtAuthorizationRequest.getResponseTypes())) {
                        throw new InvalidJwtException("The responseType parameter is not the same in the JWT");
                    }
                    if (jwtAuthorizationRequest.getClientId() != null && !jwtAuthorizationRequest.getClientId().equals(clientId)) {
                        throw new InvalidJwtException("The clientId parameter is not the same in the JWT");
                    }
                    if (!jwtAuthorizationRequest.getScopes().containsAll(scopes)) throw new InvalidJwtException("The scope parameter is not the same in the JWT");
                    if (!scopes.containsAll(jwtAuthorizationRequest.getScopes())) {
                        throw new InvalidJwtException("The scope parameter is not the same in the JWT");
                    }
                    if (jwtAuthorizationRequest.getRedirectUri() != null && !jwtAuthorizationRequest.getRedirectUri().equals(redirectUri)) {
                        throw new InvalidJwtException("The redirectUri parameter is not the same in the JWT");
                    }
                    if (jwtAuthorizationRequest.getState() != null && StringUtils.isNotBlank((String)state) && !jwtAuthorizationRequest.getState().equals(state)) {
                        throw new InvalidJwtException("The state parameter is not the same in the JWT");
                    }
                    if (jwtAuthorizationRequest.getNonce() != null && StringUtils.isNotBlank((String)nonce) && !jwtAuthorizationRequest.getNonce().equals(nonce)) {
                        throw new InvalidJwtException("The nonce parameter is not the same in the JWT");
                    }
                    if (jwtAuthorizationRequest.getDisplay() != null && StringUtils.isNotBlank((String)display) && !jwtAuthorizationRequest.getDisplay().getParamName().equals(display)) {
                        throw new InvalidJwtException("The display parameter is not the same in the JWT");
                    }
                    if (!(jwtAuthorizationRequest.getPrompts().isEmpty() || prompts.isEmpty() || jwtAuthorizationRequest.getPrompts().containsAll(prompts))) {
                        throw new InvalidJwtException("The prompt parameter is not the same in the JWT");
                    }
                    if (jwtAuthorizationRequest.getIdTokenMember() != null && jwtAuthorizationRequest.getIdTokenMember().getMaxAge() != null && maxAge != null && !jwtAuthorizationRequest.getIdTokenMember().getMaxAge().equals(maxAge)) {
                        throw new InvalidJwtException("The maxAge parameter is not the same in the JWT");
                    }
                }
                catch (InvalidJwtException e) {
                    invalidOpenidRequestObject = true;
                    this.log.debug((Object)"Invalid JWT authorization request. Exception = {0}, Message = {1}", (Throwable)e, new Object[]{((Object)((Object)e)).getClass().getName(), e.getMessage()});
                }
                catch (Exception e) {
                    invalidOpenidRequestObject = true;
                    this.log.debug((Object)"Invalid JWT authorization request. Exception = {0}, Message = {1}", (Throwable)e, new Object[]{e.getClass().getName(), e.getMessage()});
                }
            }
            if (invalidOpenidRequestObject) {
                RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_OPENID_REQUEST_OBJECT, state));
                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                return builder.build();
            }
            AuthorizationGrant authorizationGrant = null;
            RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
            if (jwtAuthorizationRequest != null && jwtAuthorizationRequest.getIdTokenMember() != null && (userIdClaim = jwtAuthorizationRequest.getIdTokenMember().getClaim("sub")) != null && userIdClaim.getClaimValue() != null && userIdClaim.getClaimValue().getValue() != null) {
                String userId;
                String userIdClaimValue = userIdClaim.getClaimValue().getValue();
                if (user != null && !(userId = user.getUserId()).equalsIgnoreCase(userIdClaimValue)) {
                    redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.USER_MISMATCHED, state));
                    builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                    return builder.build();
                }
            }
            if (user == null) {
                this.identity.logout();
                if (prompts.contains(Prompt.NONE)) {
                    if (!this.authenticationFilterService.isEnabled()) {
                        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED, state));
                        builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                        return builder.build();
                    }
                    Map<String, String> params = method.equals("GET") ? QueryStringDecoder.decode(httpRequest.getQueryString()) : httpRequest.getParameterMap();
                    String userDn = this.authenticationFilterService.processAuthenticationFilters(params);
                    if (userDn == null) {
                        redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED, state));
                        builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                        return builder.build();
                    }
                    this.sessionUser = this.sessionStateService.generateAuthenticatedSessionState(userDn, prompt);
                    user = this.userService.getUserByDn(this.sessionUser.getUserDn(), new String[0]);
                    Authenticator authenticator = (Authenticator)Component.getInstance(Authenticator.class, (boolean)true);
                    authenticator.authenticateExternallyWebService(user.getUserId());
                    this.identity.addRole("user");
                } else {
                    if (prompts.contains(Prompt.LOGIN)) {
                        this.endSession(sessionState, httpRequest, httpResponse);
                        prompts.remove(Prompt.LOGIN);
                    }
                    this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders);
                    builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                    return builder.build();
                }
            }
            if ((clientAuthorizations = this.clientAuthorizationsService.findClientAuthorizations(user.getAttribute("inum"), client.getClientId())) != null && clientAuthorizations.getScopes() != null && Arrays.asList(clientAuthorizations.getScopes()).containsAll(scopes)) {
                this.sessionUser.addPermission(clientId, true);
            }
            if (prompts.contains(Prompt.NONE) && Boolean.parseBoolean(client.getTrustedClient())) {
                this.sessionUser.addPermission(clientId, true);
            }
            if (prompts.contains(Prompt.LOGIN)) {
                this.endSession(sessionState, httpRequest, httpResponse);
                prompts.remove(Prompt.LOGIN);
                this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders);
                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                return builder.build();
            }
            if (prompts.contains(Prompt.CONSENT) && !this.sessionUser.isPermissionGrantedForClient(clientId).booleanValue()) {
                prompts.remove(Prompt.CONSENT);
                this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders);
                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                return builder.build();
            }
            boolean validAuthenticationMaxAge = true;
            Integer authenticationMaxAge = null;
            if (maxAge != null) {
                authenticationMaxAge = maxAge;
            } else if (!invalidOpenidRequestObject && jwtAuthorizationRequest != null && jwtAuthorizationRequest.getIdTokenMember() != null && jwtAuthorizationRequest.getIdTokenMember().getMaxAge() != null) {
                authenticationMaxAge = jwtAuthorizationRequest.getIdTokenMember().getMaxAge();
            }
            GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            GregorianCalendar userAuthenticationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            userAuthenticationTime.setTime(this.sessionUser.getAuthenticationTime());
            if (authenticationMaxAge != null) {
                userAuthenticationTime.add(13, authenticationMaxAge);
                validAuthenticationMaxAge = userAuthenticationTime.after(now);
            } else if (client.getDefaultMaxAge() != null) {
                userAuthenticationTime.add(13, client.getDefaultMaxAge());
                validAuthenticationMaxAge = userAuthenticationTime.after(now);
            }
            if (!validAuthenticationMaxAge) {
                this.endSession(sessionState, httpRequest, httpResponse);
                this.redirectToAuthorizationPage(redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders);
                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                return builder.build();
            }
            if (!this.checkUserGroups(user, client)) {
                redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state));
                builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
                return builder.build();
            }
            AuthorizationCode authorizationCode = null;
            if (responseTypes.contains(ResponseType.CODE)) {
                authorizationGrant = this.authorizationGrantList.createAuthorizationCodeGrant(user, client, this.sessionUser.getAuthenticationTime());
                authorizationGrant.setNonce(nonce);
                authorizationGrant.setJwtAuthorizationRequest(jwtAuthorizationRequest);
                authorizationGrant.setScopes(scopes);
                authorizationGrant.setAcrValues(acrValuesStr);
                authorizationGrant.save();
                authorizationCode = authorizationGrant.getAuthorizationCode();
                redirectUriResponse.addResponseParameter("code", authorizationCode.getCode());
            }
            AccessToken newAccessToken = null;
            if (responseTypes.contains(ResponseType.TOKEN)) {
                if (authorizationGrant == null) {
                    authorizationGrant = this.authorizationGrantList.createImplicitGrant(user, client, this.sessionUser.getAuthenticationTime());
                    authorizationGrant.setNonce(nonce);
                    authorizationGrant.setJwtAuthorizationRequest(jwtAuthorizationRequest);
                    authorizationGrant.setScopes(scopes);
                    authorizationGrant.setAcrValues(acrValuesStr);
                    authorizationGrant.save();
                }
                newAccessToken = authorizationGrant.createAccessToken();
                redirectUriResponse.addResponseParameter("access_token", newAccessToken.getCode());
                redirectUriResponse.addResponseParameter("token_type", newAccessToken.getTokenType().toString());
                redirectUriResponse.addResponseParameter("expires_in", newAccessToken.getExpiresIn() + "");
            }
            if (responseTypes.contains(ResponseType.ID_TOKEN)) {
                if (authorizationGrant == null) {
                    authorizationGrant = this.authorizationGrantList.createAuthorizationGrant(user, client, this.sessionUser.getAuthenticationTime());
                    authorizationGrant.setNonce(nonce);
                    authorizationGrant.setJwtAuthorizationRequest(jwtAuthorizationRequest);
                    authorizationGrant.setScopes(scopes);
                    authorizationGrant.setAcrValues(acrValuesStr);
                    authorizationGrant.save();
                }
                IdToken idToken = authorizationGrant.createIdToken(nonce, authorizationCode, newAccessToken, authorizationGrant.getAcrValues());
                redirectUriResponse.addResponseParameter("id_token", idToken.getCode());
            }
            if (authorizationGrant != null && StringHelper.isNotEmpty((String)acrValuesStr)) {
                redirectUriResponse.addResponseParameter("acr_values", acrValuesStr);
            }
            if (this.sessionUser.getId() == null) {
                SessionState newSessionUser = this.sessionStateService.generateAuthenticatedSessionState(this.sessionUser.getUserDn(), prompt);
                String newSessionState = newSessionUser.getId();
                this.sessionUser.setId(newSessionState);
                this.log.trace((Object)"newSessionState = {0}", new Object[]{newSessionState});
            }
            redirectUriResponse.addResponseParameter("session_state", this.sessionUser.getId());
            redirectUriResponse.addResponseParameter("state", state);
            if (scope != null && !scope.isEmpty()) {
                scope = authorizationGrant.checkScopesPolicy(scope);
                redirectUriResponse.addResponseParameter("scope", scope);
            }
            this.clientService.updatAccessTime(client, false);
            builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
            return builder.build();
        }
        catch (EntryPersistenceException e) {
            builder = this.error(Response.Status.UNAUTHORIZED, AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state);
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return builder.build();
        }
        catch (SignatureException e) {
            builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return builder.build();
        }
        catch (StringEncrypter.EncryptionException e) {
            builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return builder.build();
        }
        catch (InvalidJwtException e) {
            builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return builder.build();
        }
        catch (Exception e) {
            builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return builder.build();
    }

    private void overrideUnauthenticatedSessionParameters(HttpServletRequest httpRequest, List<Prompt> prompts) {
        if (this.sessionUser != null && this.sessionUser.getState() != SessionIdState.AUTHENTICATED) {
            HashMap parameterMap = Maps.newHashMap((Map)httpRequest.getParameterMap());
            Map<String, String> requestParameterMap = this.authenticationService.getAllowedParameters(parameterMap);
            this.sessionUser.setUserDn(null);
            this.sessionUser.setSessionAttributes(requestParameterMap);
            boolean persisted = this.sessionStateService.persistSessionState(this.sessionUser, !prompts.contains(Prompt.NONE));
            if (persisted) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Session '{0}' persisted to LDAP", new Object[]{this.sessionUser.getId()});
                }
            } else {
                this.log.error((Object)"Failed to persisted session: {0}", new Object[]{this.sessionUser.getId()});
            }
        }
    }

    private Response.ResponseBuilder error(Response.Status p_status, AuthorizeErrorResponseType p_type, String p_state) {
        return Response.status((int)p_status.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)p_type, p_state));
    }

    private void redirectToAuthorizationPage(RedirectUri redirectUriResponse, List<ResponseType> responseTypes, String scope, String clientId, String redirectUri, String state, ResponseMode responseMode, String nonce, String display, List<Prompt> prompts, Integer maxAge, List<String> uiLocales, String idTokenHint, String loginHint, List<String> acrValues, List<String> amrValues, String request, String requestUri, String originHeaders) {
        String amrValuesStr;
        String acrValuesStr;
        String uiLocalesStr;
        String prompt;
        redirectUriResponse.setBaseRedirectUri(ConfigurationFactory.instance().getConfiguration().getAuthorizationPage());
        redirectUriResponse.setResponseMode(ResponseMode.QUERY);
        String responseType = org.xdi.oxauth.model.util.StringUtils.implode(responseTypes, (String)" ");
        if (StringUtils.isNotBlank((String)responseType)) {
            redirectUriResponse.addResponseParameter("response_type", responseType);
        }
        if (StringUtils.isNotBlank((String)scope)) {
            redirectUriResponse.addResponseParameter("scope", scope);
        }
        if (StringUtils.isNotBlank((String)clientId)) {
            redirectUriResponse.addResponseParameter("client_id", clientId);
        }
        if (StringUtils.isNotBlank((String)redirectUri)) {
            redirectUriResponse.addResponseParameter("redirect_uri", redirectUri);
        }
        if (StringUtils.isNotBlank((String)state)) {
            redirectUriResponse.addResponseParameter("state", state);
        }
        if (responseMode != null) {
            redirectUriResponse.addResponseParameter("response_mode", responseMode.getParamName());
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            redirectUriResponse.addResponseParameter("nonce", nonce);
        }
        if (StringUtils.isNotBlank((String)display)) {
            redirectUriResponse.addResponseParameter("display", display);
        }
        if (StringUtils.isNotBlank((String)(prompt = org.xdi.oxauth.model.util.StringUtils.implode(prompts, (String)" ")))) {
            redirectUriResponse.addResponseParameter("prompt", prompt);
        }
        if (maxAge != null) {
            redirectUriResponse.addResponseParameter("max_age", maxAge.toString());
        }
        if (StringUtils.isNotBlank((String)(uiLocalesStr = org.xdi.oxauth.model.util.StringUtils.implode(uiLocales, (String)" ")))) {
            redirectUriResponse.addResponseParameter("ui_locales", uiLocalesStr);
        }
        if (StringUtils.isNotBlank((String)idTokenHint)) {
            redirectUriResponse.addResponseParameter("id_token_hint", idTokenHint);
        }
        if (StringUtils.isNotBlank((String)loginHint)) {
            redirectUriResponse.addResponseParameter("login_hint", loginHint);
        }
        if (StringUtils.isNotBlank((String)(acrValuesStr = org.xdi.oxauth.model.util.StringUtils.implode(acrValues, (String)" ")))) {
            redirectUriResponse.addResponseParameter("acr_values", acrValuesStr);
        }
        if (StringUtils.isNotBlank((String)(amrValuesStr = org.xdi.oxauth.model.util.StringUtils.implode(amrValues, (String)" ")))) {
            redirectUriResponse.addResponseParameter("amr_values", amrValuesStr);
        }
        if (StringUtils.isNotBlank((String)request)) {
            redirectUriResponse.addResponseParameter("request", request);
        }
        if (StringUtils.isNotBlank((String)requestUri)) {
            redirectUriResponse.addResponseParameter("request_uri", requestUri);
        }
        if (StringUtils.isNotBlank((String)requestUri)) {
            redirectUriResponse.addResponseParameter("request_uri", requestUri);
        }
        if (StringUtils.isNotBlank((String)originHeaders)) {
            redirectUriResponse.addResponseParameter("origin_headers", originHeaders);
        }
    }

    private boolean checkUserGroups(User p_user, Client p_client) {
        if (p_client != null && p_client.hasUserGroups()) {
            String[] userGroups = p_client.getUserGroups();
            return this.userGroupService.isInAnyGroup(userGroups, p_user.getDn());
        }
        return true;
    }

    private void endSession(String sessionState, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.identity.logout();
        this.sessionUser.setUserDn(null);
        this.sessionUser.setAuthenticationTime(null);
        String id = sessionState;
        if (StringHelper.isEmpty((String)id)) {
            id = this.sessionStateService.getSessionStateFromCookie(httpRequest);
        }
        if (StringHelper.isNotEmpty((String)id)) {
            SessionState ldapSessionState = this.sessionStateService.getSessionState(id);
            if (ldapSessionState != null) {
                boolean result = this.sessionStateService.remove(ldapSessionState);
                if (!result) {
                    this.log.error((Object)"Failed to remove session_state '{0}' from LDAP", new Object[]{id});
                }
            } else {
                this.log.error((Object)"Failed to load session from LDAP by session_state: '{0}'", new Object[]{id});
            }
        }
        this.sessionStateService.removeSessionStateCookie(httpResponse);
    }
}

