/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.jboss.seam.log.Log;
import org.jboss.seam.resteasy.Application;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.SimplePrincipal;
import org.xdi.model.AuthenticationScriptUsageType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.oxauth.model.common.SessionIdState;
import org.xdi.oxauth.model.common.SessionState;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.session.OAuthCredentials;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.SessionStateService;
import org.xdi.oxauth.service.external.ExternalAuthenticationService;
import org.xdi.util.StringHelper;

@Name(value="authenticator")
@Scope(value=ScopeType.EVENT)
public class Authenticator
implements Serializable {
    private static final long serialVersionUID = 669395320060928092L;
    @Logger
    private Log log;
    @In
    private Identity identity;
    @In
    private OAuthCredentials credentials;
    @In
    private ClientService clientService;
    @In
    private SessionStateService sessionStateService;
    @In
    private AuthenticationService authenticationService;
    @In
    private ExternalAuthenticationService externalAuthenticationService;
    @In
    private FacesMessages facesMessages;
    private String authAcr;
    private Integer authStep;
    private boolean addedErrorMessage;

    public boolean authenticate() {
        if (!this.authenticateImpl(Contexts.getEventContext(), true, false)) {
            return this.authenticationFailed();
        }
        return true;
    }

    public String authenticateWithOutcome() {
        boolean result = this.authenticateImpl(Contexts.getEventContext(), true, false);
        if (result) {
            return "success";
        }
        return "failure";
    }

    public boolean authenticateWebService(boolean skipPassword) {
        return this.authenticateImpl(this.getWebServiceContext(), false, skipPassword);
    }

    public boolean authenticateWebService() {
        return this.authenticateImpl(this.getWebServiceContext(), false, false);
    }

    public Context getWebServiceContext() {
        return Contexts.getEventContext();
    }

    public boolean authenticateImpl(Context context, boolean interactive, boolean skipPassword) {
        boolean authenticated = false;
        try {
            authenticated = StringHelper.isNotEmpty((String)this.credentials.getUsername()) && (skipPassword || StringHelper.isNotEmpty((String)this.credentials.getPassword())) && this.credentials.getUsername().startsWith("@!") ? this.clientAuthentication(context, interactive, skipPassword) : (interactive ? this.userAuthenticationInteractive() : this.userAuthenticationService());
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        if (authenticated) {
            this.log.trace((Object)"Authentication successfully for '{0}'", new Object[]{this.credentials.getUsername()});
            return true;
        }
        this.log.info((Object)"Authentication failed for '{0}'", new Object[]{this.credentials.getUsername()});
        return false;
    }

    private boolean clientAuthentication(Context context, boolean interactive, boolean skipPassword) {
        boolean loggedIn;
        boolean isServiceUsesExternalAuthenticator;
        boolean bl = isServiceUsesExternalAuthenticator = !interactive && this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.SERVICE);
        if (isServiceUsesExternalAuthenticator) {
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.determineCustomScriptConfiguration(AuthenticationScriptUsageType.SERVICE, 1, this.authAcr);
            if (customScriptConfiguration == null) {
                this.log.error((Object)"Failed to get CustomScriptConfiguration. acr: '{0}'", new Object[]{this.authAcr});
            } else {
                this.authAcr = customScriptConfiguration.getCustomScript().getName();
                boolean result = this.externalAuthenticationService.executeExternalAuthenticate(customScriptConfiguration, null, 1);
                this.log.info((Object)"Authentication result for user '{0}', result: '{1}'", new Object[]{this.credentials.getUsername(), result});
                if (result) {
                    this.authenticationService.configureSessionClient(context);
                    this.log.info((Object)"Authentication success for client: '{0}'", new Object[]{this.credentials.getUsername()});
                    return true;
                }
            }
        }
        if (!(loggedIn = skipPassword)) {
            loggedIn = this.clientService.authenticate(this.credentials.getUsername(), this.credentials.getPassword());
        }
        if (loggedIn) {
            this.authenticationService.configureSessionClient(context);
            this.log.info((Object)"Authentication success for Client: '{0}'", new Object[]{this.credentials.getUsername()});
            return true;
        }
        return false;
    }

    private boolean userAuthenticationInteractive() {
        boolean authenticated;
        SessionState sessionState = this.sessionStateService.getSessionState();
        Map<String, String> sessionIdAttributes = this.sessionStateService.getSessionAttributes(sessionState);
        if (sessionIdAttributes == null) {
            this.log.error((Object)"Failed to get session attributes", new Object[0]);
            this.authenticationFailedSessionInvalid();
            return false;
        }
        Context eventContext = Contexts.getEventContext();
        eventContext.set("sessionAttributes", sessionIdAttributes);
        this.initCustomAuthenticatorVariables(sessionIdAttributes);
        boolean useExternalAuthenticator = this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE);
        if (useExternalAuthenticator && !StringHelper.isEmpty((String)this.authAcr)) {
            this.initCustomAuthenticatorVariables(sessionIdAttributes);
            if (this.authStep == null || StringHelper.isEmpty((String)this.authAcr)) {
                this.log.error((Object)"Failed to determine authentication mode", new Object[0]);
                this.authenticationFailedSessionInvalid();
                return false;
            }
            ExternalContext extCtx = FacesContext.getCurrentInstance().getExternalContext();
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, this.authAcr);
            if (customScriptConfiguration == null) {
                this.log.error((Object)"Failed to get CustomScriptConfiguration for acr: '{1}', auth_step: '{0}'", new Object[]{this.authAcr, this.authStep});
                return false;
            }
            boolean passedPreviousSteps = this.isPassedPreviousAuthSteps(sessionIdAttributes, this.authStep);
            if (!passedPreviousSteps) {
                this.log.error((Object)"There are authentication steps not marked as passed. acr: '{1}', auth_step: '{0}'", new Object[]{this.authAcr, this.authStep});
                return false;
            }
            boolean result = this.externalAuthenticationService.executeExternalAuthenticate(customScriptConfiguration, extCtx.getRequestParameterValuesMap(), this.authStep);
            this.log.debug((Object)"Authentication result for user '{0}'. auth_step: '{1}', result: '{2}'", new Object[]{this.credentials.getUsername(), this.authStep, result});
            if (!result) {
                return false;
            }
            int countAuthenticationSteps = this.externalAuthenticationService.executeExternalGetCountAuthenticationSteps(customScriptConfiguration);
            if (this.authStep < countAuthenticationSteps) {
                boolean updateResult;
                int nextStep = this.authStep + 1;
                String redirectTo = this.externalAuthenticationService.executeExternalGetPageForStep(customScriptConfiguration, nextStep);
                if (StringHelper.isEmpty((String)redirectTo)) {
                    return false;
                }
                this.updateExtraParameters(customScriptConfiguration, nextStep, sessionIdAttributes);
                sessionIdAttributes.put("auth_step", Integer.toString(nextStep));
                this.markAuthStepAsPassed(sessionIdAttributes, this.authStep);
                if (sessionState != null && !(updateResult = this.updateSession(sessionState, sessionIdAttributes))) {
                    return false;
                }
                this.log.trace((Object)"Redirect to page: '{0}'", new Object[]{redirectTo});
                FacesManager.instance().redirect(redirectTo, null, false);
                return true;
            }
            if (this.authStep == countAuthenticationSteps) {
                this.authenticationService.configureSessionUser(sessionState, sessionIdAttributes);
                SimplePrincipal principal = new SimplePrincipal(this.credentials.getUsername());
                this.identity.acceptExternallyAuthenticatedPrincipal((Principal)principal);
                this.identity.quietLogin();
                if (Events.exists()) {
                    this.log.debug((Object)"Sending event to trigger user redirection: '{0}'", new Object[]{this.credentials.getUsername()});
                    Events.instance().raiseEvent("org.xdi.oxauth.security.loginSuccessful", new Object[0]);
                }
                this.log.info((Object)"Authentication success for User: '{0}'", new Object[]{this.credentials.getUsername()});
                return true;
            }
        } else if (StringHelper.isNotEmpty((String)this.credentials.getUsername()) && (authenticated = this.authenticationService.authenticate(this.credentials.getUsername(), this.credentials.getPassword()))) {
            this.authenticationService.configureSessionUser(sessionState, sessionIdAttributes);
            if (Events.exists()) {
                this.log.debug((Object)"Sending event to trigger user redirection: '{0}'", new Object[]{this.credentials.getUsername()});
                Events.instance().raiseEvent("org.xdi.oxauth.security.loginSuccessful", new Object[0]);
            }
            this.log.info((Object)"Authentication success for User: '{0}'", new Object[]{this.credentials.getUsername()});
            return true;
        }
        return false;
    }

    private boolean updateSession(SessionState sessionState, Map<String, String> sessionIdAttributes) {
        sessionState.setSessionAttributes(sessionIdAttributes);
        boolean updateResult = this.sessionStateService.updateSessionState(sessionState, true, true);
        if (!updateResult) {
            this.log.debug((Object)"Failed to update session entry: '{0}'", new Object[]{sessionState.getId()});
            return false;
        }
        return true;
    }

    private boolean userAuthenticationService() {
        boolean authenticated;
        if (this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.SERVICE)) {
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.determineCustomScriptConfiguration(AuthenticationScriptUsageType.SERVICE, 1, this.authAcr);
            if (customScriptConfiguration == null) {
                this.log.error((Object)"Failed to get CustomScriptConfiguration. auth_step: '{0}', acr: '{1}'", new Object[]{this.authStep, this.authAcr});
            } else {
                this.authAcr = customScriptConfiguration.getName();
                boolean result = this.externalAuthenticationService.executeExternalAuthenticate(customScriptConfiguration, null, 1);
                this.log.info((Object)"Authentication result for '{0}'. auth_step: '{1}', result: '{2}'", new Object[]{this.credentials.getUsername(), this.authStep, result});
                if (result) {
                    this.authenticateExternallyWebService(this.credentials.getUsername());
                    this.authenticationService.configureEventUser();
                    this.log.info((Object)"Authentication success for User: '{0}'", new Object[]{this.credentials.getUsername()});
                    return true;
                }
            }
        }
        if (StringHelper.isNotEmpty((String)this.credentials.getUsername()) && (authenticated = this.authenticationService.authenticate(this.credentials.getUsername(), this.credentials.getPassword()))) {
            this.authenticateExternallyWebService(this.credentials.getUsername());
            this.authenticationService.configureEventUser();
            this.log.info((Object)"Authentication success for User: '{0}'", new Object[]{this.credentials.getUsername()});
            return true;
        }
        return false;
    }

    private void updateExtraParameters(CustomScriptConfiguration customScriptConfiguration, int step, Map<String, String> sessionIdAttributes) {
        List<String> extraParameters = this.externalAuthenticationService.executeExternalGetExtraParametersForStep(customScriptConfiguration, step);
        if (extraParameters != null) {
            for (String extraParameter : extraParameters) {
                if (!this.authenticationService.isParameterExists(extraParameter)) continue;
                String extraParameterValue = this.authenticationService.getParameterValue(extraParameter);
                sessionIdAttributes.put(extraParameter, extraParameterValue);
            }
        }
    }

    public String prepareAuthenticationForStep() {
        SessionState sessionState = this.sessionStateService.getSessionState();
        Map<String, String> sessionIdAttributes = this.sessionStateService.getSessionAttributes(sessionState);
        if (sessionIdAttributes == null) {
            this.log.error((Object)"Failed to get attributes from session", new Object[0]);
            return "expired";
        }
        Context eventContext = Contexts.getEventContext();
        eventContext.set("sessionAttributes", sessionIdAttributes);
        if (!this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE)) {
            return "success";
        }
        this.initCustomAuthenticatorVariables(sessionIdAttributes);
        if (StringHelper.isEmpty((String)this.authAcr)) {
            return "success";
        }
        if (this.authStep == null || this.authStep < 1) {
            return "no_permissions";
        }
        CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, this.authAcr);
        if (customScriptConfiguration == null) {
            this.log.error((Object)"Failed to get CustomScriptConfiguration. auth_step: '{0}', acr: '{1}'", new Object[]{this.authStep, this.authAcr});
            return "failure";
        }
        String currentauthAcr = customScriptConfiguration.getName();
        if ((customScriptConfiguration = this.externalAuthenticationService.determineExternalAuthenticatorForWorkflow(AuthenticationScriptUsageType.INTERACTIVE, customScriptConfiguration)) == null) {
            return "failure";
        }
        String determinedauthAcr = customScriptConfiguration.getName();
        if (!StringHelper.equalsIgnoreCase((String)currentauthAcr, (String)determinedauthAcr)) {
            boolean updateResult;
            CustomScriptConfiguration determinedCustomScriptConfiguration;
            String redirectTo = this.externalAuthenticationService.executeExternalGetPageForStep(customScriptConfiguration, this.authStep);
            if (StringHelper.isEmpty((String)redirectTo)) {
                redirectTo = "/login.xhtml";
            }
            if ((determinedCustomScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, determinedauthAcr)) == null) {
                this.log.error((Object)"Failed to get determined CustomScriptConfiguration. auth_step: '{0}', acr: '{1}'", new Object[]{this.authStep, this.authAcr});
                return "failure";
            }
            this.log.debug((Object)"Redirect to page: '{0}'. Force to use acr: '{1}'", new Object[]{redirectTo, determinedauthAcr});
            determinedauthAcr = determinedCustomScriptConfiguration.getName();
            String determinedAuthLevel = Integer.toString(determinedCustomScriptConfiguration.getLevel());
            sessionIdAttributes.put("acr", determinedauthAcr);
            sessionIdAttributes.put("auth_level", determinedAuthLevel);
            sessionIdAttributes.put("auth_step", Integer.toString(1));
            if (sessionState != null && !(updateResult = this.updateSession(sessionState, sessionIdAttributes))) {
                return "expired";
            }
            FacesManager.instance().redirect(redirectTo, null, false);
            return "success";
        }
        boolean passedPreviousSteps = this.isPassedPreviousAuthSteps(sessionIdAttributes, this.authStep);
        if (!passedPreviousSteps) {
            this.log.error((Object)"There are authentication steps not marked as passed. acr: '{1}', auth_step: '{0}'", new Object[]{this.authAcr, this.authStep});
            return "failure";
        }
        ExternalContext extCtx = FacesContext.getCurrentInstance().getExternalContext();
        Boolean result = this.externalAuthenticationService.executeExternalPrepareForStep(customScriptConfiguration, extCtx.getRequestParameterValuesMap(), this.authStep);
        if (result != null && result.booleanValue()) {
            boolean updateResult;
            this.updateExtraParameters(customScriptConfiguration, this.authStep, sessionIdAttributes);
            if (sessionState != null && !(updateResult = this.updateSession(sessionState, sessionIdAttributes))) {
                return "failure";
            }
            return "success";
        }
        return "failure";
    }

    public void authenticateExternallyWebService(String userName) {
        Application application = (Application)Component.getInstance(Application.class);
        if (application != null && !application.isDestroySessionAfterRequest()) {
            SimplePrincipal principal = new SimplePrincipal(userName);
            this.identity.acceptExternallyAuthenticatedPrincipal((Principal)principal);
            this.identity.quietLogin();
        }
    }

    public boolean authenticateBySessionState(String p_sessionState) {
        if (StringUtils.isNotBlank((String)p_sessionState) && ConfigurationFactory.instance().getConfiguration().getSessionIdEnabled().booleanValue()) {
            try {
                SessionState sessionState = this.sessionStateService.getSessionState(p_sessionState);
                return this.authenticateBySessionState(sessionState);
            }
            catch (Exception e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return false;
    }

    public boolean authenticateBySessionState(SessionState sessionState) {
        User user;
        if (sessionState == null) {
            return false;
        }
        String p_sessionState = sessionState.getId();
        this.log.trace((Object)"authenticateBySessionState, sessionState = '{0}', session = '{1}', state= '{2}'", new Object[]{p_sessionState, sessionState, sessionState.getState()});
        if (SessionIdState.AUTHENTICATED == sessionState.getState() && (user = this.authenticationService.getUserOrRemoveSession(sessionState)) != null) {
            try {
                this.authenticateExternallyWebService(user.getUserId());
                this.authenticationService.configureEventUser(sessionState);
            }
            catch (Exception e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            return true;
        }
        return false;
    }

    private void initCustomAuthenticatorVariables(Map<String, String> sessionIdAttributes) {
        if (sessionIdAttributes == null) {
            this.log.error((Object)"Failed to restore attributes from session attributes", new Object[0]);
            return;
        }
        this.authStep = StringHelper.toInteger((String)sessionIdAttributes.get("auth_step"), null);
        this.authAcr = sessionIdAttributes.get("acr");
    }

    private boolean authenticationFailed() {
        if (!this.addedErrorMessage) {
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.ERROR, "login.errorMessage", new Object[0]);
        }
        return false;
    }

    private void authenticationFailedSessionInvalid() {
        this.addedErrorMessage = true;
        this.facesMessages.addFromResourceBundle(StatusMessage.Severity.ERROR, "login.errorSessionInvalidMessage", new Object[0]);
        FacesManager.instance().redirect("/error.xhtml");
    }

    private void markAuthStepAsPassed(Map<String, String> sessionIdAttributes, Integer authStep) {
        String key = String.format("auth_step_passed_%d", authStep);
        sessionIdAttributes.put(key, Boolean.TRUE.toString());
    }

    private boolean isAuthStepPassed(Map<String, String> sessionIdAttributes, Integer authStep) {
        String key = String.format("auth_step_passed_%d", authStep);
        return sessionIdAttributes.containsKey(key) && Boolean.parseBoolean(sessionIdAttributes.get(key));
    }

    private boolean isPassedPreviousAuthSteps(Map<String, String> sessionIdAttributes, Integer authStep) {
        for (int i = 1; i < authStep; ++i) {
            boolean isAuthStepPassed = this.isAuthStepPassed(sessionIdAttributes, i);
            if (isAuthStepPassed) continue;
            return false;
        }
        return true;
    }

    public void configureSessionClient(Client client) {
        this.authenticationService.configureSessionClient(this.getWebServiceContext(), client);
    }
}

