/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.auth;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.Filter;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.NotLoggedInException;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.util.Base64;
import org.jboss.seam.web.AbstractFilter;
import org.xdi.oxauth.auth.Authenticator;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.SessionIdState;
import org.xdi.oxauth.model.common.SessionState;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.token.ClientAssertion;
import org.xdi.oxauth.model.token.ClientAssertionType;
import org.xdi.oxauth.model.token.TokenErrorResponseType;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.SessionStateService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.web.authenticationFilter")
@Install(value=false, precedence=0)
@BypassInterceptors
@Filter(within={"org.jboss.seam.web.exceptionFilter"})
public class AuthenticationFilter
extends AbstractFilter {
    @Logger
    private Log log;
    private String realm;
    public static final String REALM = "oxAuth";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, final FilterChain filterChain) throws IOException, ServletException {
        final HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        final HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        new ContextualHttpServletRequest(httpRequest){

            public void process() {
                try {
                    String requestUrl = httpRequest.getRequestURL().toString();
                    if (requestUrl.equals(ConfigurationFactory.instance().getConfiguration().getTokenEndpoint()) || AuthenticationFilter.this.isLocalEmbeddedTest(requestUrl)) {
                        if (httpRequest.getParameter("client_assertion") != null && httpRequest.getParameter("client_assertion_type") != null) {
                            AuthenticationFilter.this.processJwtAuth(httpRequest, httpResponse, filterChain);
                        } else if (httpRequest.getHeader("Authorization") != null && httpRequest.getHeader("Authorization").startsWith("Basic ")) {
                            AuthenticationFilter.this.processBasicAuth(httpRequest, httpResponse, filterChain);
                        } else {
                            AuthenticationFilter.this.processPostAuth(httpRequest, httpResponse, filterChain);
                        }
                    } else if (httpRequest.getHeader("Authorization") != null) {
                        String header = httpRequest.getHeader("Authorization");
                        if (header.startsWith("Bearer ")) {
                            AuthenticationFilter.this.processBearerAuth(httpRequest, httpResponse, filterChain);
                        } else if (header.startsWith("Basic ")) {
                            AuthenticationFilter.this.processBasicAuth(httpRequest, httpResponse, filterChain);
                        } else {
                            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + AuthenticationFilter.this.getRealm() + "\"");
                            httpResponse.sendError(401, "Not authorized");
                        }
                    } else {
                        SessionStateService sessionStateService = SessionStateService.instance();
                        String sessionState = httpRequest.getParameter("session_state");
                        if (StringUtils.isBlank((String)sessionState)) {
                            sessionState = sessionStateService.getSessionStateFromCookie(httpRequest);
                        }
                        SessionState sessionStateObject = null;
                        if (StringUtils.isNotBlank((String)sessionState)) {
                            sessionStateObject = sessionStateService.getSessionState(sessionState);
                        }
                        if (sessionStateObject != null && SessionIdState.AUTHENTICATED == sessionStateObject.getState()) {
                            AuthenticationFilter.this.processSessionAuth(sessionState, httpRequest, httpResponse, filterChain);
                        } else {
                            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                        }
                    }
                }
                catch (IOException ex) {
                    AuthenticationFilter.this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                }
                catch (Exception ex) {
                    AuthenticationFilter.this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                }
            }
        }.run();
    }

    private boolean isLocalEmbeddedTest(String requestUrl) {
        return Boolean.parseBoolean(System.getProperty("seam.local.test")) && requestUrl.equals("http://localhost:80/seam/resource/restv1/oxauth/token");
    }

    private void processSessionAuth(String p_sessionState, HttpServletRequest p_httpRequest, HttpServletResponse p_httpResponse, FilterChain p_filterChain) throws IOException, ServletException {
        boolean requireAuth = !this.getAuthenticator().authenticateBySessionState(p_sessionState);
        this.log.trace((Object)"Process Session Auth, sessionState = {0}, requireAuth = {1}", new Object[]{p_sessionState, requireAuth});
        if (!requireAuth) {
            try {
                p_filterChain.doFilter((ServletRequest)p_httpRequest, (ServletResponse)p_httpResponse);
            }
            catch (Exception ex) {
                this.log.error((Object)"Failed to process session authentication", (Throwable)ex, new Object[0]);
                requireAuth = true;
            }
        }
        if (requireAuth) {
            this.sendError(p_httpResponse);
        }
    }

    private void processBasicAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        Identity identity = Identity.instance();
        boolean requireAuth = true;
        try {
            String header = servletRequest.getHeader("Authorization");
            if (header != null && header.startsWith("Basic ")) {
                String base64Token = header.substring(6);
                String token = new String(Base64.decode((String)base64Token), "UTF-8");
                String username = "";
                String password = "";
                int delim = token.indexOf(":");
                if (delim != -1) {
                    username = token.substring(0, delim);
                    password = token.substring(delim + 1);
                }
                boolean bl = requireAuth = !StringHelper.equals((String)username, (String)identity.getCredentials().getUsername()) || !identity.isLoggedIn();
                if (!(!requireAuth || username.equals(identity.getCredentials().getUsername()) && identity.isLoggedIn())) {
                    Client client;
                    if (servletRequest.getRequestURI().endsWith("/token") && ((client = this.getClientService().getClient(username)) == null || AuthenticationMethod.CLIENT_SECRET_BASIC != client.getAuthenticationMethod())) {
                        throw new Exception("The Token Authentication Method is not valid.");
                    }
                    identity.getCredentials().setUsername(username);
                    identity.getCredentials().setPassword(password);
                    requireAuth = !this.getAuthenticator().authenticateWebService();
                }
            }
            try {
                if (!requireAuth) {
                    filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                    return;
                }
            }
            catch (NotLoggedInException ex) {
                requireAuth = true;
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.log.info((Object)"Basic authentication failed", (Throwable)ex, new Object[0]);
        }
        catch (ServletException ex) {
            this.log.info((Object)"Basic authentication failed", (Throwable)ex, new Object[0]);
        }
        catch (IOException ex) {
            this.log.info((Object)"Basic authentication failed", (Throwable)ex, new Object[0]);
        }
        catch (Exception ex) {
            this.log.info((Object)"Basic authentication failed", (Throwable)ex, new Object[0]);
        }
        try {
            if (requireAuth && !identity.isLoggedIn()) {
                this.sendError(servletResponse);
            }
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        }
    }

    private void processBearerAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        try {
            String header = servletRequest.getHeader("Authorization");
            if (header != null && header.startsWith("Bearer ")) {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
        }
        catch (ServletException ex) {
            this.log.info((Object)"Bearer authorization failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        catch (IOException ex) {
            this.log.info((Object)"Bearer authorization failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        catch (Exception ex) {
            this.log.info((Object)"Bearer authorization failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
    }

    private void processPostAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        try {
            Client client;
            boolean requireAuth;
            Identity identity = Identity.instance();
            String clientId = "";
            String clientSecret = "";
            boolean isExistUserPassword = false;
            if (StringHelper.isNotEmpty((String)servletRequest.getParameter("client_id")) && StringHelper.isNotEmpty((String)servletRequest.getParameter("client_secret"))) {
                clientId = servletRequest.getParameter("client_id");
                clientSecret = servletRequest.getParameter("client_secret");
                isExistUserPassword = true;
            }
            boolean bl = requireAuth = !StringHelper.equals((String)clientId, (String)identity.getCredentials().getUsername()) || !identity.isLoggedIn();
            if (requireAuth && isExistUserPassword && (client = this.getClientService().getClient(clientId)) != null && AuthenticationMethod.CLIENT_SECRET_POST == client.getAuthenticationMethod()) {
                if (!clientId.equals(identity.getCredentials().getUsername()) || !identity.isLoggedIn()) {
                    identity.logout();
                    identity.getCredentials().setUsername(clientId);
                    identity.getCredentials().setPassword(clientSecret);
                    requireAuth = !this.getAuthenticator().authenticateWebService();
                } else {
                    this.getAuthenticator().configureSessionClient(client);
                }
            }
            try {
                if (!requireAuth) {
                    filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                    return;
                }
            }
            catch (NotLoggedInException ex) {
                requireAuth = true;
            }
            if (requireAuth && !identity.isLoggedIn()) {
                this.sendError(servletResponse);
            }
        }
        catch (ServletException ex) {
            this.log.error((Object)"Post authentication failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        catch (IOException ex) {
            this.log.error((Object)"Post authentication failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        catch (Exception ex) {
            this.log.error((Object)"Post authentication failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
    }

    private void processJwtAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        boolean authorized = false;
        try {
            Identity identity = Identity.instance();
            if (servletRequest.getParameter("client_assertion") != null && servletRequest.getParameter("client_assertion_type") != null) {
                String clientId = servletRequest.getParameter("client_id");
                ClientAssertionType clientAssertionType = ClientAssertionType.fromString((String)servletRequest.getParameter("client_assertion_type"));
                String encodedAssertion = servletRequest.getParameter("client_assertion");
                if (clientAssertionType == ClientAssertionType.JWT_BEARER) {
                    ClientAssertion clientAssertion = new ClientAssertion(clientId, clientAssertionType, encodedAssertion);
                    String username = clientAssertion.getSubjectIdentifier();
                    String password = clientAssertion.getClientSecret();
                    if (!username.equals(identity.getCredentials().getUsername()) || !identity.isLoggedIn()) {
                        identity.getCredentials().setUsername(username);
                        identity.getCredentials().setPassword(password);
                        this.getAuthenticator().authenticateWebService(true);
                        authorized = true;
                    }
                }
            }
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (NotLoggedInException ex) {
            this.log.info((Object)"JWT authentication failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        catch (ServletException ex) {
            this.log.info((Object)"JWT authentication failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        catch (IOException ex) {
            this.log.info((Object)"JWT authentication failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        catch (InvalidJwtException ex) {
            this.log.info((Object)"JWT authentication failed: {0}", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        try {
            if (!authorized) {
                this.sendError(servletResponse);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(HttpServletResponse servletResponse) throws IOException {
        PrintWriter out = null;
        try {
            out = servletResponse.getWriter();
            ErrorResponseFactory errorResponseFactory = this.getErrorResponseFactory();
            servletResponse.setStatus(401);
            servletResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            servletResponse.setContentType("application/json;charset=UTF-8");
            out.write(errorResponseFactory.getErrorAsJson((IErrorType)TokenErrorResponseType.INVALID_CLIENT));
        }
        catch (IOException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        return REALM;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    private Authenticator getAuthenticator() {
        return (Authenticator)Component.getInstance(Authenticator.class, (boolean)true);
    }

    private ClientService getClientService() {
        return (ClientService)Component.getInstance(ClientService.class, (boolean)true);
    }

    private ErrorResponseFactory getErrorResponseFactory() {
        return (ErrorResponseFactory)Component.getInstance(ErrorResponseFactory.class, (boolean)true);
    }
}

