/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.fido.u2f;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.Configuration;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.fido.u2f.U2fConfiguration;
import org.xdi.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.xdi.oxauth.util.ServerUtil;

@Name(value="u2fMetaDataConfigurationRestWebService")
@Path(value="/oxauth/fido-u2f-configuration")
@Api(value="/.well-known/fido-u2f-configuration", description="The FIDO server endpoint that provides configuration data in a JSON [RFC4627] document that resides in at /.well-known/fido-u2f-configuration directory at its hostmeta [hostmeta] location. The configuration data documents conformance options and endpoints supported by the FIDO U2f server.")
public class U2fConfigurationWS {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Provides configuration data as json document. It contains options and endpoints supported by the FIDO U2F server.", response=U2fConfiguration.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Failed to build FIDO U2F configuration json object.")})
    public Response getConfiguration() {
        try {
            Configuration configuration = ConfigurationFactory.instance().getConfiguration();
            String baseEndpointUri = configuration.getBaseEndpoint();
            U2fConfiguration conf = new U2fConfiguration();
            conf.setVersion("1.0");
            conf.setIssuer(configuration.getIssuer());
            conf.setRegistrationEndpoint(baseEndpointUri + "/fido/u2f/registration");
            conf.setAuthenticationEndpoint(baseEndpointUri + "/fido/u2f/authentication");
            String entity = ServerUtil.asPrettyJson(conf);
            this.log.trace((Object)"FIDO U2F configuration: {0}", new Object[]{entity});
            return Response.ok((Object)entity).build();
        }
        catch (Throwable ex) {
            this.log.error((Object)ex.getMessage(), ex, new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }
}

