/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.ws.rs.core.CacheControl;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.oxauth.model.common.CustomAttribute;
import org.xdi.oxauth.model.uma.RegisterPermissionRequest;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.util.ArrayHelper;

public class ServerUtil {
    private static final Log LOG = Logging.getLog(ServerUtil.class);

    private ServerUtil() {
    }

    public static String asJsonSilently(Object p_object) {
        try {
            return ServerUtil.asJson(p_object);
        }
        catch (IOException e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return "";
        }
    }

    public static String asPrettyJson(Object p_object) throws IOException {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(p_object);
    }

    public static String asJson(Object p_object) throws IOException {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(p_object);
    }

    public static CacheControl cacheControl(boolean p_noStore) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(p_noStore);
        return cacheControl;
    }

    public static CacheControl cacheControl(boolean p_noStore, boolean p_noTransform) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(p_noStore);
        cacheControl.setNoTransform(p_noTransform);
        return cacheControl;
    }

    public static ObjectMapper createJsonMapper() {
        JaxbAnnotationIntrospector jaxb = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
        AnnotationIntrospector.Pair pair = new AnnotationIntrospector.Pair((AnnotationIntrospector)jackson, (AnnotationIntrospector)jaxb);
        ObjectMapper mapper = new ObjectMapper();
        mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)pair);
        mapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)pair);
        return mapper;
    }

    public static ObjectMapper jsonMapperWithWrapRoot() {
        return ServerUtil.createJsonMapper().configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, true);
    }

    public static ObjectMapper jsonMapperWithUnwrapRoot() {
        return ServerUtil.createJsonMapper().configure(DeserializationConfig.Feature.UNWRAP_ROOT_VALUE, true);
    }

    public static <T> T instance(Class p_clazz) {
        return (T)Component.getInstance((Class)p_clazz);
    }

    public static <T> T instance(String p_name) {
        return (T)Component.getInstance((String)p_name);
    }

    public static LdapEntryManager getLdapManager() {
        return (LdapEntryManager)ServerUtil.instance("ldapEntryManager");
    }

    public static CustomAttribute getAttributeByName(List<CustomAttribute> p_list, String p_attributeName) {
        if (p_list != null && !p_list.isEmpty() && StringUtils.isNotEmpty((String)p_attributeName)) {
            for (CustomAttribute attr : p_list) {
                if (!p_attributeName.equals(attr.getName())) continue;
                return attr;
            }
        }
        return null;
    }

    public static String getAttributeValueByName(List<CustomAttribute> p_list, String p_attributeName) {
        CustomAttribute attr = ServerUtil.getAttributeByName(p_list, p_attributeName);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public static String urlDecode(String p_str) {
        if (StringUtils.isNotBlank((String)p_str)) {
            try {
                return URLDecoder.decode(p_str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return p_str;
    }

    public static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable p_r) {
                Thread thread = new Thread(p_r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public static RegisterPermissionRequest convert(ResourceSetPermission p_permission, ScopeService p_umaScopeService) {
        if (p_permission != null) {
            RegisterPermissionRequest result = new RegisterPermissionRequest();
            result.setResourceSetId(p_permission.getResourceSetId());
            result.setScopes(p_umaScopeService.getScopeUrlsByDns(p_permission.getScopeDns()));
            result.setExpiresAt(p_permission.getExpirationDate());
            return result;
        }
        return null;
    }

    public static String getFirstValue(Map<String, String[]> map, String key) {
        Object[] values;
        if (map.containsKey(key) && ArrayHelper.isNotEmpty((Object[])(values = map.get(key)))) {
            return values[0];
        }
        return null;
    }
}

