/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.wordnik.swagger.annotations.Api;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.ScopeDescription;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.oxauth.util.ServerUtil;

@Path(value="/uma/scopes")
@Name(value="umaScopeRestWebService")
@Api(value="/uma/scopes", description="UMA Scope Endpoint provides scope description (json document) by scope id.")
public class ScopeWS {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private ScopeService umaScopeService;

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getScopeDescription(@PathParam(value="id") String id) {
        this.log.trace((Object)"UMA - get scope description: id: {0}", new Object[]{id});
        try {
            org.xdi.oxauth.model.uma.persistence.ScopeDescription scope;
            if (StringUtils.isNotBlank((String)id) && (scope = this.umaScopeService.getInternalScope(id)) != null) {
                ScopeDescription jsonScope = new ScopeDescription();
                jsonScope.setIconUri(scope.getIconUrl());
                jsonScope.setName(scope.getDisplayName());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)ServerUtil.asJson(jsonScope)).build();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
    }
}

