/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.Api;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.RptAuthorizationResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManager;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.service.uma.authorization.AuthorizationService;
import org.xdi.oxauth.util.ServerUtil;

@Path(value="/requester/perm")
@Api(value="/requester/perm", description="RPT authorization endpoint. RPT is authorized with new permission(s).")
@Name(value="rptPermissionAuthorizationRestWebService")
public class RptPermissionAuthorizationWS {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RPTManager rptManager;
    @In
    private ResourceSetPermissionManager resourceSetPermissionManager;
    @In
    private UmaValidationService umaValidationService;
    @In
    private AuthorizationService umaAuthorizationService;
    @In
    private FederationDataService federationDataService;
    @In
    private ClientService clientService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response requestRptPermissionAuthorization(@HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Host") String amHost, RptAuthorizationRequest rptAuthorizationRequest, @Context HttpServletRequest httpRequest) {
        try {
            AuthorizationGrant grant = this.umaValidationService.validateAuthorizationWithAuthScope(authorization);
            String validatedAmHost = this.umaValidationService.validateAmHost(amHost);
            UmaRPT rpt = this.authorizeRptPermission(authorization, rptAuthorizationRequest, httpRequest, grant, validatedAmHost);
            return Response.ok((Object)ServerUtil.asJson(new RptAuthorizationResponse(rpt.getCode()))).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private UmaRPT authorizeRptPermission(String authorization, RptAuthorizationRequest rptAuthorizationRequest, HttpServletRequest httpRequest, AuthorizationGrant grant, String amHost) {
        UmaRPT rpt = Strings.isNullOrEmpty((String)rptAuthorizationRequest.getRpt()) ? this.rptManager.createRPT(authorization, amHost) : this.rptManager.getRPTByCode(rptAuthorizationRequest.getRpt());
        try {
            this.umaValidationService.validateRPT(rpt);
        }
        catch (WebApplicationException e) {
            rpt = this.rptManager.getRPTByCode(rptAuthorizationRequest.getRpt());
        }
        ResourceSetPermission resourceSetPermission = this.resourceSetPermissionManager.getResourceSetPermissionByTicket(rptAuthorizationRequest.getTicket());
        this.umaValidationService.validateResourceSetPermission(resourceSetPermission);
        Boolean federationEnabled = ConfigurationFactory.instance().getConfiguration().getFederationEnabled();
        if (federationEnabled != null && federationEnabled.booleanValue()) {
            Client client = this.clientService.getClient(rpt.getClientId());
            List<FederationTrust> trustList = this.federationDataService.getTrustByClient(client, FederationTrustStatus.ACTIVE);
            if (trustList != null && !trustList.isEmpty()) {
                for (FederationTrust t : trustList) {
                    Boolean skipAuthorization = t.getSkipAuthorization();
                    if (skipAuthorization == null || !skipAuthorization.booleanValue()) continue;
                    this.log.trace((Object)"grant access directly, client is in trust and skipAuthorization=true", new Object[0]);
                    this.rptManager.addPermissionToRPT(rpt, resourceSetPermission);
                    return rpt;
                }
            } else {
                this.log.trace((Object)"Forbid RPT authorization - client is not in any trust however federation is enabled on server.", new Object[0]);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_AUTHORIZED_PERMISSION)).build());
            }
        }
        if (this.umaAuthorizationService.allowToAddPermission(grant, rpt, resourceSetPermission, httpRequest, rptAuthorizationRequest)) {
            this.rptManager.addPermissionToRPT(rpt, resourceSetPermission);
            return rpt;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_AUTHORIZED_PERMISSION)).build());
    }
}

