/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.RPTResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.util.ServerUtil;

@Path(value="/requester/rpt")
@Api(value="/requester/rpt", description="The endpoint at which the requester asks the AM to issue an RPT")
@Name(value="rptRestWebService")
public class CreateRptWS {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RPTManager rptManager;
    @In
    private UmaValidationService umaValidationService;

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="The endpoint at which the requester asks the AM to issue an RPT", produces="application/json", notes="The endpoint at which the requester asks the AM to issue an RPT")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public Response getRequesterPermissionToken(@HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Host") String amHost) {
        try {
            this.umaValidationService.validateAuthorizationWithAuthScope(authorization);
            String validatedAmHost = this.umaValidationService.validateAmHost(amHost);
            return this.createRpt(authorization, validatedAmHost);
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private Response createRpt(String authorization, String amHost) throws IOException {
        UmaRPT rpt = this.rptManager.createRPT(authorization, amHost);
        String entity = ServerUtil.asJson(new RPTResponse(rpt.getCode()));
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.CREATED);
        builder.entity((Object)entity);
        return builder.build();
    }
}

