/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.RegisterPermissionRequest;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.UmaScopeType;
import org.xdi.oxauth.model.uma.persistence.ResourceSet;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.ResourceSetService;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="umaValidationService")
@AutoCreate
public class UmaValidationService {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private TokenService tokenService;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ResourceSetService resourceSetService;
    @In
    private ScopeService umaScopeService;
    @In
    private FederationDataService federationDataService;

    public String validateAmHost(String host) {
        if (StringHelper.isEmpty((String)host)) {
            this.log.error((Object)"AM host is invalid", new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_REQUEST)).build());
        }
        try {
            new URI(host);
        }
        catch (URISyntaxException ex) {
            this.log.error((Object)"Failed to parse AM host: '{0}'", (Throwable)ex, new Object[]{host});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_REQUEST)).build());
        }
        try {
            URI umaBaseEndpoint = new URI(ConfigurationFactory.instance().getConfiguration().getBaseEndpoint());
            if (!StringHelper.equalsIgnoreCase((String)host, (String)umaBaseEndpoint.getHost())) {
                this.log.error((Object)"Get request for another AM: '{0}'", new Object[]{host});
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_REQUEST)).build());
            }
        }
        catch (URISyntaxException ex) {
            this.log.error((Object)"Failed to parse AM host: '{0}'", (Throwable)ex, new Object[]{host});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_REQUEST)).build());
        }
        return StringHelper.toLowerCase((String)host).trim();
    }

    public String validateHost(String host) {
        if (StringHelper.isEmpty((String)host)) {
            this.log.error((Object)"Host is invalid", new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_REQUEST)).build());
        }
        try {
            new URI(host);
        }
        catch (URISyntaxException ex) {
            this.log.error((Object)"Failed to parse host: '{0}'", (Throwable)ex, new Object[]{host});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_REQUEST)).build());
        }
        return StringHelper.toLowerCase((String)host).trim();
    }

    public AuthorizationGrant validateAuthorizationWithProtectScope(String authorization) {
        return this.validateAuthorization(authorization, UmaScopeType.PROTECTION);
    }

    public AuthorizationGrant validateAuthorizationWithAuthScope(String authorization) {
        return this.validateAuthorization(authorization, UmaScopeType.AUTHORIZATION);
    }

    private AuthorizationGrant validateAuthorization(String authorization, UmaScopeType umaScopeType) {
        List<FederationTrust> list;
        this.log.trace((Object)"Validate authorization: {0}", new Object[]{authorization});
        if (StringHelper.isEmpty((String)authorization)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.UNAUTHORIZED_CLIENT)).build());
        }
        String token = this.tokenService.getTokenFromAuthorizationParameter(authorization);
        if (StringHelper.isEmpty((String)token)) {
            this.log.debug((Object)"Token is invalid", new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.UNAUTHORIZED_CLIENT)).build());
        }
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
        if (authorizationGrant == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.ACCESS_DENIED)).build());
        }
        if (!authorizationGrant.isValid()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_TOKEN)).build());
        }
        Client client = authorizationGrant.getClient();
        if (ConfigurationFactory.instance().getConfiguration().getFederationEnabled().booleanValue() && ((list = this.federationDataService.getTrustByClient(client, FederationTrustStatus.ACTIVE)) == null || list.isEmpty())) {
            this.log.error((Object)"Client is not in any federation trust, client: {0}", new Object[]{client.getDn()});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.CLIENT_NOT_IN_FEDERATED_TRUST)).build());
        }
        Set<String> scopes = authorizationGrant.getScopes();
        if (!scopes.contains(umaScopeType.getValue())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_CLIENT_SCOPE)).build());
        }
        return authorizationGrant;
    }

    public void validateRPT(UmaRPT requesterPermissionToken) {
        if (requesterPermissionToken == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_AUTHORIZED_PERMISSION)).build());
        }
        requesterPermissionToken.checkExpired();
        if (!requesterPermissionToken.isValid()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_AUTHORIZED_PERMISSION)).build());
        }
    }

    public void validateResourceSetPermission(ResourceSetPermission resourceSetPermission) {
        if (resourceSetPermission == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_TICKET)).build());
        }
        resourceSetPermission.checkExpired();
        if (!resourceSetPermission.isValid()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.EXPIRED_TICKET)).build());
        }
    }

    public void validateResourceSet(RegisterPermissionRequest resourceSetPermissionRequest) {
        ResourceSet resourceSet;
        String resourceSetId = resourceSetPermissionRequest.getResourceSetId();
        if (StringHelper.isEmpty((String)resourceSetId)) {
            this.log.error((Object)"Resource set id is empty", new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_RESOURCE_SET_ID)).build());
        }
        try {
            ResourceSet exampleResourceSet = new ResourceSet();
            exampleResourceSet.setDn(this.resourceSetService.getBaseDnForResourceSet());
            exampleResourceSet.setId(resourceSetId);
            List<ResourceSet> resourceSets = this.resourceSetService.findResourceSets(exampleResourceSet);
            if (resourceSets.size() != 1) {
                this.log.error((Object)"Resource set isn't registered or there are two resource set with same Id", new Object[0]);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_RESOURCE_SET_ID)).build());
            }
            resourceSet = resourceSets.get(0);
        }
        catch (EntryPersistenceException ex) {
            this.log.error((Object)"Resource set isn't registered", new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_RESOURCE_SET_ID)).build());
        }
        List<String> scopeUrls = this.umaScopeService.getScopeUrlsByDns(resourceSet.getScopes());
        if (!scopeUrls.containsAll(resourceSetPermissionRequest.getScopes())) {
            this.log.error((Object)"At least one of the scope isn't registered", new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_RESOURCE_SET_SCOPE)).build());
        }
    }
}

