/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.StaticUtils;
import java.util.Date;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.uma.AbstractResourceSetPermissionManager;
import org.xdi.oxauth.util.ServerUtil;

public class ResourceSetPermissionManagerLdap
extends AbstractResourceSetPermissionManager {
    private static final String ORGUNIT_OF_RESOURCE_SET_PERMISSION = "uma_resource_set_permission";
    private static final Log LOG = Logging.getLog(ResourceSetPermissionManagerLdap.class);
    private final LdapEntryManager ldapEntryManager = ServerUtil.getLdapManager();

    @Override
    public void addResourceSetPermission(ResourceSetPermission resourceSetPermission, String clientDn) {
        try {
            this.addBranchIfNeeded(clientDn);
            resourceSetPermission.setDn(ResourceSetPermissionManagerLdap.getDn(clientDn, resourceSetPermission.getTicket()));
            this.ldapEntryManager.persist((Object)resourceSetPermission);
        }
        catch (Exception e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public ResourceSetPermission getResourceSetPermissionByTicket(String p_ticket) {
        try {
            String baseDn = ConfigurationFactory.instance().getBaseDn().getClients();
            Filter filter = Filter.create((String)String.format("&(oxTicket=%s)", p_ticket));
            List entries = this.ldapEntryManager.findEntries(baseDn, ResourceSetPermission.class, filter);
            if (entries != null && !entries.isEmpty()) {
                return (ResourceSetPermission)entries.get(0);
            }
        }
        catch (Exception e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    @Override
    public String getResourceSetPermissionTicketByConfigurationCode(String configurationCode, String clientDn) {
        ResourceSetPermission permission = this.getResourceSetPermissionByConfigurationCode(configurationCode, clientDn);
        if (permission != null) {
            return permission.getTicket();
        }
        return null;
    }

    public ResourceSetPermission getResourceSetPermissionByConfigurationCode(String p_configurationCode, String clientDn) {
        try {
            Filter filter = Filter.create((String)String.format("&(oxConfigurationCode=%s)", p_configurationCode));
            List entries = this.ldapEntryManager.findEntries(clientDn, ResourceSetPermission.class, filter);
            if (entries != null && !entries.isEmpty()) {
                return (ResourceSetPermission)entries.get(0);
            }
        }
        catch (Exception e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    @Override
    public void deleteResourceSetPermission(String p_ticket) {
        try {
            ResourceSetPermission permission = this.getResourceSetPermissionByTicket(p_ticket);
            if (permission != null) {
                this.ldapEntryManager.remove((Object)permission);
            }
        }
        catch (Exception e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void cleanupResourceSetPermissions(Date now) {
        try {
            Filter filter = Filter.create((String)String.format("(oxAuthExpiration<=%s)", StaticUtils.encodeGeneralizedTime((Date)now)));
            List entries = this.ldapEntryManager.findEntries(ConfigurationFactory.instance().getBaseDn().getClients(), ResourceSetPermission.class, filter);
            if (entries != null && !entries.isEmpty()) {
                for (ResourceSetPermission p : entries) {
                    this.ldapEntryManager.remove((Object)p);
                }
            }
        }
        catch (Exception e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void addBranch(String clientDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ORGUNIT_OF_RESOURCE_SET_PERMISSION);
        branch.setDn(ResourceSetPermissionManagerLdap.getBranchDn(clientDn));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addBranchIfNeeded(String clientDn) {
        if (!this.containsBranch(clientDn)) {
            this.addBranch(clientDn);
        }
    }

    public boolean containsBranch(String clientDn) {
        return this.ldapEntryManager.contains(SimpleBranch.class, ResourceSetPermissionManagerLdap.getBranchDn(clientDn));
    }

    public static String getDn(String clientDn, String ticket) {
        return String.format("oxTicket=%s,%s", ticket, ResourceSetPermissionManagerLdap.getBranchDn(clientDn));
    }

    public static String getBranchDn(String clientDn) {
        return String.format("ou=%s,%s", ORGUNIT_OF_RESOURCE_SET_PERMISSION, clientDn);
    }
}

