/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.uma.AbstractRPTManager;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManager;
import org.xdi.oxauth.util.ServerUtil;

public class RPTManagerInMemory
extends AbstractRPTManager
implements Serializable {
    private static final long serialVersionUID = -5437567020929600776L;
    private final ConcurrentHashMap<String, UmaRPT> codeToRPT = new ConcurrentHashMap();
    private final ResourceSetPermissionManager permissionManager = (ResourceSetPermissionManager)ServerUtil.instance(ResourceSetPermissionManager.class);

    @Override
    public void addRPT(UmaRPT requesterPermissionToken, String clientDn) {
        String requesterPermissionTokenKey = requesterPermissionToken.getCode();
        this.codeToRPT.remove(requesterPermissionTokenKey);
        this.codeToRPT.put(requesterPermissionToken.getCode(), requesterPermissionToken);
    }

    @Override
    public UmaRPT getRPTByCode(String requesterPermissionTokenCode) {
        return this.codeToRPT.get(requesterPermissionTokenCode);
    }

    @Override
    public void deleteRPT(String rptCode) {
        this.codeToRPT.remove(rptCode);
    }

    @Override
    public void cleanupRPTs(Date now) {
        Iterator<Map.Entry<String, UmaRPT>> it = this.codeToRPT.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, UmaRPT> requesterPermissionTokenEntry = it.next();
            UmaRPT requesterPermissionToken = requesterPermissionTokenEntry.getValue();
            requesterPermissionToken.checkExpired(now);
            if (requesterPermissionToken.isValid()) continue;
            it.remove();
        }
    }

    @Override
    public synchronized void addPermissionToRPT(UmaRPT p_rpt, ResourceSetPermission p_permission) {
        ArrayList<String> list = new ArrayList<String>(p_rpt.getPermissions());
        list.add(p_permission.getTicket());
        p_rpt.setPermissions(list);
    }

    @Override
    public List<ResourceSetPermission> getRptPermissions(UmaRPT p_rpt) {
        ArrayList<ResourceSetPermission> result = new ArrayList<ResourceSetPermission>();
        List<String> permissionTickets = p_rpt.getPermissions();
        if (permissionTickets != null && !permissionTickets.isEmpty()) {
            for (String ticket : permissionTickets) {
                ResourceSetPermission permission = this.permissionManager.getResourceSetPermissionByTicket(ticket);
                if (permission == null) continue;
                result.add(permission);
            }
        }
        return result;
    }

    @Override
    public UmaRPT createRPT(String authorization, String amHost) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResourceSetPermission getPermissionFromRPTByResourceSetId(UmaRPT p_rpt, String p_resourceSetId) {
        List<String> permissionTickets = p_rpt.getPermissions();
        if (StringUtils.isNotBlank((String)p_resourceSetId) && permissionTickets != null && !permissionTickets.isEmpty()) {
            for (String ticket : permissionTickets) {
                ResourceSetPermission permission = this.permissionManager.getResourceSetPermissionByTicket(ticket);
                if (permission == null || !p_resourceSetId.equals(permission.getResourceSetId())) continue;
                return permission;
            }
        }
        return null;
    }
}

