/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.status.ldap;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;

@Name(value="ldapStatusTimer")
@AutoCreate
@Scope(value=ScopeType.APPLICATION)
public class LdapStatusTimer {
    private static final String EVENT_TYPE = "LdapStatusTimerEvent";
    private static final long DEFAULT_INTERVAL = 60000L;
    @Logger
    private Log log;
    private AtomicBoolean isActive;

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void init() {
        this.log.debug((Object)"Initializing LdapStatusTimer", new Object[0]);
        this.isActive = new AtomicBoolean(false);
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(60000L), Long.valueOf(60000L)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"LdapStatusTimerEvent"})
    @Asynchronous
    public void process() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processInt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void processInt() {
        LdapEntryManager ldapEntryManager = (LdapEntryManager)Component.getInstance((String)"ldapEntryManager", (ScopeType)ScopeType.APPLICATION);
        List ldapAuthEntryManagers = (List)Component.getInstance((String)"ldapAuthEntryManager", (ScopeType)ScopeType.APPLICATION);
        this.logConnectionProviderStatistic(ldapEntryManager, "connectionProvider", "bindConnectionProvider");
        for (int i = 0; i < ldapAuthEntryManagers.size(); ++i) {
            LdapEntryManager ldapAuthEntryManager = (LdapEntryManager)ldapAuthEntryManagers.get(i);
            this.logConnectionProviderStatistic(ldapAuthEntryManager, "authConnectionProvider#" + i, "bindAuthConnectionProvider#i");
        }
    }

    public void logConnectionProviderStatistic(LdapEntryManager ldapEntryManager, String connectionProviderName, String bindConnectionProviderName) {
        LDAPConnectionProvider ldapConnectionProvider = ldapEntryManager.getLdapOperationService().getConnectionProvider();
        LDAPConnectionProvider bindLdapConnectionProvider = ldapEntryManager.getLdapOperationService().getBindConnectionProvider();
        if (ldapConnectionProvider == null) {
            this.log.error((Object)"{0} is empty", new Object[]{connectionProviderName});
        } else if (ldapConnectionProvider.getConnectionPool() == null) {
            this.log.error((Object)"{0} is empty", new Object[]{connectionProviderName});
        } else {
            this.log.debug((Object)"{0} statistics: {1}", new Object[]{connectionProviderName, ldapConnectionProvider.getConnectionPool().getConnectionPoolStatistics()});
        }
        if (bindLdapConnectionProvider == null) {
            this.log.error((Object)"{0} is empty", new Object[]{bindConnectionProviderName});
        } else if (bindLdapConnectionProvider.getConnectionPool() == null) {
            this.log.error((Object)"{0} is empty", new Object[]{bindConnectionProviderName});
        } else {
            this.log.debug((Object)"{0} statistics: {1}", new Object[]{bindConnectionProviderName, bindLdapConnectionProvider.getConnectionPool().getConnectionPoolStatistics()});
        }
    }
}

