/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;

@Scope(value=ScopeType.STATELESS)
@Name(value="clientDataValidationService")
@AutoCreate
public class ClientDataValidationService {
    @Logger
    private Log log;

    public void checkContent(ClientData clientData, String type, String challenge, Set<String> facets) throws BadInputException {
        if (!type.equals(clientData.getTyp())) {
            throw new BadInputException("Bad clientData: wrong typ " + clientData.getTyp());
        }
        if (!challenge.equals(clientData.getChallenge())) {
            throw new BadInputException("Bad clientData: wrong challenge");
        }
        if (facets != null && !facets.isEmpty()) {
            String canonicalOrigin;
            Set<String> allowedFacets = ClientDataValidationService.canonicalizeOrigins(facets);
            try {
                canonicalOrigin = ClientDataValidationService.canonicalizeOrigin(clientData.getOrigin());
            }
            catch (RuntimeException e) {
                throw new BadInputException("Bad clientData: Malformed origin", (Throwable)e);
            }
            ClientDataValidationService.verifyOrigin(canonicalOrigin, allowedFacets);
        }
    }

    private static void verifyOrigin(String origin, Set<String> allowedOrigins) throws BadInputException {
        if (!allowedOrigins.contains(origin)) {
            throw new BadInputException(origin + " is not a recognized facet for this application");
        }
    }

    public static Set<String> canonicalizeOrigins(Set<String> origins) {
        HashSet<String> result = new HashSet<String>();
        for (String origin : origins) {
            result.add(ClientDataValidationService.canonicalizeOrigin(origin));
        }
        return result;
    }

    public static String canonicalizeOrigin(String url) {
        try {
            URI uri = new URI(url);
            if (uri.getAuthority() == null) {
                return url;
            }
            return uri.getScheme() + "://" + uri.getAuthority();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Specified bad origin", e);
        }
    }
}

