/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external.context;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.net.util.SubnetUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.ldap.model.CustomEntry;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

public class ExternalScriptContext {
    private static final Log log = Logging.getLog(ExternalScriptContext.class);
    private LdapEntryManager ldapEntryManager = ServerUtil.getLdapManager();
    protected HttpServletRequest httpRequest;

    public ExternalScriptContext(HttpServletRequest httpRequest) {
        ExternalContext extCtx;
        FacesContext facesContext;
        this.httpRequest = httpRequest;
        if (this.httpRequest == null && (facesContext = FacesContext.getCurrentInstance()) != null && (extCtx = facesContext.getExternalContext()) != null) {
            this.httpRequest = (HttpServletRequest)extCtx.getRequest();
        }
    }

    public Log getLog() {
        return log;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public String getIpAddress() {
        return this.httpRequest != null ? this.httpRequest.getRemoteAddr() : "";
    }

    public boolean isInNetwork(String cidrNotation) {
        String ip = this.getIpAddress();
        if (Util.allNotBlank((String[])new String[]{ip, cidrNotation})) {
            SubnetUtils utils = new SubnetUtils(cidrNotation);
            return utils.getInfo().isInRange(ip);
        }
        return false;
    }

    protected CustomEntry getEntryByDn(String dn, String ... ldapReturnAttributes) {
        try {
            return (CustomEntry)this.ldapEntryManager.find(CustomEntry.class, (Object)dn, ldapReturnAttributes);
        }
        catch (EntryPersistenceException epe) {
            log.error((Object)"Failed to find entry '{0}'", new Object[]{dn});
            return null;
        }
    }

    protected String getEntryAttributeValue(String dn, String attributeName) {
        CustomEntry entry = this.getEntryByDn(dn, attributeName);
        if (entry != null) {
            String attributeValue = entry.getCustomAttributeValue(attributeName);
            return attributeValue;
        }
        return "";
    }
}

