/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external;

import java.util.List;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.custom.script.type.scope.DynamicScopeType;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.token.JsonWebResponse;
import org.xdi.oxauth.service.external.context.DynamicScopeExternalContext;
import org.xdi.service.custom.script.ExternalScriptService;

@Scope(value=ScopeType.APPLICATION)
@Name(value="externalDynamicScopeService")
@AutoCreate
@Startup
public class ExternalDynamicScopeService
extends ExternalScriptService {
    private static final long serialVersionUID = 1416361273036208685L;

    public ExternalDynamicScopeService() {
        super(CustomScriptType.DYNAMIC_SCOPE);
    }

    public boolean executeExternalUpdateMethod(CustomScriptConfiguration customScriptConfiguration, DynamicScopeExternalContext dynamicScopeContext) {
        try {
            this.log.debug((Object)"Executing python 'update' method", new Object[0]);
            DynamicScopeType dynamicScopeType = (DynamicScopeType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return dynamicScopeType.update((Object)dynamicScopeContext, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public boolean executeExternalUpdateMethods(List<String> dynamicScopes, JsonWebResponse jsonToken, User user) {
        DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, jsonToken, user);
        return this.executeExternalUpdateMethods(dynamicScopeContext);
    }

    public boolean executeExternalUpdateMethods(DynamicScopeExternalContext dynamicScopeContext) {
        boolean result = true;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (result &= this.executeExternalUpdateMethod(customScriptConfiguration, dynamicScopeContext)) continue;
            return result;
        }
        return result;
    }

    public static ExternalDynamicScopeService instance() {
        return (ExternalDynamicScopeService)((Object)Component.getInstance(ExternalDynamicScopeService.class));
    }
}

