/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.StaticUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.SessionIdState;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.AcrChangedException;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="sessionIdService")
@AutoCreate
public class SessionIdService {
    private static final String SESSION_ID_COOKIE_NAME = "session_id";
    private static final String STORED_ORIGIN_PARAMETERS = "stored_origin_parameters";
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private AuthenticationService authenticationService;

    public static SessionIdService instance() {
        if (!Contexts.isEventContextActive() && !Contexts.isApplicationContextActive()) {
            Lifecycle.beginCall();
        }
        return (SessionIdService)Component.getInstance(SessionIdService.class);
    }

    public SessionId updateSessionIfNeeded(SessionId session, String redirectUri, String acrValuesStr) throws AcrChangedException {
        if (session != null && !session.getSessionAttributes().isEmpty()) {
            boolean isAcrChanged;
            Map<String, String> sessionAttributes = session.getSessionAttributes();
            boolean bl = isAcrChanged = acrValuesStr != null && !acrValuesStr.equals(sessionAttributes.get("acr_values"));
            if (isAcrChanged) {
                throw new AcrChangedException();
            }
            Map<String, String> currentSessionAttributes = this.getCurrentSessionAttributes(sessionAttributes);
            if (!currentSessionAttributes.equals(sessionAttributes)) {
                sessionAttributes.putAll(currentSessionAttributes);
                sessionAttributes.put("auth_step", "1");
                Iterator<Map.Entry<String, String>> it = currentSessionAttributes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> currentSessionAttributesEntry = it.next();
                    String name = currentSessionAttributesEntry.getKey();
                    if (!name.startsWith("auth_step_passed_")) continue;
                    it.remove();
                }
                session.setSessionAttributes(currentSessionAttributes);
                boolean updateResult = this.updateSessionId(session, true, true);
                if (!updateResult) {
                    this.log.debug((Object)"Failed to update session entry: '{0}'", new Object[]{session.getId()});
                }
            }
        }
        return session;
    }

    private Map<String, String> getCurrentSessionAttributes(Map<String, String> sessionAttributes) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            HashMap<String, String> currentSessionAttributes = new HashMap<String, String>(sessionAttributes);
            ExternalContext externalContext = facesContext.getExternalContext();
            Map parameterMap = externalContext.getRequestParameterMap();
            Map<String, String> newRequestParameterMap = this.authenticationService.getAllowedParameters(parameterMap);
            for (Map.Entry<String, String> newRequestParameterMapEntry : newRequestParameterMap.entrySet()) {
                String name = newRequestParameterMapEntry.getKey();
                if (StringHelper.equalsIgnoreCase((String)name, (String)"auth_step")) continue;
                currentSessionAttributes.put(name, newRequestParameterMapEntry.getValue());
            }
            return currentSessionAttributes;
        }
        return sessionAttributes;
    }

    public String getSessionIdFromCookie(HttpServletRequest request) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(SESSION_ID_COOKIE_NAME)) continue;
                    this.log.trace((Object)"Found session_id cookie: '{0}'", new Object[]{cookie.getValue()});
                    return cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return "";
    }

    public String getSessionIdFromCookie() {
        try {
            HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            return this.getSessionIdFromCookie(request);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    public String getSessionIdFromOpbsCookie(HttpServletRequest request) {
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("opbs")) continue;
                    this.log.trace((Object)"Found session_id cookie: '{0}'", new Object[]{cookie.getValue()});
                    return cookie.getValue();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return "";
    }

    public void createSessionIdCookie(String sessionId) {
        try {
            Object response = FacesContext.getCurrentInstance().getExternalContext().getResponse();
            if (response instanceof HttpServletResponse) {
                Cookie sessionIdCookie = new Cookie(SESSION_ID_COOKIE_NAME, sessionId);
                sessionIdCookie.setPath("/");
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.addCookie(sessionIdCookie);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void removeSessionIdCookie() {
        try {
            Object response;
            FacesContext currentInstance = FacesContext.getCurrentInstance();
            if (currentInstance != null && currentInstance.getExternalContext() != null && (response = currentInstance.getExternalContext().getResponse()) instanceof HttpServletResponse) {
                this.removeSessionIdCookie((HttpServletResponse)response);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void removeSessionIdCookie(HttpServletResponse httpResponse) {
        Cookie cookie = new Cookie(SESSION_ID_COOKIE_NAME, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        httpResponse.addCookie(cookie);
    }

    public SessionId getSessionId() {
        String sessionId = this.getSessionIdFromCookie();
        if (StringHelper.isNotEmpty((String)sessionId)) {
            return this.getSessionId(sessionId);
        }
        return null;
    }

    public Map<String, String> getSessionAttributes(SessionId sessionId) {
        if (sessionId != null) {
            return sessionId.getSessionAttributes();
        }
        return null;
    }

    public SessionId generateAuthenticatedSessionId(String userDn) {
        return this.generateAuthenticatedSessionId(userDn, "");
    }

    public SessionId generateAuthenticatedSessionId(String userDn, String prompt) {
        HashMap<String, String> sessionIdAttributes = new HashMap<String, String>();
        sessionIdAttributes.put("prompt", prompt);
        return this.generateSessionId(userDn, new Date(), SessionIdState.AUTHENTICATED, sessionIdAttributes, true);
    }

    public SessionId generateAuthenticatedSessionId(String userDn, Map<String, String> sessionIdAttributes) {
        return this.generateSessionId(userDn, new Date(), SessionIdState.AUTHENTICATED, sessionIdAttributes, true);
    }

    public SessionId generateSessionId(String p_userDn, Date authenticationDate, SessionIdState state, Map<String, String> sessionIdAttributes, boolean persist) {
        String uuid = UUID.randomUUID().toString();
        String dn = SessionIdService.dn(uuid);
        if (StringUtils.isBlank((String)dn)) {
            return null;
        }
        if (SessionIdState.AUTHENTICATED == state && StringUtils.isBlank((String)p_userDn)) {
            return null;
        }
        SessionId sessionId = new SessionId();
        sessionId.setId(uuid);
        sessionId.setDn(dn);
        if (StringUtils.isNotBlank((String)p_userDn)) {
            sessionId.setUserDn(p_userDn);
        }
        if (authenticationDate != null) {
            sessionId.setAuthenticationTime(authenticationDate);
        }
        if (state != null) {
            sessionId.setState(state);
        }
        this.configureOpbsCookie(sessionId);
        sessionId.setSessionAttributes(sessionIdAttributes);
        boolean persisted = false;
        if (persist) {
            persisted = this.persistSessionId(sessionId);
        }
        this.log.trace((Object)"Generated new session, id = '{0}', state = '{1}', persisted = '{2}'", new Object[]{sessionId.getId(), sessionId.getState(), persisted});
        return sessionId;
    }

    public SessionId setSessionIdAuthenticated(SessionId sessionId, String p_userDn) {
        sessionId.setUserDn(p_userDn);
        sessionId.setAuthenticationTime(new Date());
        sessionId.setState(SessionIdState.AUTHENTICATED);
        this.configureOpbsCookie(sessionId);
        boolean persisted = this.updateSessionId(sessionId, true, true);
        this.log.trace((Object)"Authenticated session, id = '{0}', state = '{1}', persisted = '{2}'", new Object[]{sessionId.getId(), sessionId.getState(), persisted});
        return sessionId;
    }

    private void configureOpbsCookie(SessionId sessionId) {
        int unusedLifetime = ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            Cookie cookie = new Cookie("opbs", sessionId.getId());
            cookie.setMaxAge(unusedLifetime);
            ((HttpServletResponse)facesContext.getExternalContext().getResponse()).addCookie(cookie);
        }
    }

    public boolean persistSessionId(SessionId sessionId) {
        return this.persistSessionId(sessionId, false);
    }

    public boolean persistSessionId(SessionId sessionId, boolean forcePersistence) {
        List<Prompt> prompts = this.getPromptsFromSessionId(sessionId);
        try {
            int unusedLifetime = ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && SessionIdService.isPersisted(prompts) || forcePersistence) {
                sessionId.setLastUsedAt(new Date());
                sessionId.setPersisted(true);
                this.ldapEntryManager.persist((Object)sessionId);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return false;
    }

    public boolean updateSessionId(SessionId sessionId) {
        return this.updateSessionId(sessionId, true);
    }

    public boolean updateSessionId(SessionId sessionId, boolean updateLastUsedAt) {
        return this.updateSessionId(sessionId, updateLastUsedAt, false);
    }

    public boolean updateSessionId(SessionId sessionId, boolean updateLastUsedAt, boolean forceUpdate) {
        List<Prompt> prompts = this.getPromptsFromSessionId(sessionId);
        try {
            int unusedLifetime = ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime();
            if (unusedLifetime > 0 && SessionIdService.isPersisted(prompts) || forceUpdate) {
                if (updateLastUsedAt) {
                    sessionId.setLastUsedAt(new Date());
                }
                sessionId.setPersisted(true);
                this.ldapEntryManager.merge((Object)sessionId);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean isPersisted(List<Prompt> prompts) {
        if (prompts != null && prompts.contains(Prompt.NONE)) {
            Boolean persistOnPromptNone = ConfigurationFactory.instance().getConfiguration().getSessionIdPersistOnPromptNone();
            return persistOnPromptNone != null && persistOnPromptNone != false;
        }
        return true;
    }

    private static String dn(String p_id) {
        String baseDn = SessionIdService.getBaseDn();
        StringBuilder sb = new StringBuilder();
        if (Util.allNotBlank((String[])new String[]{p_id, SessionIdService.getBaseDn()})) {
            sb.append("uniqueIdentifier=").append(p_id).append(",").append(baseDn);
        }
        return sb.toString();
    }

    public SessionId getSessionByDN(String p_dn) {
        try {
            return (SessionId)this.ldapEntryManager.find(SessionId.class, (Object)p_dn);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    public SessionId getSessionId(String sessionId) {
        if (StringHelper.isEmpty((String)sessionId)) {
            return null;
        }
        String dn = SessionIdService.dn(sessionId);
        boolean contains = this.containsSessionId(dn);
        if (!contains) {
            return null;
        }
        try {
            SessionId entity = this.getSessionByDN(dn);
            this.log.trace((Object)"Try to get session by id: {0} ...", new Object[]{sessionId});
            if (entity != null) {
                this.log.trace((Object)"Session dn: {0}", new Object[]{entity.getDn()});
                if (this.isSessionValid(entity)) {
                    return entity;
                }
            }
        }
        catch (Exception ex) {
            this.log.trace((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        this.log.trace((Object)"Failed to get session by id: {0}", new Object[]{sessionId});
        return null;
    }

    public boolean containsSessionId(String dn) {
        try {
            return this.ldapEntryManager.contains(SessionId.class, dn);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
    }

    private static String getBaseDn() {
        return ConfigurationFactory.instance().getBaseDn().getSessionId();
    }

    public boolean remove(SessionId p_sessionId) {
        try {
            this.ldapEntryManager.remove((Object)p_sessionId);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
        return true;
    }

    public void remove(List<SessionId> list) {
        for (SessionId id : list) {
            this.remove(id);
        }
    }

    public void cleanUpSessions() {
        int interval = ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime();
        int unauthenticatedInterval = ConfigurationFactory.instance().getConfiguration().getSessionIdUnauthenticatedUnusedLifetime();
        this.remove(this.getUnauthenticatedIdsOlderThan(unauthenticatedInterval));
        this.remove(this.getIdsOlderThan(interval));
    }

    public List<SessionId> getUnauthenticatedIdsOlderThan(int p_intervalInSeconds) {
        try {
            long dateInPast = new Date().getTime() - TimeUnit.SECONDS.toMillis(p_intervalInSeconds);
            Filter filter = Filter.create((String)String.format("&(lastModifiedTime<=%s)(oxState=unauthenticated)", StaticUtils.encodeGeneralizedTime((Date)new Date(dateInPast))));
            return this.ldapEntryManager.findEntries(SessionIdService.getBaseDn(), SessionId.class, filter);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public List<SessionId> getIdsOlderThan(int p_intervalInSeconds) {
        try {
            long dateInPast = new Date().getTime() - TimeUnit.SECONDS.toMillis(p_intervalInSeconds);
            Filter filter = Filter.create((String)String.format("(lastModifiedTime<=%s)", StaticUtils.encodeGeneralizedTime((Date)new Date(dateInPast))));
            return this.ldapEntryManager.findEntries(SessionIdService.getBaseDn(), SessionId.class, filter);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public boolean isSessionValid(SessionId sessionId) {
        if (sessionId == null) {
            return false;
        }
        long sessionInterval = TimeUnit.SECONDS.toMillis(ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime());
        long sessionUnauthenticatedInterval = TimeUnit.SECONDS.toMillis(ConfigurationFactory.instance().getConfiguration().getSessionIdUnauthenticatedUnusedLifetime());
        long timeSinceLastAccess = System.currentTimeMillis() - sessionId.getLastUsedAt().getTime();
        if (timeSinceLastAccess > sessionInterval && ConfigurationFactory.instance().getConfiguration().getSessionIdUnusedLifetime() != -1) {
            return false;
        }
        return sessionId.getState() != SessionIdState.UNAUTHENTICATED || timeSinceLastAccess <= sessionUnauthenticatedInterval || ConfigurationFactory.instance().getConfiguration().getSessionIdUnauthenticatedUnusedLifetime() == -1;
    }

    private List<Prompt> getPromptsFromSessionId(SessionId sessionId) {
        String promptParam = sessionId.getSessionAttributes().get("prompt");
        return Prompt.fromString((String)promptParam, (String)" ");
    }
}

