/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.net.ConnectException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.ClientService;

@Name(value="redirectionUriService")
@Scope(value=ScopeType.STATELESS)
@AutoCreate
public class RedirectionUriService {
    @Logger
    private Log log;
    @In
    private ClientService clientService;

    public String validateRedirectionUri(String clientIdentifier, String redirectionUri) {
        try {
            Client client = this.clientService.getClient(clientIdentifier);
            if (client != null) {
                String sectorIdentifierUri = client.getSectorIdentifierUri();
                String[] redirectUris = client.getRedirectUris();
                if (StringUtils.isNotBlank((String)sectorIdentifierUri)) {
                    ClientRequest clientRequest = new ClientRequest(sectorIdentifierUri);
                    clientRequest.setHttpMethod("GET");
                    ClientResponse clientResponse = clientRequest.get(String.class);
                    int status = clientResponse.getStatus();
                    if (status == 200) {
                        String entity = (String)clientResponse.getEntity(String.class);
                        JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                        redirectUris = new String[sectorIdentifierJsonArray.length()];
                        for (int i = 0; i < sectorIdentifierJsonArray.length(); ++i) {
                            redirectUris[i] = sectorIdentifierJsonArray.getString(i);
                        }
                    } else {
                        return null;
                    }
                }
                if (StringUtils.isNotBlank((String)redirectionUri)) {
                    this.log.debug((Object)"Validating redirection URI: clientIdentifier = {0}, redirectionUri = {1}, found = {2}", new Object[]{clientIdentifier, redirectionUri, redirectUris.length});
                    String redirectUriWithoutParams = this.uriWithoutParams(redirectionUri);
                    for (String uri : redirectUris) {
                        this.log.debug((Object)"Comparing {0} == {1}", new Object[]{uri, redirectionUri});
                        if (uri.equals(redirectionUri)) {
                            return redirectionUri;
                        }
                        String uriWithoutParams = this.uriWithoutParams(uri);
                        Map<String, String> params = this.getParams(uri);
                        if ((!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() != 0 || this.getParams(redirectionUri).size() != 0) && (!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() <= 0 || !this.compareParams(redirectionUri, uri))) continue;
                        return redirectionUri;
                    }
                } else if (redirectUris != null && redirectUris.length == 1) {
                    return redirectUris[0];
                }
            }
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (UnknownHostException e) {
            return null;
        }
        catch (ConnectException e) {
            return null;
        }
        catch (JSONException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String validatePostLogoutRedirectUri(String clientId, String postLogoutRedirectUri) {
        Client client = this.clientService.getClient(clientId);
        if (client != null) {
            String[] postLogoutRedirectUris = client.getPostLogoutRedirectUris();
            if (postLogoutRedirectUris != null & StringUtils.isNotBlank((String)postLogoutRedirectUri)) {
                this.log.debug((Object)"Validating post logout redirect URI: clientId = {0}, postLogoutRedirectUri = {1}", new Object[]{clientId, postLogoutRedirectUri});
                for (String uri : postLogoutRedirectUris) {
                    this.log.debug((Object)"Comparing {0} == {1}", new Object[]{uri, postLogoutRedirectUri});
                    if (!uri.equals(postLogoutRedirectUri)) continue;
                    return postLogoutRedirectUri;
                }
            } else if (postLogoutRedirectUris != null && postLogoutRedirectUris.length == 1) {
                return postLogoutRedirectUris[0];
            }
        }
        return null;
    }

    private Map<String, String> getParams(String uri) {
        int paramsIndex;
        Map<String, String> params = new HashMap<String, String>();
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            String queryString = uri.substring(paramsIndex + 1);
            params = QueryStringDecoder.decode((String)queryString);
        }
        return params;
    }

    private String uriWithoutParams(String uri) {
        int paramsIndex;
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            return uri.substring(0, paramsIndex);
        }
        return uri;
    }

    private boolean compareParams(String uri1, String uri2) {
        if (StringUtils.isBlank((String)uri1) || StringUtils.isBlank((String)uri2)) {
            return false;
        }
        Map<String, String> params1 = this.getParams(uri1);
        Map<String, String> params2 = this.getParams(uri2);
        return params1.equals(params2);
    }
}

