/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.Conf;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.util.KeyGenerator;

@Name(value="keyGeneratorTimer")
@AutoCreate
@Scope(value=ScopeType.APPLICATION)
public class KeyGeneratorTimer {
    private static final String EVENT_TYPE = "KeyGeneratorTimerEvent";
    private static final int DEFAULT_INTERVAL = 48;
    @Logger
    private Log log;
    @In
    private ConfigurationFactory configurationFactory;
    @In
    private LdapEntryManager ldapEntryManager;
    private AtomicBoolean isActive;

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void init() {
        this.log.debug((Object)"Initializing KeyGeneratorTimer", new Object[0]);
        this.isActive = new AtomicBoolean(false);
        long interval = ConfigurationFactory.instance().getConfiguration().getKeyRegenerationInterval();
        if (interval <= 0L) {
            interval = 48L;
        }
        interval = interval * 3600L * 1000L;
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(interval), Long.valueOf(interval)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"KeyGeneratorTimerEvent"})
    @Asynchronous
    public void process() {
        if (!ConfigurationFactory.instance().getConfiguration().getKeyRegenerationEnabled().booleanValue()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            String dn = ConfigurationFactory.instance().getLdapConfiguration().getString("configurationEntryDN");
            Conf conf = (Conf)this.ldapEntryManager.find(Conf.class, (Object)dn);
            JSONObject jwks = new JSONObject(conf.getWebKeys());
            conf.setWebKeys(this.updateKeys(jwks).toString());
            this.ldapEntryManager.merge((Object)conf);
            ConfigurationFactory.instance().updateFromLdap();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private JSONObject updateKeys(JSONObject jwks) throws Exception {
        JSONObject jsonObject = this.generateJwks();
        JSONArray keys = jwks.getJSONArray("keys");
        for (int i = 0; i < keys.length(); ++i) {
            JSONObject key = keys.getJSONObject(i);
            if (key.has("expirationTime") && !key.isNull("expirationTime")) {
                GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                GregorianCalendar expirationDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                expirationDate.setTimeInMillis(key.getLong("expirationTime"));
                if (expirationDate.before(now)) {
                    this.log.debug((Object)"Removing JWK: {0}, Expiration date: {1}", new Object[]{key.get("keyId"), key.get("expirationTime")});
                    continue;
                }
                jsonObject.getJSONArray("keys").put((Object)key);
                continue;
            }
            GregorianCalendar expirationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            expirationTime.add(10, ConfigurationFactory.instance().getConfiguration().getKeyRegenerationInterval());
            expirationTime.add(13, ConfigurationFactory.instance().getConfiguration().getIdTokenLifetime());
            key.put("expirationTime", expirationTime.getTimeInMillis());
            jsonObject.getJSONArray("keys").put((Object)key);
        }
        return jsonObject;
    }

    private JSONObject generateJwks() throws Exception {
        JSONArray keys = new JSONArray();
        GregorianCalendar expirationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        expirationTime.add(10, ConfigurationFactory.instance().getConfiguration().getKeyRegenerationInterval());
        expirationTime.add(13, ConfigurationFactory.instance().getConfiguration().getIdTokenLifetime());
        keys.put((Object)KeyGenerator.generateRS256Keys(expirationTime.getTimeInMillis()));
        keys.put((Object)KeyGenerator.generateRS384Keys(expirationTime.getTimeInMillis()));
        keys.put((Object)KeyGenerator.generateRS512Keys(expirationTime.getTimeInMillis()));
        keys.put((Object)KeyGenerator.generateES256Keys(expirationTime.getTimeInMillis()));
        keys.put((Object)KeyGenerator.generateES384Keys(expirationTime.getTimeInMillis()));
        keys.put((Object)KeyGenerator.generateES512Keys(expirationTime.getTimeInMillis()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("keys", (Object)keys);
        return jsonObject;
    }
}

