/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.federation.FederationMetadata;
import org.xdi.oxauth.model.federation.FederationOP;
import org.xdi.oxauth.model.federation.FederationRP;
import org.xdi.oxauth.util.LdapUtils;

@Scope(value=ScopeType.STATELESS)
@Name(value="federationMetadataService")
@AutoCreate
public class FederationMetadataService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public List<FederationMetadata> getMetadataList() {
        try {
            FederationMetadata m = new FederationMetadata();
            m.setDn(ConfigurationFactory.instance().getBaseDn().getFederationMetadata());
            List entries = this.ldapEntryManager.findEntries((Object)m);
            if (entries != null) {
                return entries;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return Collections.emptyList();
    }

    public FederationMetadata getMetadata(String p_federationId, boolean p_loadSatellites) throws InvalidIdException {
        if (StringUtils.isBlank((String)p_federationId)) {
            throw new InvalidIdException();
        }
        try {
            FederationMetadata m = new FederationMetadata();
            m.setDn(ConfigurationFactory.instance().getBaseDn().getFederationMetadata());
            m.setId(p_federationId);
            List entries = this.ldapEntryManager.findEntries((Object)m);
            if (entries != null && !entries.isEmpty()) {
                int size = entries.size();
                if (size == 1) {
                    FederationMetadata result = (FederationMetadata)entries.get(0);
                    if (p_loadSatellites) {
                        List ops;
                        List rps = result.getRps();
                        if (rps != null && !rps.isEmpty()) {
                            Filter rpFilter = LdapUtils.createAnyFilterFromDnList("inum", rps);
                            if (rpFilter != null) {
                                List rpList = this.ldapEntryManager.findEntries(ConfigurationFactory.instance().getBaseDn().getFederationRP(), FederationRP.class, rpFilter);
                                result.setRpList(rpList);
                            } else {
                                this.log.trace((Object)"Skip loading of RPs for metadataId: {0}", new Object[]{p_federationId});
                            }
                        }
                        if ((ops = result.getOps()) != null && !ops.isEmpty()) {
                            Filter opFilter = LdapUtils.createAnyFilterFromDnList("inum", ops);
                            if (opFilter != null) {
                                List opList = this.ldapEntryManager.findEntries(ConfigurationFactory.instance().getBaseDn().getFederationOP(), FederationOP.class, opFilter);
                                result.setOpList(opList);
                            } else {
                                this.log.trace((Object)"Skip loading of OPs for metadataId: {0}", new Object[]{p_federationId});
                            }
                        }
                    }
                    return result;
                }
            } else {
                this.log.trace((Object)"Invalid federation metadata id: {0}", new Object[]{p_federationId});
                throw new InvalidIdException();
            }
            this.log.error((Object)"There is more then one federation metadata object with id {0}", new Object[]{p_federationId});
        }
        catch (InvalidIdException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    public static class InvalidIdException
    extends Exception {
    }
}

