/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.AttributeData;
import org.gluu.site.ldap.persistence.AttributeDataModification;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.client.FederationMetadataClient;
import org.xdi.oxauth.client.FederationMetadataResponse;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.federation.FederationMetadata;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.util.Pair;

@Name(value="federationCheckTimer")
@AutoCreate
@Scope(value=ScopeType.APPLICATION)
public class FederationCheckTimer {
    private static final String EVENT_TYPE = "FederationCheckTimerEvent";
    private static final long DEFAULT_INTERVAL = TimeUnit.HOURS.toMillis(24L);
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void init() {
        if (ConfigurationFactory.instance().getConfiguration().getFederationEnabled().booleanValue()) {
            this.log.trace((Object)"Initializing FederationCheckTimer...", new Object[0]);
            long interval = ConfigurationFactory.instance().getConfiguration().getFederationCheckInterval();
            if (interval <= 0L) {
                interval = DEFAULT_INTERVAL;
            }
            Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(interval *= 1000L), Long.valueOf(interval)), new Object[0]);
            this.log.trace((Object)"FederationCheckTimer initialized", new Object[0]);
        }
    }

    @Observer(value={"FederationCheckTimerEvent"})
    @Asynchronous
    public void process() {
        this.log.trace((Object)"Federation Trust clean up started...", new Object[0]);
        this.cleanUpTrusts();
        this.log.trace((Object)"Federation Trust clean up finished.", new Object[0]);
    }

    public void cleanUpTrusts() {
        try {
            String baseDn = ConfigurationFactory.instance().getBaseDn().getFederationTrust();
            List result = this.ldapEntryManager.findEntries(baseDn, FederationTrust.class, Filter.create((String)"inum=*"));
            Map<Pair<String, String>, List<FederationTrust>> map = FederationCheckTimer.groupByMetadata(result);
            if (!map.isEmpty()) {
                for (Map.Entry<Pair<String, String>, List<FederationTrust>> entry : map.entrySet()) {
                    this.cleanUpByMetadata(entry);
                }
            }
        }
        catch (LDAPException e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private static Map<Pair<String, String>, List<FederationTrust>> groupByMetadata(List<FederationTrust> p_list) {
        HashMap<Pair<String, String>, List<FederationTrust>> result = new HashMap<Pair<String, String>, List<FederationTrust>>();
        if (p_list != null && !p_list.isEmpty()) {
            for (FederationTrust t : p_list) {
                Pair pair = new Pair((Object)t.getFederationMetadataUri(), (Object)t.getFederationId());
                List value = (List)result.get(pair);
                if (value == null) {
                    result.put((Pair<String, String>)pair, new ArrayList<FederationTrust>(Arrays.asList(t)));
                    continue;
                }
                value.add(t);
            }
        }
        return result;
    }

    private void cleanUpByMetadata(Map.Entry<Pair<String, String>, List<FederationTrust>> p_entry) {
        try {
            Pair<String, String> pair = p_entry.getKey();
            if (StringUtils.isNotBlank((String)((String)pair.getFirst())) && StringUtils.isNotBlank((String)((String)pair.getSecond())) && p_entry.getValue() != null && !p_entry.getValue().isEmpty()) {
                FederationMetadataClient client = new FederationMetadataClient((String)pair.getFirst());
                FederationMetadataResponse response = client.execGetMetadataById((String)pair.getSecond());
                if (response != null && response.getMetadata() != null) {
                    FederationMetadata metadata = response.getMetadata();
                    this.log.trace((Object)"Check trusts against metadata: {0}", new Object[]{metadata.toString()});
                    for (FederationTrust t : p_entry.getValue()) {
                        List collectedMetadataUriList;
                        ArrayList redirectUris;
                        if (t.getRedirectUris() == null || t.getRedirectUris().isEmpty() || !(redirectUris = new ArrayList(t.getRedirectUris())).retainAll(collectedMetadataUriList = metadata.collectAllRedirectUris())) continue;
                        ArrayList outdatedList = new ArrayList(t.getRedirectUris());
                        outdatedList.removeAll(collectedMetadataUriList);
                        this.log.trace((Object)"Removed outdated redirectUris {0}, trust dn: {1}", new Object[]{outdatedList, t.getDn()});
                        t.setRedirectUris(redirectUris);
                        this.ldapEntryManager.merge((Object)t);
                    }
                } else {
                    this.setStatusToInactiveByChecker(p_entry);
                }
            }
        }
        catch (Exception e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            this.setStatusToInactiveByChecker(p_entry);
        }
    }

    private void setStatusToInactiveByChecker(Map.Entry<Pair<String, String>, List<FederationTrust>> p_entry) {
        Pair<String, String> pair = p_entry.getKey();
        List<FederationTrust> list = p_entry.getValue();
        this.log.trace((Object)"Unable to retrieve information for metadata endpoint, url: {0}, id: {1}", new Object[]{pair.getFirst(), pair.getSecond()});
        for (FederationTrust t : list) {
            this.log.trace((Object)"Unable to check info of trust, set status to inactive_by_checker, dn: {0}", new Object[]{t.getDn()});
            AttributeDataModification statusAttribute = new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, new AttributeData("oxAuthFederationTrustStatus", FederationTrustStatus.INACTIVE_BY_CHECKER.getValue()));
            this.ldapEntryManager.merge(t.getDn(), Arrays.asList(statusAttribute));
        }
    }
}

