/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.codahale.metrics.Timer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.ldap.model.CustomEntry;
import org.xdi.ldap.model.GluuStatus;
import org.xdi.model.SimpleProperty;
import org.xdi.model.ldap.GluuLdapConfiguration;
import org.xdi.model.metric.MetricType;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.SimpleUser;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.session.OAuthCredentials;
import org.xdi.oxauth.model.session.SessionClient;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.MetricService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.external.ExternalAuthenticationService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="authenticationService")
@AutoCreate
public class AuthenticationService {
    public static final List<String> ALLOWED_PARAMETER = Collections.unmodifiableList(Arrays.asList("scope", "response_type", "client_id", "redirect_uri", "state", "nonce", "display", "prompt", "max_age", "ui_locales", "id_token_hint", "login_hint", "acr_values", "session_id", "request", "request_uri", "origin_headers"));
    @Logger
    private Log log;
    @In
    private Identity identity;
    @In
    private OAuthCredentials credentials;
    @In(required=false, value="ldapAuthConfig")
    private List<GluuLdapConfiguration> ldapAuthConfigs;
    @In
    private LdapEntryManager ldapEntryManager;
    @In(required=true, value="ldapAuthEntryManager")
    private List<LdapEntryManager> ldapAuthEntryManagers;
    @In
    private UserService userService;
    @In
    private ClientService clientService;
    @In
    private SessionIdService sessionIdService;
    @In
    private ExternalAuthenticationService externalAuthenticationService;
    @In
    private SessionId sessionUser;
    @In
    private MetricService metricService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String userName, String password) {
        this.log.debug((Object)"Authenticating user with LDAP: username: {0}", new Object[]{userName});
        boolean authenticated = false;
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            authenticated = this.ldapAuthConfigs == null ? this.localAuthenticate(userName, password) : this.externalAuthenticate(userName, password);
        }
        finally {
            timerContext.stop();
        }
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        return authenticated;
    }

    private boolean localAuthenticate(String userName, String password) {
        User user = this.userService.getUser(userName, new String[0]);
        if (user != null) {
            if (!this.checkUserStatus(user)) {
                return false;
            }
            boolean authenticated = this.ldapEntryManager.authenticate(user.getDn(), password);
            if (authenticated) {
                this.credentials.setUser(user);
                this.updateLastLogonUserTime(user);
            }
            return authenticated;
        }
        return false;
    }

    private boolean externalAuthenticate(String keyValue, String password) {
        for (int i = 0; i < this.ldapAuthConfigs.size(); ++i) {
            boolean authenticated;
            GluuLdapConfiguration ldapAuthConfig = this.ldapAuthConfigs.get(i);
            LdapEntryManager ldapAuthEntryManager = this.ldapAuthEntryManagers.get(i);
            String primaryKey = "uid";
            if (StringHelper.isNotEmpty((String)ldapAuthConfig.getPrimaryKey())) {
                primaryKey = ldapAuthConfig.getPrimaryKey();
            }
            String localPrimaryKey = "uid";
            if (StringHelper.isNotEmpty((String)ldapAuthConfig.getLocalPrimaryKey())) {
                localPrimaryKey = ldapAuthConfig.getLocalPrimaryKey();
            }
            if (!(authenticated = this.authenticate(ldapAuthConfig, ldapAuthEntryManager, keyValue, password, primaryKey, localPrimaryKey))) continue;
            return authenticated;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String keyValue, String password, String primaryKey, String localPrimaryKey) {
        if (this.ldapAuthConfigs == null) {
            return this.authenticate(null, this.ldapEntryManager, keyValue, password, primaryKey, localPrimaryKey);
        }
        boolean authenticated = false;
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            for (int i = 0; i < this.ldapAuthConfigs.size(); ++i) {
                LdapEntryManager ldapAuthEntryManager;
                GluuLdapConfiguration ldapAuthConfig = this.ldapAuthConfigs.get(i);
                authenticated = this.authenticate(ldapAuthConfig, ldapAuthEntryManager = this.ldapAuthEntryManagers.get(i), keyValue, password, primaryKey, localPrimaryKey);
                if (!authenticated) continue;
                break;
            }
        }
        finally {
            timerContext.stop();
        }
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        return authenticated;
    }

    private boolean authenticate(GluuLdapConfiguration ldapAuthConfig, LdapEntryManager ldapAuthEntryManager, String keyValue, String password, String primaryKey, String localPrimaryKey) {
        this.log.debug((Object)"Attempting to find userDN by primary key: '{0}' and key value: '{1}'", new Object[]{primaryKey, keyValue});
        List<String> baseDNs = ldapAuthConfig == null ? Arrays.asList(this.userService.getDnForUser(null)) : ldapAuthConfig.getBaseDNs();
        if (baseDNs != null && !baseDNs.isEmpty()) {
            for (Object e : baseDNs) {
                String baseDn = e instanceof SimpleProperty ? ((SimpleProperty)e).getValue() : e.toString();
                User user = this.getUserByAttribute(ldapAuthEntryManager, baseDn, primaryKey, keyValue);
                if (user == null) continue;
                String userDn = user.getDn();
                this.log.debug((Object)"Attempting to authenticate userDN: {0}", new Object[]{userDn});
                if (!ldapAuthEntryManager.authenticate(userDn, password)) continue;
                this.log.debug((Object)"User authenticated: {0}", new Object[]{userDn});
                this.log.debug((Object)"Attempting to find userDN by local primary key: {0}", new Object[]{localPrimaryKey});
                User localUser = this.userService.getUserByAttribute(localPrimaryKey, keyValue);
                if (localUser == null) continue;
                if (!this.checkUserStatus(localUser)) {
                    return false;
                }
                this.credentials.setUser(localUser);
                this.updateLastLogonUserTime(localUser);
                return true;
            }
        } else {
            this.log.error((Object)"There are no baseDns specified in authentication configuration.", new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String userName) {
        this.log.debug((Object)"Authenticating user with LDAP: username: {0}", new Object[]{userName});
        boolean authenticated = false;
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            User user = this.userService.getUser(userName, new String[0]);
            if (user != null && this.checkUserStatus(user)) {
                this.credentials.setUsername(user.getUserId());
                this.credentials.setUser(user);
                this.updateLastLogonUserTime(user);
                authenticated = true;
            }
        }
        finally {
            timerContext.stop();
        }
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        return authenticated;
    }

    private User getUserByAttribute(LdapEntryManager ldapAuthEntryManager, String baseDn, String attributeName, String attributeValue) {
        this.log.debug((Object)"Getting user information from LDAP: attributeName = '{0}', attributeValue = '{1}'", new Object[]{attributeName, attributeValue});
        SimpleUser sampleUser = new SimpleUser();
        sampleUser.setDn(baseDn);
        ArrayList<org.xdi.oxauth.model.common.CustomAttribute> customAttributes = new ArrayList<org.xdi.oxauth.model.common.CustomAttribute>();
        customAttributes.add(new org.xdi.oxauth.model.common.CustomAttribute(attributeName, attributeValue));
        sampleUser.setCustomAttributes(customAttributes);
        List entries = ldapAuthEntryManager.findEntries((Object)sampleUser, 1);
        this.log.debug((Object)"Found '{0}' entries", new Object[]{entries.size()});
        if (entries.size() > 0) {
            SimpleUser foundUser = (SimpleUser)entries.get(0);
            return (User)ldapAuthEntryManager.find(User.class, (Object)foundUser.getDn());
        }
        return null;
    }

    private boolean checkUserStatus(User user) {
        org.xdi.oxauth.model.common.CustomAttribute userStatus = this.userService.getCustomAttribute(user, "gluuStatus");
        if (userStatus == null || GluuStatus.INACTIVE.equals((Object)GluuStatus.getByValue((String)userStatus.getValue()))) {
            this.log.warn((Object)"User '{0}' was disabled", new Object[]{user.getUserId()});
            return false;
        }
        return true;
    }

    private void updateLastLogonUserTime(User user) {
        CustomEntry customEntry = new CustomEntry();
        customEntry.setDn(user.getDn());
        CustomAttribute customAttribute = new CustomAttribute("oxLastLogonTime", new Date());
        customEntry.getCustomAttributes().add(customAttribute);
        try {
            this.ldapEntryManager.merge((Object)customEntry);
        }
        catch (EntryPersistenceException epe) {
            this.log.error((Object)"Failed to update oxLastLoginTime of user '{0}'", new Object[]{user.getUserId()});
        }
    }

    public void configureSessionUser(SessionId sessionId, Map<String, String> sessionIdAttributes) {
        User user = this.credentials.getUser();
        SessionId newSessionId = sessionId == null ? this.sessionIdService.generateAuthenticatedSessionId(user.getDn(), sessionIdAttributes) : this.sessionIdService.setSessionIdAuthenticated(sessionId, user.getDn());
        this.configureEventUserContext(newSessionId);
    }

    public SessionId configureEventUser() {
        User user = this.credentials.getUser();
        if (user == null) {
            return null;
        }
        SessionId sessionId = this.sessionIdService.generateAuthenticatedSessionId(user.getDn());
        this.configureEventUserContext(sessionId);
        return sessionId;
    }

    public void configureEventUser(SessionId sessionId) {
        this.sessionIdService.updateSessionId(sessionId);
        this.configureEventUserContext(sessionId);
    }

    private void configureEventUserContext(SessionId sessionId) {
        this.identity.addRole("user");
        Contexts.getEventContext().set("sessionUser", (Object)sessionId);
    }

    public void configureSessionClient(Context context) {
        this.identity.addRole("client");
        Client client = this.clientService.getClient(this.credentials.getUsername());
        SessionClient sessionClient = new SessionClient();
        sessionClient.setClient(client);
        context.set("sessionClient", (Object)sessionClient);
        this.clientService.updatAccessTime(client, true);
    }

    @Observer(value={"org.xdi.oxauth.security.loginSuccessful", "org.jboss.seam.security.loginSuccessful"})
    public void onSuccessfulLogin() {
        this.log.info((Object)"Attempting to redirect user. SessionUser: {0}", new Object[]{this.sessionUser});
        if (this.sessionUser == null || StringUtils.isBlank((String)this.sessionUser.getUserDn())) {
            return;
        }
        User user = this.userService.getUserByDn(this.sessionUser.getUserDn());
        this.log.info((Object)"Attempting to redirect user. User: {0}", new Object[]{user});
        if (user != null) {
            Map<String, String> result = this.sessionUser.getSessionAttributes();
            Map<String, String> allowedParameters = this.getAllowedParameters(result);
            result.put("session_id", this.sessionUser.getId());
            this.log.trace((Object)"Logged in successfully! User: {0}, page: /authorize.xhtml, map: {1}", new Object[]{user, allowedParameters});
            FacesManager.instance().redirect("/authorize.xhtml", allowedParameters, false);
        }
    }

    public Map<String, String> getAllowedParameters(@Nonnull Map<String, String> requestParameterMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!requestParameterMap.isEmpty()) {
            Set<Map.Entry<String, String>> set = requestParameterMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (!ALLOWED_PARAMETER.contains(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public User getUserOrRemoveSession(SessionId p_sessionId) {
        if (p_sessionId != null) {
            try {
                if (StringUtils.isNotBlank((String)p_sessionId.getUserDn())) {
                    User user = this.userService.getUserByDn(p_sessionId.getUserDn());
                    if (user != null) {
                        return user;
                    }
                    this.sessionIdService.remove(p_sessionId);
                } else {
                    this.sessionIdService.remove(p_sessionId);
                }
            }
            catch (Exception e) {
                this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return null;
    }

    public String parametersAsString() throws UnsupportedEncodingException {
        Map<String, String> parameterMap = this.getParametersMap(null);
        return this.parametersAsString(parameterMap);
    }

    public String parametersAsString(Map<String, String> parameterMap) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> set = parameterMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String value = entry.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            sb.append(entry.getKey()).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
        }
        String result = sb.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public Map<String, String> getParametersMap(List<String> extraParameters) {
        HashMap<String, String> parameterMap = new HashMap<String, String>(FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap());
        return this.getParametersMap(extraParameters, parameterMap);
    }

    public Map<String, String> getParametersMap(List<String> extraParameters, Map<String, String> parameterMap) {
        ArrayList<String> allowedParameters = new ArrayList<String>(ALLOWED_PARAMETER);
        if (extraParameters != null) {
            for (String extraParameter : extraParameters) {
                this.putInMap(parameterMap, extraParameter);
            }
            allowedParameters.addAll(extraParameters);
        }
        Iterator<Map.Entry<String, String>> it = parameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (allowedParameters.contains(entry.getKey())) continue;
            it.remove();
        }
        return parameterMap;
    }

    private void putInMap(Map<String, String> map, String p_name) {
        if (map == null) {
            return;
        }
        String value = this.getParameterValue(p_name);
        map.put(p_name, value);
    }

    public String getParameterValue(String p_name) {
        Object o = Contexts.getEventContext().get(p_name);
        if (o instanceof String) {
            String s = (String)o;
            return s;
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return b.toString();
        }
        return null;
    }

    public static AuthenticationService instance() {
        return (AuthenticationService)ServerUtil.instance(AuthenticationService.class);
    }
}

