/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.Log;
import org.xdi.model.GluuAttribute;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.service.CacheService;

@Scope(value=ScopeType.STATELESS)
@Name(value="attributeService")
@AutoCreate
public class AttributeService
extends org.xdi.service.AttributeService {
    private static final String CACHE_ATTRIBUTE = "AttributeCache";
    @Logger
    private Log log;
    @In
    private CacheService cacheService;

    public static AttributeService instance() {
        boolean createContexts;
        boolean bl = createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        if (createContexts) {
            Lifecycle.beginCall();
        }
        return (AttributeService)((Object)Component.getInstance(AttributeService.class));
    }

    public GluuAttribute getAttributeByDn(String dn) {
        GluuAttribute gluuAttribute = (GluuAttribute)this.cacheService.get(CACHE_ATTRIBUTE, dn);
        if (gluuAttribute == null) {
            gluuAttribute = (GluuAttribute)this.ldapEntryManager.find(GluuAttribute.class, (Object)dn);
            this.cacheService.put(CACHE_ATTRIBUTE, dn, (Object)gluuAttribute);
        } else {
            this.log.trace((Object)"Get attribute from cache by Dn '{0}'", new Object[]{dn});
        }
        return gluuAttribute;
    }

    public GluuAttribute getByLdapName(String name) {
        List gluuAttributes = this.getAttributesByAttribute("gluuAttributeName", name, ConfigurationFactory.instance().getBaseDn().getAttributes());
        if (gluuAttributes.size() > 0) {
            for (GluuAttribute gluuAttribute : gluuAttributes) {
                if (gluuAttribute.getName() == null || !gluuAttribute.getName().equals(name)) continue;
                return gluuAttribute;
            }
        }
        return null;
    }

    public GluuAttribute getByClaimName(String name) {
        List gluuAttributes = this.getAttributesByAttribute("oxAuthClaimName", name, ConfigurationFactory.instance().getBaseDn().getAttributes());
        if (gluuAttributes.size() > 0) {
            for (GluuAttribute gluuAttribute : gluuAttributes) {
                if (gluuAttribute.getOxAuthClaimName() == null || !gluuAttribute.getOxAuthClaimName().equals(name)) continue;
                return gluuAttribute;
            }
        }
        return null;
    }

    public List<GluuAttribute> getAllAttributes() {
        return this.getAllAttributes(ConfigurationFactory.instance().getBaseDn().getAttributes());
    }
}

