/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.token;

import org.xdi.oxauth.model.common.GrantType;

public class TokenParamsValidator {
    public static boolean validateParams(String grantType, String code, String redirectUri, String username, String password, String scope, String assertion, String refreshToken, String oxAuthExchangeToken) {
        boolean result = false;
        if (grantType == null || grantType.isEmpty()) {
            return false;
        }
        GrantType gt = GrantType.fromString((String)grantType);
        switch (gt) {
            case AUTHORIZATION_CODE: {
                result = code != null && !code.isEmpty() && redirectUri != null && !redirectUri.isEmpty();
                break;
            }
            case RESOURCE_OWNER_PASSWORD_CREDENTIALS: {
                result = true;
                break;
            }
            case CLIENT_CREDENTIALS: {
                result = true;
                break;
            }
            case EXTENSION: {
                result = assertion != null && !assertion.isEmpty();
                break;
            }
            case REFRESH_TOKEN: {
                result = refreshToken != null && !refreshToken.isEmpty();
                break;
            }
            case OXAUTH_EXCHANGE_TOKEN: {
                result = oxAuthExchangeToken != null && !oxAuthExchangeToken.isEmpty();
            }
        }
        return result;
    }

    public static boolean validateParams(String clientId, String clientSecret) {
        return clientId != null && !clientId.isEmpty() && clientSecret != null && !clientSecret.isEmpty();
    }
}

