/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.token;

import java.io.UnsupportedEncodingException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.xdi.model.GluuAttribute;
import org.xdi.oxauth.model.authorize.Claim;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.ScopeType;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidClaimException;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jwe.JweEncrypterImpl;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jws.ECDSASigner;
import org.xdi.oxauth.model.jws.HMACSigner;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtSubClaimObject;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.token.JsonWebResponse;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.external.ExternalDynamicScopeService;
import org.xdi.util.security.StringEncrypter;

@org.jboss.seam.annotations.Scope(value=org.jboss.seam.ScopeType.STATELESS)
@Name(value="idTokenFactory")
@AutoCreate
public class IdTokenFactory {
    @In
    private ExternalDynamicScopeService externalDynamicScopeService;
    @In
    private ScopeService scopeService;
    @In
    private AttributeService attributeService;
    @In
    private ConfigurationFactory configurationFactory;

    public Jwt generateSignedIdToken(IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Set<String> scopes) throws SignatureException, InvalidJwtException, StringEncrypter.EncryptionException, InvalidClaimException {
        Jwt jwt = new Jwt();
        JSONWebKeySet jwks = ConfigurationFactory.instance().getWebKeys();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromName((String)ConfigurationFactory.instance().getConfiguration().getDefaultSignatureAlgorithm());
        if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getIdTokenSignedResponseAlg() != null) {
            signatureAlgorithm = SignatureAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenSignedResponseAlg());
        }
        if (signatureAlgorithm == SignatureAlgorithm.NONE) {
            jwt.getHeader().setType(JwtType.JWT);
        } else {
            jwt.getHeader().setType(JwtType.JWS);
        }
        jwt.getHeader().setAlgorithm(signatureAlgorithm);
        List jsonWebKeys = jwks.getKeys(signatureAlgorithm);
        if (jsonWebKeys.size() > 0) {
            jwt.getHeader().setKeyId(((JSONWebKey)jsonWebKeys.get(0)).getKeyId());
        }
        jwt.getClaims().setIssuer(ConfigurationFactory.instance().getConfiguration().getIssuer());
        jwt.getClaims().setAudience(authorizationGrant.getClient().getClientId());
        int lifeTime = ConfigurationFactory.instance().getConfiguration().getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwt.getClaims().setExpirationTime(expiration);
        jwt.getClaims().setIssuedAt(issuedAt);
        if (authorizationGrant.getAcrValues() != null) {
            jwt.getClaims().setClaim("acr", authorizationGrant.getAcrValues());
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwt.getClaims().setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwt.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = authorizationCode.getHash(signatureAlgorithm);
            jwt.getClaims().setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = accessToken.getHash(signatureAlgorithm);
            jwt.getClaims().setClaim("at_hash", accessTokenHash);
        }
        jwt.getClaims().setClaim("oxValidationURI", ConfigurationFactory.instance().getConfiguration().getCheckSessionIFrame());
        jwt.getClaims().setClaim("oxOpenIDConnectVersion", ConfigurationFactory.instance().getConfiguration().getOxOpenIdConnectVersion());
        ArrayList<String> dynamicScopes = new ArrayList<String>();
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
            if (scope != null && ScopeType.DYNAMIC == scope.getScopeType()) {
                dynamicScopes.add(scope.getDisplayName());
                continue;
            }
            if (scope == null || scope.getOxAuthClaims() == null) continue;
            if (scope.getIsOxAuthGroupClaims()) {
                JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                groupClaim.setName(scope.getDisplayName());
                for (String claimDn : scope.getOxAuthClaims()) {
                    GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                    String claimName = gluuAttribute.getOxAuthClaimName();
                    String ldapName = gluuAttribute.getName();
                    String attributeValue = null;
                    if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
                    attributeValue = ldapName.equals("uid") ? authorizationGrant.getUser().getUserId() : authorizationGrant.getUser().getAttribute(gluuAttribute.getName());
                    groupClaim.setClaim(claimName, attributeValue);
                }
                jwt.getClaims().setClaim(scope.getDisplayName(), groupClaim);
                continue;
            }
            for (String claimDn : scope.getOxAuthClaims()) {
                GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                String claimName = gluuAttribute.getOxAuthClaimName();
                String ldapName = gluuAttribute.getName();
                String attributeValue = null;
                if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
                attributeValue = ldapName.equals("uid") ? authorizationGrant.getUser().getUserId() : authorizationGrant.getUser().getAttribute(gluuAttribute.getName());
                jwt.getClaims().setClaim(claimName, attributeValue);
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember().getClaims()) {
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null) continue;
                String ldapClaimName = gluuAttribute.getName();
                Object attribute = authorizationGrant.getUser().getAttribute(ldapClaimName, optional);
                if (attribute == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value = jsonArray.optString(i);
                        if (value == null) continue;
                        values.add(value);
                    }
                    jwt.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                String value = (String)attribute;
                jwt.getClaims().setClaim(claim.getName(), value);
            }
        }
        String openidSubAttribute = this.configurationFactory.getConfiguration().getOpenidSubAttribute();
        jwt.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute(openidSubAttribute));
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopes, (JsonWebResponse)jwt, authorizationGrant.getUser());
        }
        JSONWebKey jwk = null;
        switch (signatureAlgorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                HMACSigner hmacSigner = new HMACSigner(signatureAlgorithm, authorizationGrant.getClient().getClientSecret());
                jwt = hmacSigner.sign(jwt);
                break;
            }
            case RS256: 
            case RS384: 
            case RS512: {
                jwk = jwks.getKey(jwt.getHeader().getClaimAsString("kid"));
                RSAPrivateKey rsaPrivateKey = new RSAPrivateKey(jwk.getPrivateKey().getModulus(), jwk.getPrivateKey().getPrivateExponent());
                RSASigner rsaSigner = new RSASigner(signatureAlgorithm, rsaPrivateKey);
                jwt = rsaSigner.sign(jwt);
                break;
            }
            case ES256: 
            case ES384: 
            case ES512: {
                jwk = jwks.getKey(jwt.getHeader().getClaimAsString("kid"));
                ECDSAPrivateKey ecdsaPrivateKey = new ECDSAPrivateKey(jwk.getPrivateKey().getD());
                ECDSASigner ecdsaSigner = new ECDSASigner(signatureAlgorithm, ecdsaPrivateKey);
                jwt = ecdsaSigner.sign(jwt);
                break;
            }
            case NONE: {
                break;
            }
        }
        return jwt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Jwe generateEncryptedIdToken(IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Set<String> scopes) throws InvalidJweException, InvalidClaimException {
        JweEncrypterImpl jweEncrypter;
        Jwe jwe = new Jwe();
        KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenEncryptedResponseAlg());
        BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenEncryptedResponseEnc());
        jwe.getHeader().setType(JwtType.JWE);
        jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
        jwe.getClaims().setIssuer(ConfigurationFactory.instance().getConfiguration().getIssuer());
        jwe.getClaims().setAudience(authorizationGrant.getClient().getClientId());
        int lifeTime = ConfigurationFactory.instance().getConfiguration().getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwe.getClaims().setExpirationTime(expiration);
        jwe.getClaims().setIssuedAt(issuedAt);
        String openidSubAttribute = this.configurationFactory.getConfiguration().getOpenidSubAttribute();
        jwe.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute(openidSubAttribute));
        if (authorizationGrant.getAcrValues() != null) {
            jwe.getClaims().setClaim("acr", authorizationGrant.getAcrValues());
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwe.getClaims().setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwe.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = authorizationCode.getHash(null);
            jwe.getClaims().setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = accessToken.getHash(null);
            jwe.getClaims().setClaim("at_hash", accessTokenHash);
        }
        jwe.getClaims().setClaim("oxValidationURI", ConfigurationFactory.instance().getConfiguration().getCheckSessionIFrame());
        jwe.getClaims().setClaim("oxOpenIDConnectVersion", ConfigurationFactory.instance().getConfiguration().getOxOpenIdConnectVersion());
        ArrayList<String> dynamicScopes = new ArrayList<String>();
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
            if (ScopeType.DYNAMIC == scope.getScopeType()) {
                dynamicScopes.add(scope.getDisplayName());
                continue;
            }
            if (scope == null || scope.getOxAuthClaims() == null) continue;
            for (String claimDn : scope.getOxAuthClaims()) {
                GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                String claimName = gluuAttribute.getOxAuthClaimName();
                String ldapName = gluuAttribute.getName();
                String attributeValue = null;
                if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
                attributeValue = ldapName.equals("uid") ? authorizationGrant.getUser().getUserId() : authorizationGrant.getUser().getAttribute(gluuAttribute.getName());
                jwe.getClaims().setClaim(claimName, attributeValue);
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember().getClaims()) {
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null) continue;
                String ldapClaimName = gluuAttribute.getName();
                Object attribute = authorizationGrant.getUser().getAttribute(ldapClaimName, optional);
                if (attribute == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value = jsonArray.optString(i);
                        if (value == null) continue;
                        values.add(value);
                    }
                    jwe.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                String value = (String)attribute;
                jwe.getClaims().setClaim(claim.getName(), value);
            }
        }
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopes, (JsonWebResponse)jwe, authorizationGrant.getUser());
        }
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            PublicKey publicKey = JwtUtil.getPublicKey((String)authorizationGrant.getClient().getJwksUri(), null, (SignatureAlgorithm)SignatureAlgorithm.RS256, null);
            if (publicKey == null) throw new InvalidJweException("The public key is not valid");
            if (!(publicKey instanceof RSAPublicKey)) throw new InvalidJweException("The public key is not valid");
            jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, (RSAPublicKey)publicKey);
            return jweEncrypter.encrypt(jwe);
        }
        if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A128KW) {
            if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A256KW) return jwe;
        }
        try {
            byte[] sharedSymmetricKey = authorizationGrant.getClient().getClientSecret().getBytes("UTF-8");
            jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedSymmetricKey);
            return jweEncrypter.encrypt(jwe);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJweException((Throwable)e);
        }
    }

    public static IdTokenFactory instance() {
        boolean createContexts;
        boolean bl = createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        if (createContexts) {
            Lifecycle.beginCall();
        }
        return (IdTokenFactory)Component.getInstance(IdTokenFactory.class);
    }
}

