/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.fido.u2f;

import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.BaseEntry;
import org.xdi.oxauth.exception.fido.u2f.InvalidDeviceCounterException;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistrationConfiguration;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistrationStatus;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.util.Base64Util;

@LdapEntry(sortBy={"creationDate"})
@LdapObjectClass(values={"top", "oxDeviceRegistration"})
public class DeviceRegistration
extends BaseEntry
implements Serializable {
    private static final long serialVersionUID = -4542931562244920584L;
    @LdapAttribute(ignoreDuringUpdate=true, name="oxId")
    private String id;
    @LdapJsonObject
    @LdapAttribute(name="oxDeviceRegistrationConf")
    private DeviceRegistrationConfiguration deviceRegistrationConfiguration;
    @LdapAttribute(name="oxCounter")
    private long counter;
    @LdapAttribute(name="oxStatus")
    private DeviceRegistrationStatus status;
    @LdapAttribute(name="oxApplication")
    private String application;
    @LdapAttribute(name="creationDate")
    private Date creationDate;

    public DeviceRegistration() {
    }

    public DeviceRegistration(String keyHandle, String publicKey, String attestationCert, long counter, DeviceRegistrationStatus status, String application, Date creationDate) {
        this.deviceRegistrationConfiguration = new DeviceRegistrationConfiguration(keyHandle, publicKey, attestationCert);
        this.counter = counter;
        this.status = status;
        this.application = application;
        this.creationDate = creationDate;
    }

    public DeviceRegistration(String keyHandle, String publicKey, X509Certificate attestationCert, long counter) throws BadInputException {
        try {
            String attestationCertDecoded = Base64Util.base64urlencode((byte[])attestationCert.getEncoded());
            this.deviceRegistrationConfiguration = new DeviceRegistrationConfiguration(keyHandle, publicKey, attestationCertDecoded);
        }
        catch (CertificateEncodingException e) {
            throw new BadInputException("Malformed attestation certificate", (Throwable)e);
        }
        this.counter = counter;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DeviceRegistrationConfiguration getDeviceRegistrationConfiguration() {
        return this.deviceRegistrationConfiguration;
    }

    public void setDeviceRegistrationConfiguration(DeviceRegistrationConfiguration deviceRegistrationConfiguration) {
        this.deviceRegistrationConfiguration = deviceRegistrationConfiguration;
    }

    public long getCounter() {
        return this.counter;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    public DeviceRegistrationStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceRegistrationStatus status) {
        this.status = status;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isCompromised() {
        return DeviceRegistrationStatus.COMPROMISED == this.status;
    }

    public void markCompromised() {
        this.status = DeviceRegistrationStatus.COMPROMISED;
    }

    public void checkAndUpdateCounter(long clientCounter) throws InvalidDeviceCounterException {
        if (clientCounter <= this.counter) {
            this.markCompromised();
            throw new InvalidDeviceCounterException(this);
        }
        this.counter = clientCounter;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeviceRegistration [id=").append(this.id).append(", deviceRegistrationConfiguration=").append(this.deviceRegistrationConfiguration).append(", counter=").append(this.counter).append(", status=").append(this.status).append(", application=").append(this.application).append(", creationDate=").append(this.creationDate).append("]");
        return builder.toString();
    }
}

