/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.config;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.LdapMappingException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.exception.ConfigurationException;
import org.xdi.oxauth.model.config.BaseDnConfiguration;
import org.xdi.oxauth.model.config.Conf;
import org.xdi.oxauth.model.config.Configuration;
import org.xdi.oxauth.model.config.StaticConf;
import org.xdi.oxauth.model.error.ErrorMessages;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.properties.FileConfiguration;

@Scope(value=ScopeType.APPLICATION)
@Name(value="configurationFactory")
@AutoCreate
@Startup
public class ConfigurationFactory {
    private static final Log LOG = Logging.getLog(ConfigurationFactory.class);
    public static final String LDAP_CONFIGUARION_RELOAD_EVENT_TYPE = "LDAP_CONFIGUARION_RELOAD";
    private static final String EVENT_TYPE = "ConfigurationFactoryTimerEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private static final String BASE_DIR = System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null));
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String CONFIG_RELOAD_MARKER_FILE_PATH = DIR + "oxauth.config.reload";
    private static final String LDAP_FILE_PATH = DIR + "oxauth-ldap.properties";
    @Logger
    private Log log;
    private final String CONFIG_FILE_NAME = "oxauth-config.xml";
    private final String ERRORS_FILE_NAME = "oxauth-errors.json";
    private final String STATIC_CONF_FILE_NAME = "oxauth-static-conf.json";
    private final String WEB_KEYS_FILE_NAME = "oxauth-web-keys.json";
    private final String SALT_FILE_NAME = "salt";
    private String confDir;
    private String configFilePath;
    private String errorsFilePath;
    private String staticConfFilePath;
    private String webKeysFilePath;
    private String saltFilePath;
    private FileConfiguration ldapConfiguration;
    private Configuration m_conf;
    private StaticConf m_staticConf;
    private JSONWebKeySet m_jwks;
    private AtomicBoolean isActive;
    private long ldapFileLastModifiedTime = -1L;
    private long confFileLastModifiedTime = -1L;
    private long errorsFileLastModifiedTime = -1L;
    private long staticConfFileLastModifiedTime = -1L;
    private long webKeysFileLastModifiedTime = -1L;

    @Create
    public void init() {
        this.loadLdapConfiguration();
        this.confDir = this.confDir();
        this.configFilePath = this.confDir + "oxauth-config.xml";
        this.errorsFilePath = this.confDir + "oxauth-errors.json";
        this.staticConfFilePath = this.confDir + "oxauth-static-conf.json";
        this.webKeysFilePath = this.getLdapConfiguration().getString("certsDir") + File.separator + "oxauth-web-keys.json";
        this.saltFilePath = this.confDir + "salt";
    }

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void initReloadTimer() {
        this.isActive = new AtomicBoolean(false);
        long delayBeforeFirstRun = 60000L;
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(60000L), Long.valueOf(30000L)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"ConfigurationFactoryTimerEvent"})
    @Asynchronous
    public void reloadConfigurationTimerEvent() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error((Object)"Exception happened while reloading application configuration", ex, new Object[0]);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadConfiguration() {
        File reloadMarker = new File(CONFIG_RELOAD_MARKER_FILE_PATH);
        if (reloadMarker.exists()) {
            long lastModified;
            boolean isAnyChanged = false;
            File ldapFile = new File(LDAP_FILE_PATH);
            File configFile = new File(this.configFilePath);
            File errorsFile = new File(this.errorsFilePath);
            File staticConfFile = new File(this.staticConfFilePath);
            File webkeysFile = new File(this.webKeysFilePath);
            if (configFile.exists() && (lastModified = configFile.lastModified()) > this.confFileLastModifiedTime) {
                this.reloadConfFromFile();
                this.confFileLastModifiedTime = lastModified;
                isAnyChanged = true;
            }
            if (errorsFile.exists() && (lastModified = errorsFile.lastModified()) > this.errorsFileLastModifiedTime) {
                this.reloadErrorsFromFile();
                this.errorsFileLastModifiedTime = lastModified;
                isAnyChanged = true;
            }
            if (staticConfFile.exists() && (lastModified = staticConfFile.lastModified()) > this.staticConfFileLastModifiedTime) {
                this.reloadStaticConfFromFile();
                this.staticConfFileLastModifiedTime = lastModified;
                isAnyChanged = true;
            }
            if (webkeysFile.exists() && (lastModified = webkeysFile.lastModified()) > this.webKeysFileLastModifiedTime) {
                this.reloadWebkeyFromFile();
                this.webKeysFileLastModifiedTime = lastModified;
                isAnyChanged = true;
            }
            if (isAnyChanged) {
                this.persistToLdap(ServerUtil.getLdapManager());
            }
            if (ldapFile.exists() && (lastModified = ldapFile.lastModified()) > this.ldapFileLastModifiedTime) {
                this.loadLdapConfiguration();
                this.ldapFileLastModifiedTime = lastModified;
                Events.instance().raiseAsynchronousEvent(LDAP_CONFIGUARION_RELOAD_EVENT_TYPE, new Object[0]);
                boolean bl = true;
            }
        }
    }

    private void determineConfigurationLastModificationTime() {
        File ldapFile = new File(LDAP_FILE_PATH);
        File configFile = new File(this.configFilePath);
        File errorsFile = new File(this.errorsFilePath);
        File staticConfFile = new File(this.staticConfFilePath);
        File webKeysFile = new File(this.webKeysFilePath);
        if (ldapFile.exists()) {
            this.ldapFileLastModifiedTime = ldapFile.lastModified();
        }
        if (configFile.exists()) {
            this.confFileLastModifiedTime = configFile.lastModified();
        }
        if (errorsFile.exists()) {
            this.errorsFileLastModifiedTime = errorsFile.lastModified();
        }
        if (staticConfFile.exists()) {
            this.staticConfFileLastModifiedTime = staticConfFile.lastModified();
        }
        if (webKeysFile.exists()) {
            this.webKeysFileLastModifiedTime = webKeysFile.lastModified();
        }
    }

    private String confDir() {
        String confDir = this.getLdapConfiguration().getString("confDir");
        if (StringUtils.isNotBlank((String)confDir)) {
            return confDir;
        }
        return DIR;
    }

    public FileConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public StaticConf getStaticConfiguration() {
        return this.m_staticConf;
    }

    public BaseDnConfiguration getBaseDn() {
        return this.getStaticConfiguration().getBaseDn();
    }

    public JSONWebKeySet getWebKeys() {
        return this.m_jwks;
    }

    public void create() {
        if (!this.createFromLdap(true)) {
            LOG.error((Object)"Failed to load configuration from LDAP. Please fix it!!!.", new Object[0]);
            throw new ConfigurationException("Failed to load configuration from LDAP.");
        }
        LOG.info((Object)"Configuration loaded successfully.", new Object[0]);
        this.determineConfigurationLastModificationTime();
    }

    private void createFromFile() {
        this.reloadConfFromFile();
        this.reloadErrorsFromFile();
        this.reloadStaticConfFromFile();
        this.reloadWebkeyFromFile();
    }

    private void reloadWebkeyFromFile() {
        JSONWebKeySet webKeysFromFile = this.loadWebKeysFromFile();
        if (webKeysFromFile != null) {
            LOG.info((Object)("Reloaded web keys from file: " + this.webKeysFilePath), new Object[0]);
            this.m_jwks = webKeysFromFile;
        } else {
            LOG.error((Object)("Failed to load web keys configuration from file: " + this.webKeysFilePath), new Object[0]);
        }
    }

    private void reloadStaticConfFromFile() {
        StaticConf staticConfFromFile = this.loadStaticConfFromFile();
        if (staticConfFromFile != null) {
            LOG.info((Object)("Reloaded static conf from file: " + this.staticConfFilePath), new Object[0]);
            this.m_staticConf = staticConfFromFile;
        } else {
            LOG.error((Object)("Failed to load static configuration from file: " + this.staticConfFilePath), new Object[0]);
        }
    }

    private void reloadErrorsFromFile() {
        ErrorMessages errorsFromFile = this.loadErrorsFromFile();
        if (errorsFromFile != null) {
            LOG.info((Object)("Reloaded errors from file: " + this.errorsFilePath), new Object[0]);
            ErrorResponseFactory f = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
            f.setMessages(errorsFromFile);
        } else {
            LOG.error((Object)("Failed to load errors from file: " + this.errorsFilePath), new Object[0]);
        }
    }

    private void reloadConfFromFile() {
        Configuration configFromFile = this.loadConfFromFile();
        if (configFromFile != null) {
            LOG.info((Object)("Reloaded configuration from file: " + this.configFilePath), new Object[0]);
            this.m_conf = configFromFile;
        } else {
            LOG.error((Object)("Failed to load configuration from file: " + this.configFilePath), new Object[0]);
        }
    }

    public boolean updateFromLdap() {
        return this.createFromLdap(false);
    }

    private boolean createFromLdap(boolean p_recoverFromFiles) {
        LOG.info((Object)"Loading configuration from LDAP...", new Object[0]);
        LdapEntryManager ldapManager = ServerUtil.getLdapManager();
        String dn = this.getLdapConfiguration().getString("configurationEntryDN");
        try {
            Conf conf = (Conf)ldapManager.find(Conf.class, (Object)dn);
            if (conf != null) {
                this.init(conf);
                return true;
            }
        }
        catch (LdapMappingException e) {
            LOG.warn((Object)e.getMessage(), new Object[0]);
            if (p_recoverFromFiles) {
                LOG.info((Object)"Unable to find configuration in LDAP, try to create configuration entry in LDAP... ", new Object[0]);
                if (this.getLdapConfiguration().getBoolean("createLdapConfigurationEntryIfNotExist") && this.reloadFromFileAndPersistToLdap(ldapManager)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return false;
    }

    private boolean reloadFromFileAndPersistToLdap(LdapEntryManager ldapManager) {
        this.createFromFile();
        return this.persistToLdap(ldapManager);
    }

    private boolean persistToLdap(LdapEntryManager ldapManager) {
        Conf conf = this.asConf();
        if (conf != null) {
            try {
                ldapManager.persist((Object)conf);
                LOG.info((Object)"Configuration entry is created in LDAP.", new Object[0]);
                return true;
            }
            catch (Exception ex) {
                try {
                    ldapManager.merge((Object)conf);
                    LOG.info((Object)"Configuration entry updated in LDAP.", new Object[0]);
                    return true;
                }
                catch (Exception e) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                    LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                }
            }
        }
        return false;
    }

    private Conf asConf() {
        try {
            String dn = this.getLdapConfiguration().getString("configurationEntryDN");
            ErrorResponseFactory errorFactory = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
            Conf c = new Conf();
            c.setDn(dn);
            c.setDynamic(ServerUtil.createJsonMapper().writeValueAsString((Object)this.m_conf));
            c.setErrors(ServerUtil.createJsonMapper().writeValueAsString((Object)errorFactory.getMessages()));
            c.setStatics(ServerUtil.createJsonMapper().writeValueAsString((Object)this.m_staticConf));
            c.setWebKeys(ServerUtil.createJsonMapper().writeValueAsString((Object)this.m_jwks));
            return c;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private void init(Conf p_conf) {
        this.initConfigurationFromJson(p_conf.getDynamic());
        this.initStaticConfigurationFromJson(p_conf.getStatics());
        this.initErrorsFromJson(p_conf.getErrors());
        this.initWebKeysFromJson(p_conf.getWebKeys());
    }

    private void initWebKeysFromJson(String p_webKeys) {
        try {
            JSONWebKeySet k = (JSONWebKeySet)ServerUtil.createJsonMapper().readValue(p_webKeys, JSONWebKeySet.class);
            if (k != null) {
                this.m_jwks = k;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void initStaticConfigurationFromJson(String p_statics) {
        try {
            StaticConf c = (StaticConf)ServerUtil.createJsonMapper().readValue(p_statics, StaticConf.class);
            if (c != null) {
                this.m_staticConf = c;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void initConfigurationFromJson(String p_configurationJson) {
        try {
            Configuration c = (Configuration)ServerUtil.createJsonMapper().readValue(p_configurationJson, Configuration.class);
            if (c != null) {
                this.m_conf = c;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void initErrorsFromJson(String p_errosAsJson) {
        try {
            ErrorMessages errorMessages = (ErrorMessages)ServerUtil.createJsonMapper().readValue(p_errosAsJson, ErrorMessages.class);
            if (errorMessages != null) {
                ErrorResponseFactory f = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
                f.setMessages(errorMessages);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void loadLdapConfiguration() {
        try {
            this.ldapConfiguration = new FileConfiguration(LDAP_FILE_PATH);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            this.ldapConfiguration = null;
        }
    }

    public Configuration loadConfFromFile() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller u = jc.createUnmarshaller();
            return (Configuration)u.unmarshal(new File(this.configFilePath));
        }
        catch (JAXBException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private ErrorMessages loadErrorsFromFile() {
        try {
            return (ErrorMessages)ServerUtil.createJsonMapper().readValue(new File(this.errorsFilePath), ErrorMessages.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private StaticConf loadStaticConfFromFile() {
        try {
            return (StaticConf)ServerUtil.createJsonMapper().readValue(new File(this.staticConfFilePath), StaticConf.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private JSONWebKeySet loadWebKeysFromFile() {
        try {
            return (JSONWebKeySet)ServerUtil.createJsonMapper().readValue(new File(this.webKeysFilePath), JSONWebKeySet.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    public String loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = this.createFileConfiguration(this.saltFilePath, true);
            return cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to load configuration from {0}", (Throwable)ex, new Object[]{this.saltFilePath});
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        try {
            FileConfiguration fileConfiguration = new FileConfiguration(fileName);
            return fileConfiguration;
        }
        catch (Exception ex) {
            if (isMandatory) {
                LOG.error((Object)"Failed to load configuration from {0}", (Throwable)ex, new Object[]{fileName});
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
            return null;
        }
    }

    public static ConfigurationFactory instance() {
        boolean createContexts;
        boolean bl = createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        if (createContexts) {
            Lifecycle.beginCall();
        }
        return (ConfigurationFactory)Component.getInstance(ConfigurationFactory.class);
    }
}

