/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.jboss.seam.Component;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.oxauth.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationCodeGrant;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantLdap;
import org.xdi.oxauth.model.common.AuthorizationGrantType;
import org.xdi.oxauth.model.common.ClientCredentialsGrant;
import org.xdi.oxauth.model.common.IAuthorizationGrantList;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.ImplicitGrant;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.ldap.TokenType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.StringUtils;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.GrantService;
import org.xdi.oxauth.service.UserService;

public class AuthorizationGrantListLdap
implements IAuthorizationGrantList {
    private static final Log LOGGER = Logging.getLog(AuthorizationGrantListLdap.class);
    private final GrantService m_grantServive = GrantService.instance();
    private final UserService m_userService = (UserService)Component.getInstance(UserService.class);
    private final ClientService m_clientService = (ClientService)Component.getInstance(ClientService.class);

    private AuthorizationGrantListLdap() {
    }

    public static AuthorizationGrantListLdap instance() {
        return new AuthorizationGrantListLdap();
    }

    @Override
    public List<AuthorizationGrant> getAuthorizationGrants() {
        return Collections.emptyList();
    }

    @Override
    public void removeAuthorizationGrants(List<AuthorizationGrant> authorizationGrants) {
        if (authorizationGrants != null && !authorizationGrants.isEmpty()) {
            for (AuthorizationGrant r : authorizationGrants) {
                this.m_grantServive.remove(r);
            }
        }
    }

    @Override
    public void addAuthorizationGrant(AuthorizationGrant authorizationGrant) {
    }

    @Override
    public AuthorizationGrant createAuthorizationGrant(User user, Client client, Date authenticationTime) {
        return new AuthorizationGrant(user, null, client, authenticationTime);
    }

    @Override
    public AuthorizationCodeGrant createAuthorizationCodeGrant(User user, Client client, Date authenticationTime) {
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant(user, client, authenticationTime);
        AuthorizationGrantLdap ldapGrant = (AuthorizationGrantLdap)grant.getGrant();
        ldapGrant.persist(grant.getAuthorizationCode());
        return grant;
    }

    @Override
    public ImplicitGrant createImplicitGrant(User user, Client client, Date authenticationTime) {
        return new ImplicitGrant(user, client, authenticationTime);
    }

    @Override
    public ClientCredentialsGrant createClientCredentialsGrant(User user, Client client) {
        return new ClientCredentialsGrant(user, client);
    }

    @Override
    public ResourceOwnerPasswordCredentialsGrant createResourceOwnerPasswordCredentialsGrant(User user, Client client) {
        return new ResourceOwnerPasswordCredentialsGrant(user, client);
    }

    @Override
    public AuthorizationCodeGrant getAuthorizationCodeGrant(String clientId, String authorizationCode) {
        return (AuthorizationCodeGrant)this.load(clientId, authorizationCode);
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByRefreshToken(String clientId, String refreshTokenCode) {
        return this.load(clientId, refreshTokenCode);
    }

    @Override
    public List<AuthorizationGrant> getAuthorizationGrant(String clientId) {
        ArrayList<AuthorizationGrant> result = new ArrayList<AuthorizationGrant>();
        try {
            List<TokenLdap> entries = this.m_grantServive.getGrantsOfClient(clientId);
            if (entries != null && !entries.isEmpty()) {
                for (TokenLdap t : entries) {
                    AuthorizationGrant grant = this.asGrant(t);
                    if (grant == null) continue;
                    result.add(grant);
                }
            }
        }
        catch (Exception e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return result;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByAccessToken(String accessToken) {
        TokenLdap tokenLdap = this.m_grantServive.getGrantsByCode(accessToken);
        if (tokenLdap != null && (tokenLdap.getTokenTypeEnum() == TokenType.ACCESS_TOKEN || tokenLdap.getTokenTypeEnum() == TokenType.LONG_LIVED_ACCESS_TOKEN)) {
            return this.asGrant(tokenLdap);
        }
        return null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByIdToken(String idToken) {
        return this.asGrant(this.m_grantServive.getGrantsByCode(idToken));
    }

    public AuthorizationGrant load(String clientId, String p_code) {
        return this.asGrant(this.m_grantServive.getGrantsByCodeAndClient(p_code, clientId));
    }

    public static String extractClientIdFromTokenDn(String p_dn) {
        try {
            Object[] rdNs;
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)p_dn) && ArrayUtils.isNotEmpty((Object[])(rdNs = DN.getRDNs((String)p_dn)))) {
                for (Object r : rdNs) {
                    Object[] values;
                    Object[] names = r.getAttributeNames();
                    if (!ArrayUtils.isNotEmpty((Object[])names) || !Arrays.asList(names).contains("inum") || !ArrayUtils.isNotEmpty((Object[])(values = r.getAttributeValues()))) continue;
                    return values[0];
                }
            }
        }
        catch (LDAPException e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return "";
    }

    public AuthorizationGrant asGrant(TokenLdap tokenLdap) {
        AuthorizationGrantType grantType;
        if (tokenLdap != null && (grantType = AuthorizationGrantType.fromString(tokenLdap.getGrantType())) != null) {
            User user = this.m_userService.getUser(tokenLdap.getUserId(), new String[0]);
            Client client = this.m_clientService.getClient(AuthorizationGrantListLdap.extractClientIdFromTokenDn(tokenLdap.getDn()));
            Date authenticationTime = StringUtils.parseSilently((String)tokenLdap.getAuthenticationTime());
            String nonce = tokenLdap.getNonce();
            AuthorizationGrant result = null;
            switch (grantType) {
                case AUTHORIZATION_CODE: {
                    result = new AuthorizationCodeGrant(user, client, authenticationTime);
                    break;
                }
                case CLIENT_CREDENTIALS: {
                    result = new ClientCredentialsGrant(user, client);
                    break;
                }
                case IMPLICIT: {
                    result = new ImplicitGrant(user, client, authenticationTime);
                    break;
                }
                case RESOURCE_OWNER_PASSWORD_CREDENTIALS: {
                    result = new ResourceOwnerPasswordCredentialsGrant(user, client);
                    break;
                }
                default: {
                    return null;
                }
            }
            String grantId = tokenLdap.getGrantId();
            String jwtRequest = tokenLdap.getJwtRequest();
            String authMode = tokenLdap.getAuthMode();
            result.setNonce(nonce);
            result.setTokenLdap(tokenLdap);
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)grantId)) {
                result.setGrantId(grantId);
            }
            result.setScopes(Util.splittedStringAsList((String)tokenLdap.getScope(), (String)" "));
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)jwtRequest)) {
                try {
                    result.setJwtAuthorizationRequest(new JwtAuthorizationRequest(jwtRequest, client));
                }
                catch (Exception e) {
                    LOGGER.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                }
            }
            result.setAcrValues(authMode);
            if (tokenLdap.getTokenTypeEnum() != null) {
                switch (tokenLdap.getTokenTypeEnum()) {
                    case AUTHORIZATION_CODE: {
                        if (!(result instanceof AuthorizationCodeGrant)) break;
                        AuthorizationCode code = new AuthorizationCode(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        AuthorizationCodeGrant g = (AuthorizationCodeGrant)result;
                        g.setAuthorizationCode(code);
                        break;
                    }
                    case REFRESH_TOKEN: {
                        RefreshToken refreshToken = new RefreshToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setRefreshTokens(Arrays.asList(refreshToken));
                        break;
                    }
                    case ACCESS_TOKEN: {
                        AccessToken accessToken = new AccessToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setAccessTokens(Arrays.asList(accessToken));
                        break;
                    }
                    case ID_TOKEN: {
                        IdToken idToken = new IdToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setIdToken(idToken);
                        break;
                    }
                    case LONG_LIVED_ACCESS_TOKEN: {
                        AccessToken longLivedAccessToken = new AccessToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setLongLivedAccessToken(longLivedAccessToken);
                    }
                }
            }
            return result;
        }
        return null;
    }
}

