/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Calendar;
import java.util.Date;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.token.HandleTokenFactory;
import org.xdi.oxauth.model.util.JwtUtil;

public abstract class AbstractToken {
    @LdapAttribute(name="oxAuthTokenCode")
    private String code;
    @LdapAttribute(name="oxAuthCreation")
    private Date creationDate;
    @LdapAttribute(name="oxAuthExpiration")
    private Date expirationDate;
    private boolean revoked;
    private boolean expired;
    @LdapAttribute(name="oxAuthenticationMode")
    private String authMode;

    public AbstractToken(int lifeTime) {
        Calendar calendar = Calendar.getInstance();
        this.creationDate = calendar.getTime();
        calendar.add(13, lifeTime);
        this.expirationDate = calendar.getTime();
        this.code = HandleTokenFactory.generateHandleToken();
        this.revoked = false;
        this.expired = false;
    }

    protected AbstractToken(String code, Date creationDate, Date expirationDate) {
        this.code = code;
        this.creationDate = creationDate;
        this.expirationDate = expirationDate;
        this.checkExpired();
    }

    public void checkExpired() {
        this.checkExpired(new Date());
    }

    public void checkExpired(Date now) {
        if (now.after(this.expirationDate)) {
            this.expired = true;
        }
    }

    public boolean isValid() {
        return !this.revoked && !this.expired;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getCreationDate() {
        return this.creationDate != null ? new Date(this.creationDate.getTime()) : null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
    }

    public Date getExpirationDate() {
        return this.expirationDate != null ? new Date(this.expirationDate.getTime()) : null;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate != null ? new Date(expirationDate.getTime()) : null;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public synchronized void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public synchronized void setExpired(boolean expired) {
        this.expired = expired;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public int getExpiresIn() {
        int expiresIn = 0;
        this.checkExpired();
        if (this.isValid()) {
            long diff = this.expirationDate.getTime() - new Date().getTime();
            expiresIn = diff != 0L ? (int)(diff / 1000L) : 0;
        }
        return expiresIn;
    }

    public String getHash(SignatureAlgorithm signatureAlgorithm) {
        String hash = null;
        try {
            byte[] digest = null;
            digest = signatureAlgorithm == SignatureAlgorithm.HS256 || signatureAlgorithm == SignatureAlgorithm.RS256 || signatureAlgorithm == SignatureAlgorithm.ES256 ? JwtUtil.getMessageDigestSHA256((String)this.code) : (signatureAlgorithm == SignatureAlgorithm.HS384 || signatureAlgorithm == SignatureAlgorithm.RS384 || signatureAlgorithm == SignatureAlgorithm.ES512 ? JwtUtil.getMessageDigestSHA384((String)this.code) : (signatureAlgorithm == SignatureAlgorithm.HS512 || signatureAlgorithm == SignatureAlgorithm.RS384 || signatureAlgorithm == SignatureAlgorithm.ES512 ? JwtUtil.getMessageDigestSHA512((String)this.code) : JwtUtil.getMessageDigestSHA256((String)this.code)));
            if (digest != null) {
                byte[] lefMostHalf = new byte[digest.length / 2];
                System.arraycopy(digest, 0, lefMostHalf, 0, lefMostHalf.length);
                hash = JwtUtil.base64urlencode((byte[])lefMostHalf);
            }
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hash;
    }
}

