/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.jwk.ws.rs;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.jwk.ws.rs.JwkRestWebService;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.jwk.JSONWebKey;

@Name(value="requestJwkRestWebService")
public class JwkRestWebServiceImpl
implements JwkRestWebService {
    @Logger
    private Log log;

    @Override
    public Response requestJwk(SecurityContext sec) {
        this.log.debug((Object)"Attempting to request JWK, Is Secure = {0}", new Object[]{sec.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        builder.entity((Object)this.getJSonResponse());
        return builder.build();
    }

    public String getJSonResponse() {
        JSONObject jsonObj = new JSONObject();
        JSONArray keys = new JSONArray();
        try {
            for (JSONWebKey jsonWebKey : ConfigurationFactory.instance().getWebKeys().getKeys()) {
                JSONObject jsonKeyValue = new JSONObject();
                if (jsonWebKey.getKeyType() != null) {
                    jsonKeyValue.put("kty", (Object)jsonWebKey.getKeyType());
                }
                if (jsonWebKey.getKeyId() != null) {
                    jsonKeyValue.put("kid", (Object)jsonWebKey.getKeyId());
                }
                if (ConfigurationFactory.instance().getConfiguration().getKeyRegenerationEnabled().booleanValue() && jsonWebKey.getExpirationTime() != null) {
                    jsonKeyValue.put("exp", (Object)jsonWebKey.getExpirationTime());
                }
                if (jsonWebKey.getUse() != null) {
                    jsonKeyValue.put("use", (Object)jsonWebKey.getUse());
                }
                if (jsonWebKey.getAlgorithm() != null) {
                    jsonKeyValue.put("alg", (Object)jsonWebKey.getAlgorithm());
                }
                if (jsonWebKey.getCurve() != null) {
                    jsonKeyValue.put("crv", (Object)jsonWebKey.getCurve());
                }
                if (jsonWebKey.getPublicKey() == null) continue;
                if (jsonWebKey.getPublicKey().getModulus() != null) {
                    jsonKeyValue.put("n", (Object)jsonWebKey.getPublicKey().getModulus());
                }
                if (jsonWebKey.getPublicKey().getExponent() != null) {
                    jsonKeyValue.put("e", (Object)jsonWebKey.getPublicKey().getExponent());
                }
                if (jsonWebKey.getPublicKey().getX() != null) {
                    jsonKeyValue.put("x", (Object)jsonWebKey.getPublicKey().getX());
                }
                if (jsonWebKey.getPublicKey().getY() != null) {
                    jsonKeyValue.put("y", (Object)jsonWebKey.getPublicKey().getY());
                }
                if (jsonWebKey.getCertificateChain() != null) {
                    // empty if block
                }
                keys.put((Object)jsonKeyValue);
            }
            jsonObj.put("keys", (Object)keys);
            return jsonObj.toString(4);
        }
        catch (JSONException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }
}

