/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.crypto.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.openssl.PEMReader;

public class CertificateParser {
    public static X509Certificate parsePem(String pemEncodedCert) throws CertificateException {
        StringReader sr = new StringReader(pemEncodedCert);
        PEMReader pemReader = new PEMReader((Reader)sr);
        try {
            X509CertificateObject cert;
            X509CertificateObject x509CertificateObject = cert = (X509CertificateObject)pemReader.readObject();
            return x509CertificateObject;
        }
        catch (IOException ex) {
            throw new CertificateException(ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)pemReader);
        }
    }

    public static X509Certificate parseDer(String base64DerEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(Base64.decodeBase64((String)base64DerEncodedCert));
    }

    public static X509Certificate parseDer(byte[] derEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(new ByteArrayInputStream(derEncodedCert));
    }

    public static X509Certificate parseDer(InputStream is) throws CertificateException {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(is);
        }
        catch (NoSuchProviderException ex) {
            throw new CertificateException(ex);
        }
    }
}

