/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.util.StringUtils;
import org.xdi.oxauth.ws.rs.ClientTestUtil;

public class UserInfoRestWebServiceEmbeddedTest
extends BaseTest {
    private String clientId;
    private String clientSecret;
    private String accessToken1;
    private String accessToken2;
    private String accessToken3;
    private String accessToken4;
    private String accessToken5;
    private String accessToken6;
    private String accessToken7;
    private String clientId1;
    private String clientId2;
    private String clientId3;
    private String clientSecret1;
    private String clientSecret2;
    private String clientSecret3;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void dynamicClientRegistration(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("dynamicClientRegistration", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    RegisterResponse registerResponse = RegisterResponse.valueOf((String)response.getContentAsString());
                    ClientTestUtil.assert_((RegisterResponse)registerResponse);
                    UserInfoRestWebServiceEmbeddedTest.this.clientId = registerResponse.getClientId();
                    UserInfoRestWebServiceEmbeddedTest.this.clientSecret = registerResponse.getClientSecret();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestUserInfoStep1ImplicitFlow(String authorizePath, String userId, String userSecret, final String redirectUri) throws Exception {
        final String userEncodedCredentials = Base64.encodeBase64String((byte[])(userId + ":" + userSecret).getBytes());
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Basic " + userEncodedCredentials));
                request.addHeader("Accept", (Object)"text/plain");
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, UserInfoRestWebServiceEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfo step 1 Implicit Flow", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                        Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                        Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                        Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                        UserInfoRestWebServiceEmbeddedTest.this.accessToken1 = (String)params.get("access_token");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"Unexpected error");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoStep1ImplicitFlow"})
    public void requestUserInfoStep2PostImplicitFlow(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + UserInfoRestWebServiceEmbeddedTest.this.accessToken1));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(null);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfo step 2 POST Implicit Flow", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("sub"));
                    Assert.assertTrue((boolean)jsonObj.has("name"));
                    Assert.assertTrue((boolean)jsonObj.has("given_name"));
                    Assert.assertTrue((boolean)jsonObj.has("family_name"));
                    Assert.assertTrue((boolean)jsonObj.has("email"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoStep1ImplicitFlow"})
    public void requestUserInfoStep2GetImplicitFlow(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + UserInfoRestWebServiceEmbeddedTest.this.accessToken1));
                UserInfoRequest userInfoRequest = new UserInfoRequest(null);
                request.setQueryString(userInfoRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfo step 2 GET Implicit Flow", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("sub"));
                    Assert.assertTrue((boolean)jsonObj.has("name"));
                    Assert.assertTrue((boolean)jsonObj.has("given_name"));
                    Assert.assertTrue((boolean)jsonObj.has("family_name"));
                    Assert.assertTrue((boolean)jsonObj.has("email"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "userId", "userSecret"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestUserInfoStep1PasswordFlow(String tokenPath, final String userId, final String userSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
                tokenRequest.setUsername(userId);
                tokenRequest.setPassword(userSecret);
                tokenRequest.setScope("openid profile address email");
                tokenRequest.setAuthUsername(UserInfoRestWebServiceEmbeddedTest.this.clientId);
                tokenRequest.setAuthPassword(UserInfoRestWebServiceEmbeddedTest.this.clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoStep1PasswordFlow", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertTrue((!response.getContentAsString().equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                    UserInfoRestWebServiceEmbeddedTest.this.accessToken4 = jsonObj.getString("access_token");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoStep1PasswordFlow"})
    public void requestUserInfoStep2PasswordFlow(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + UserInfoRestWebServiceEmbeddedTest.this.accessToken4));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(null);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoStep2PasswordFlow", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("sub"));
                    Assert.assertTrue((boolean)jsonObj.has("name"));
                    Assert.assertTrue((boolean)jsonObj.has("given_name"));
                    Assert.assertTrue((boolean)jsonObj.has("family_name"));
                    Assert.assertTrue((boolean)jsonObj.has("email"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test
    public void requestUserInfoInvalidRequest(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(null);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoInvalidRequest", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test
    public void requestUserInfoInvalidToken(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest("INVALID_ACCESS_TOKEN");
                userInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoInvalidToken", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test
    public void requestUserInfoInvalidSchema(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest("INVALID_ACCESS_TOKEN");
                Map userInfoParameters = userInfoRequest.getParameters();
                userInfoParameters.put("schema", "INVALID_SCHEMA");
                request.addParameters(userInfoParameters);
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoInvalidSchema", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestUserInfoInsufficientScope(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("picture");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, UserInfoRestWebServiceEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoInsufficientScope step 1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                        Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                        Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                        Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                        UserInfoRestWebServiceEmbeddedTest.this.accessToken2 = (String)params.get("access_token");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoInsufficientScope"})
    public void requestUserInfoInsufficientScopeStep2(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(UserInfoRestWebServiceEmbeddedTest.this.accessToken2);
                userInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoInsufficientScope step 2", response);
                Assert.assertEquals((int)response.getStatus(), (int)403, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestUserInfoAdditionalClaims(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, UserInfoRestWebServiceEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, UserInfoRestWebServiceEmbeddedTest.this.clientSecret);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("invalid", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("iname", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("o", ClaimValue.createEssential((boolean)true)));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoAdditionalClaims step 1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                        Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                        Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                        Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                        UserInfoRestWebServiceEmbeddedTest.this.accessToken3 = (String)params.get("access_token");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoAdditionalClaims"})
    public void requestUserInfoAdditionalClaimsStep2(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(UserInfoRestWebServiceEmbeddedTest.this.accessToken3);
                userInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoAdditionalClaims step 2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("sub"));
                    Assert.assertTrue((boolean)jsonObj.has("name"));
                    Assert.assertTrue((boolean)jsonObj.has("given_name"));
                    Assert.assertTrue((boolean)jsonObj.has("family_name"));
                    Assert.assertTrue((boolean)jsonObj.has("email"));
                    Assert.assertTrue((boolean)jsonObj.has("iname"));
                    Assert.assertTrue((boolean)jsonObj.has("o"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestUserInfoHS256Step1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS256);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS256Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    UserInfoRestWebServiceEmbeddedTest.this.clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    UserInfoRestWebServiceEmbeddedTest.this.clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestUserInfoHS256Step1"})
    public void requestUserInfoHS256Step2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, UserInfoRestWebServiceEmbeddedTest.this.clientId1, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, UserInfoRestWebServiceEmbeddedTest.this.clientSecret1);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS256Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    UserInfoRestWebServiceEmbeddedTest.this.accessToken5 = (String)params.get("access_token");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoHS256Step2"})
    public void requestUserInfoHS256Step3(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + UserInfoRestWebServiceEmbeddedTest.this.accessToken5));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(null);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS256Step3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    Jwt jwt = Jwt.parse((String)response.getContentAsString());
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("name"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("email"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("picture"));
                }
                catch (InvalidJwtException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestUserInfoHS384Step1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS384);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS384Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    UserInfoRestWebServiceEmbeddedTest.this.clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    UserInfoRestWebServiceEmbeddedTest.this.clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestUserInfoHS384Step1"})
    public void requestUserInfoHS384Step2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, UserInfoRestWebServiceEmbeddedTest.this.clientId2, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS384, UserInfoRestWebServiceEmbeddedTest.this.clientSecret2);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS384Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    UserInfoRestWebServiceEmbeddedTest.this.accessToken6 = (String)params.get("access_token");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoHS384Step2"})
    public void requestUserInfoHS384Step3(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + UserInfoRestWebServiceEmbeddedTest.this.accessToken6));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(null);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS384Step3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    Jwt jwt = Jwt.parse((String)response.getContentAsString());
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("name"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("email"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("picture"));
                }
                catch (InvalidJwtException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestUserInfoHS512Step1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS512);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS512Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    UserInfoRestWebServiceEmbeddedTest.this.clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    UserInfoRestWebServiceEmbeddedTest.this.clientSecret3 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestUserInfoHS512Step1"})
    public void requestUserInfoHS512Step2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, UserInfoRestWebServiceEmbeddedTest.this.clientId3, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS512, UserInfoRestWebServiceEmbeddedTest.this.clientSecret3);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS512Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    UserInfoRestWebServiceEmbeddedTest.this.accessToken7 = (String)params.get("access_token");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestUserInfoHS512Step2"})
    public void requestUserInfoHS512Step3(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + UserInfoRestWebServiceEmbeddedTest.this.accessToken7));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(null);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestUserInfoHS512Step3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    Jwt jwt = Jwt.parse((String)response.getContentAsString());
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("name"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("email"));
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("picture"));
                }
                catch (InvalidJwtException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }
}

