/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.ValidateTokenRequest;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.util.StringUtils;
import org.xdi.oxauth.ws.rs.ClientTestUtil;

public class UserAuthenticationFilterEmbeddedTest
extends BaseTest {
    private String clientId;
    private String clientSecret;
    private String clientId1;
    private String clientSecret1;
    private String clientId2;
    private String clientSecret2;
    private String clientId3;
    private String clientSecret3;
    private String clientId4;
    private String clientSecret4;
    String authorizationCode1;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void dynamicClientRegistration(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("dynamicClientRegistration", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    RegisterResponse registerResponse = RegisterResponse.valueOf((String)response.getContentAsString());
                    ClientTestUtil.assert_((RegisterResponse)registerResponse);
                    UserAuthenticationFilterEmbeddedTest.this.clientId = registerResponse.getClientId();
                    UserAuthenticationFilterEmbeddedTest.this.clientSecret = registerResponse.getClientSecret();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenCustomAuth1Step1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuth1Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    UserAuthenticationFilterEmbeddedTest.this.clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    UserAuthenticationFilterEmbeddedTest.this.clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "userInum", "userEmail"})
    @Test(dependsOnMethods={"requestAccessTokenCustomAuth1Step1"})
    public void requestAccessTokenCustomAuth1Step2(String tokenPath, final String userInum, final String userEmail) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
                tokenRequest.setScope("email read_stream manage_pages");
                tokenRequest.setAuthUsername(UserAuthenticationFilterEmbeddedTest.this.clientId1);
                tokenRequest.setAuthPassword(UserAuthenticationFilterEmbeddedTest.this.clientSecret1);
                tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
                tokenRequest.addCustomParameter("mail", userEmail);
                tokenRequest.addCustomParameter("inum", userInum);
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuth1Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertTrue((!response.getContentAsString().equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenCustomAuth2Step1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuth2Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    UserAuthenticationFilterEmbeddedTest.this.clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    UserAuthenticationFilterEmbeddedTest.this.clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "userId", "userSecret"})
    @Test(dependsOnMethods={"requestAccessTokenCustomAuth2Step1"})
    public void requestAccessTokenCustomAuth2Step2(String tokenPath, final String userId, final String userSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
                tokenRequest.setScope("email read_stream manage_pages");
                tokenRequest.setAuthUsername(UserAuthenticationFilterEmbeddedTest.this.clientId2);
                tokenRequest.setAuthPassword(UserAuthenticationFilterEmbeddedTest.this.clientSecret2);
                tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
                tokenRequest.addCustomParameter("uid", userId);
                tokenRequest.addCustomParameter("pwd", userSecret);
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuth2Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertTrue((!response.getContentAsString().equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenCustomAuth3Step1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuth3Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    UserAuthenticationFilterEmbeddedTest.this.clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    UserAuthenticationFilterEmbeddedTest.this.clientSecret3 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "userInum", "userEmail"})
    @Test(dependsOnMethods={"requestAccessTokenCustomAuth3Step1"})
    public void requestAccessTokenCustomAuth3Step2(String tokenPath, final String userInum, final String userEmail) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
                tokenRequest.setScope("email read_stream manage_pages");
                tokenRequest.setAuthUsername(UserAuthenticationFilterEmbeddedTest.this.clientId3);
                tokenRequest.setAuthPassword(UserAuthenticationFilterEmbeddedTest.this.clientSecret3);
                tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
                tokenRequest.addCustomParameter("mail", userEmail);
                tokenRequest.addCustomParameter("inum", userInum);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuth3Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertTrue((!response.getContentAsString().equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenCustomAuth4Step1(String registerPath, final String redirectUris, final String jwksUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setJwksUri(jwksUri);
                    registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuth4Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    UserAuthenticationFilterEmbeddedTest.this.clientId4 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    UserAuthenticationFilterEmbeddedTest.this.clientSecret4 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "userId", "userSecret"})
    @Test(dependsOnMethods={"requestAccessTokenCustomAuth4Step1"})
    public void requestAccessTokenCustomAuth4Step2(String tokenPath, final String userId, final String userSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
                tokenRequest.setScope("email read_stream manage_pages");
                tokenRequest.setAuthUsername(UserAuthenticationFilterEmbeddedTest.this.clientId4);
                tokenRequest.setAuthPassword(UserAuthenticationFilterEmbeddedTest.this.clientSecret4);
                tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
                tokenRequest.setAudience("https://localhost:8443/seam/resource/restv1/oxauth/token");
                tokenRequest.addCustomParameter("uid", userId);
                tokenRequest.addCustomParameter("pwd", userSecret);
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuth4Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertTrue((!response.getContentAsString().equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestAccessTokenCustomAuthStep1(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, UserAuthenticationFilterEmbeddedTest.this.clientId, scopes, redirectUri, null);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.addCustomParameter("uid", userId);
                authorizationRequest.addCustomParameter("pwd", userSecret);
                request.setParameters(authorizationRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuthStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                        Map params = QueryStringDecoder.decode((String)uri.getQuery());
                        Assert.assertNotNull(params.get("code"), (String)"The code is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                        UserAuthenticationFilterEmbeddedTest.this.authorizationCode1 = (String)params.get("code");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "validateTokenPath", "redirectUri"})
    @Test(dependsOnMethods={"requestAccessTokenCustomAuthStep1", "dynamicClientRegistration"})
    public void requestAccessTokenCustomAuthStep2(String tokenPath, final String validateTokenPath, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(UserAuthenticationFilterEmbeddedTest.this.authorizationCode1);
                tokenRequest.setRedirectUri(redirectUri);
                tokenRequest.setAuthUsername(UserAuthenticationFilterEmbeddedTest.this.clientId);
                tokenRequest.setAuthPassword(UserAuthenticationFilterEmbeddedTest.this.clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuthStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
                    String accessToken = jsonObj.getString("access_token");
                    String refreshToken = jsonObj.getString("refresh_token");
                    UserAuthenticationFilterEmbeddedTest.this.requestAccessTokenCustomAuthStep3(validateTokenPath, accessToken);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    public void requestAccessTokenCustomAuthStep3(String validateTokenPath, final String accessToken) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, validateTokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ValidateTokenRequest validateTokenRequest = new ValidateTokenRequest();
                validateTokenRequest.setAccessToken(accessToken);
                request.setQueryString(validateTokenRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomAuthStep3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("valid"), (String)"Unexpected result: valid not found");
                    Assert.assertTrue((boolean)jsonObj.getBoolean("valid"), (String)"Unexpected result: valid is false");
                    Assert.assertTrue((boolean)jsonObj.has("expires_in"), (String)"Unexpected result: expires_in not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }
}

