/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.crypto.Certificate;
import org.xdi.oxauth.model.crypto.Key;
import org.xdi.oxauth.model.crypto.signature.ECDSAKeyFactory;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAKeyFactory;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.ECDSASigner;
import org.xdi.oxauth.model.jws.RSASigner;

public class SignatureTest
extends BaseTest {
    @Test
    public void generateRS256Keys() throws Exception {
        this.showTitle("TEST: generateRS256Keys");
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS256, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        RSAPrivateKey privateKey = (RSAPrivateKey)key.getPrivateKey();
        RSAPublicKey publicKey = (RSAPublicKey)key.getPublicKey();
        Certificate certificate = key.getCertificate();
        System.out.println(key);
        String signingInput = "Hello World!";
        RSASigner rsaSigner1 = new RSASigner(SignatureAlgorithm.RS256, privateKey);
        String signature = rsaSigner1.generateSignature(signingInput);
        RSASigner rsaSigner2 = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner2.validateSignature(signingInput, signature));
        RSASigner rsaSigner3 = new RSASigner(SignatureAlgorithm.RS256, certificate);
        Assert.assertTrue((boolean)rsaSigner3.validateSignature(signingInput, signature));
    }

    @Test
    public void generateRS384Keys() throws Exception {
        this.showTitle("TEST: generateRS384Keys");
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS384, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        RSAPrivateKey privateKey = (RSAPrivateKey)key.getPrivateKey();
        RSAPublicKey publicKey = (RSAPublicKey)key.getPublicKey();
        Certificate certificate = key.getCertificate();
        System.out.println(key);
        String signingInput = "Hello World!";
        RSASigner rsaSigner1 = new RSASigner(SignatureAlgorithm.RS384, privateKey);
        String signature = rsaSigner1.generateSignature(signingInput);
        RSASigner rsaSigner2 = new RSASigner(SignatureAlgorithm.RS384, publicKey);
        Assert.assertTrue((boolean)rsaSigner2.validateSignature(signingInput, signature));
        RSASigner rsaSigner3 = new RSASigner(SignatureAlgorithm.RS384, certificate);
        Assert.assertTrue((boolean)rsaSigner3.validateSignature(signingInput, signature));
    }

    @Test
    public void generateRS512Keys() throws Exception {
        this.showTitle("TEST: generateRS512Keys");
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS512, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        RSAPrivateKey privateKey = (RSAPrivateKey)key.getPrivateKey();
        RSAPublicKey publicKey = (RSAPublicKey)key.getPublicKey();
        Certificate certificate = key.getCertificate();
        System.out.println(key);
        String signingInput = "Hello World!";
        RSASigner rsaSigner1 = new RSASigner(SignatureAlgorithm.RS512, privateKey);
        String signature = rsaSigner1.generateSignature(signingInput);
        RSASigner rsaSigner2 = new RSASigner(SignatureAlgorithm.RS512, publicKey);
        Assert.assertTrue((boolean)rsaSigner2.validateSignature(signingInput, signature));
        RSASigner rsaSigner3 = new RSASigner(SignatureAlgorithm.RS512, certificate);
        Assert.assertTrue((boolean)rsaSigner3.validateSignature(signingInput, signature));
    }

    @Test
    public void generateES256Keys() throws Exception {
        this.showTitle("TEST: generateES256Keys");
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES256, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        ECDSAPrivateKey privateKey = (ECDSAPrivateKey)key.getPrivateKey();
        ECDSAPublicKey publicKey = (ECDSAPublicKey)key.getPublicKey();
        Certificate certificate = key.getCertificate();
        System.out.println(key);
        String signingInput = "Hello World!";
        ECDSASigner ecdsaSigner1 = new ECDSASigner(SignatureAlgorithm.ES256, privateKey);
        String signature = ecdsaSigner1.generateSignature(signingInput);
        ECDSASigner ecdsaSigner2 = new ECDSASigner(SignatureAlgorithm.ES256, publicKey);
        Assert.assertTrue((boolean)ecdsaSigner2.validateSignature(signingInput, signature));
        ECDSASigner ecdsaSigner3 = new ECDSASigner(SignatureAlgorithm.ES256, certificate);
        Assert.assertTrue((boolean)ecdsaSigner3.validateSignature(signingInput, signature));
    }

    @Test
    public void generateES384Keys() throws Exception {
        this.showTitle("TEST: generateES384Keys");
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES384, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        ECDSAPrivateKey privateKey = (ECDSAPrivateKey)key.getPrivateKey();
        ECDSAPublicKey publicKey = (ECDSAPublicKey)key.getPublicKey();
        Certificate certificate = key.getCertificate();
        System.out.println(key);
        String signingInput = "Hello World!";
        ECDSASigner ecdsaSigner1 = new ECDSASigner(SignatureAlgorithm.ES384, privateKey);
        String signature = ecdsaSigner1.generateSignature(signingInput);
        ECDSASigner ecdsaSigner2 = new ECDSASigner(SignatureAlgorithm.ES384, publicKey);
        Assert.assertTrue((boolean)ecdsaSigner2.validateSignature(signingInput, signature));
        ECDSASigner ecdsaSigner3 = new ECDSASigner(SignatureAlgorithm.ES384, certificate);
        Assert.assertTrue((boolean)ecdsaSigner3.validateSignature(signingInput, signature));
    }

    @Test
    public void generateES512Keys() throws Exception {
        this.showTitle("TEST: generateES512Keys");
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES512, "CN=Test CA Certificate");
        ECDSAPrivateKey privateKey = (ECDSAPrivateKey)keyFactory.getPrivateKey();
        ECDSAPublicKey publicKey = (ECDSAPublicKey)keyFactory.getPublicKey();
        Certificate certificate = keyFactory.getCertificate();
        System.out.println("PRIVATE KEY");
        System.out.println(privateKey);
        System.out.println("PUBLIC KEY");
        System.out.println(publicKey);
        System.out.println("CERTIFICATE");
        System.out.println(certificate);
        String signingInput = "Hello World!";
        ECDSASigner ecdsaSigner1 = new ECDSASigner(SignatureAlgorithm.ES512, privateKey);
        String signature = ecdsaSigner1.generateSignature(signingInput);
        ECDSASigner ecdsaSigner2 = new ECDSASigner(SignatureAlgorithm.ES512, publicKey);
        Assert.assertTrue((boolean)ecdsaSigner2.validateSignature(signingInput, signature));
        ECDSASigner ecdsaSigner3 = new ECDSASigner(SignatureAlgorithm.ES512, certificate);
        Assert.assertTrue((boolean)ecdsaSigner3.validateSignature(signingInput, signature));
    }
}

