/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.util.StringUtils;

public class ResponseTypesRestrictionEmbeddedTest
extends BaseTest {
    private String clientId1;
    private String clientSecret1;
    private String registrationAccessToken1;
    private String registrationClientUri1;
    private String authorizationCode1;
    private String clientId2;
    private String clientSecret2;
    private String registrationAccessToken2;
    private String registrationClientUri2;
    private String authorizationCode2;
    private String clientId3;
    private String registrationAccessToken3;
    private String registrationClientUri3;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void omittedResponseTypesStep1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("omittedResponseTypesStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    ResponseTypesRestrictionEmbeddedTest.this.clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    ResponseTypesRestrictionEmbeddedTest.this.clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                    ResponseTypesRestrictionEmbeddedTest.this.registrationAccessToken1 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
                    ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri1 = jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"omittedResponseTypesStep1"})
    public void omittedResponseTypesStep2(String registerPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + ResponseTypesRestrictionEmbeddedTest.this.registrationAccessToken1));
                request.setContentType("application/json");
                request.setQueryString(ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri1.substring(ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri1.indexOf("?") + 1));
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("omittedResponseTypesStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString()));
                    Assert.assertNotNull((Object)jsonObj.optJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()));
                    Assert.assertEquals((String)jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).getString(0), (String)ResponseType.CODE.toString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
                    Assert.assertTrue((boolean)jsonObj.has("scopes"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"omittedResponseTypesStep2"})
    public void omittedResponseTypesStep3a(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String state = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, ResponseTypesRestrictionEmbeddedTest.this.clientId1, scopes, redirectUri, null);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("omittedResponseTypesStep3a", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                        Map params = QueryStringDecoder.decode((String)uri.getQuery());
                        Assert.assertNotNull(params.get("code"), (String)"The code is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertFalse((boolean)params.containsKey("id_token"));
                        Assert.assertFalse((boolean)params.containsKey("access_token"));
                        ResponseTypesRestrictionEmbeddedTest.this.authorizationCode1 = (String)params.get("code");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "redirectUri"})
    @Test(dependsOnMethods={"omittedResponseTypesStep3a"})
    public void omittedResponseTypesStep3b(String tokenPath, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(ResponseTypesRestrictionEmbeddedTest.this.authorizationCode1);
                tokenRequest.setRedirectUri(redirectUri);
                tokenRequest.setAuthUsername(ResponseTypesRestrictionEmbeddedTest.this.clientId1);
                tokenRequest.setAuthPassword(ResponseTypesRestrictionEmbeddedTest.this.clientSecret1);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("omittedResponseTypesStep3b", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("id_token"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @DataProvider(name="omittedResponseTypesStep4DataProvider")
    public Object[][] omittedResponseTypesStep4DataProvider(ITestContext context) {
        String authorizePath = context.getCurrentXmlTest().getParameter("authorizePath");
        String userId = context.getCurrentXmlTest().getParameter("userId");
        String userSecret = context.getCurrentXmlTest().getParameter("userSecret");
        String redirectUri = context.getCurrentXmlTest().getParameter("redirectUri");
        return new Object[][]{{authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.ID_TOKEN)}};
    }

    @Test(dependsOnMethods={"omittedResponseTypesStep3b"}, dataProvider="omittedResponseTypesStep4DataProvider")
    public void omittedResponseTypesStep4(String authorizePath, final String userId, final String userSecret, final String redirectUri, final List<ResponseType> responseTypes) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, ResponseTypesRestrictionEmbeddedTest.this.clientId1, scopes, redirectUri, nonce);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("omittedResponseTypesStep4", response);
                if (response.getStatus() == 400) {
                    Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                    try {
                        JSONObject jsonObj = new JSONObject(response.getContentAsString());
                        Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                        Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                    }
                } else {
                    Assert.fail((String)("Unexpected response code: " + response.getStatus()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void responseTypesCodeIdTokenStep1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesCodeIdTokenStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    ResponseTypesRestrictionEmbeddedTest.this.clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    ResponseTypesRestrictionEmbeddedTest.this.clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                    ResponseTypesRestrictionEmbeddedTest.this.registrationAccessToken2 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
                    ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri2 = jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"responseTypesCodeIdTokenStep1"})
    public void responseTypesCodeIdTokenStep2(String registerPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + ResponseTypesRestrictionEmbeddedTest.this.registrationAccessToken2));
                request.setContentType("application/json");
                request.setQueryString(ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri2.substring(ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri2.indexOf("?") + 1));
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesCodeIdTokenStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString()));
                    Assert.assertNotNull((Object)jsonObj.optJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()));
                    HashSet<String> responseTypes = new HashSet<String>();
                    for (int i = 0; i < jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).length(); ++i) {
                        responseTypes.add(jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).getString(i));
                    }
                    Assert.assertTrue((boolean)responseTypes.containsAll(Arrays.asList(ResponseType.CODE.toString(), ResponseType.ID_TOKEN.toString())));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
                    Assert.assertTrue((boolean)jsonObj.has("scopes"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"responseTypesCodeIdTokenStep2"})
    public void responseTypesCodeIdTokenStep3a(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String state = UUID.randomUUID().toString();
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, ResponseTypesRestrictionEmbeddedTest.this.clientId2, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesCodeIdTokenStep3a", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"The fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertTrue((boolean)params.containsKey("code"));
                        Assert.assertTrue((boolean)params.containsKey("scope"));
                        Assert.assertTrue((boolean)params.containsKey("state"));
                        Assert.assertTrue((boolean)params.containsKey("id_token"));
                        Assert.assertFalse((boolean)params.containsKey("access_token"));
                        ResponseTypesRestrictionEmbeddedTest.this.authorizationCode2 = (String)params.get("code");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "redirectUri"})
    @Test(dependsOnMethods={"responseTypesCodeIdTokenStep3a"})
    public void responseTypesCodeIdTokenStep3b(String tokenPath, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(ResponseTypesRestrictionEmbeddedTest.this.authorizationCode2);
                tokenRequest.setRedirectUri(redirectUri);
                tokenRequest.setAuthUsername(ResponseTypesRestrictionEmbeddedTest.this.clientId2);
                tokenRequest.setAuthPassword(ResponseTypesRestrictionEmbeddedTest.this.clientSecret2);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesCodeIdTokenStep3b", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("id_token"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @DataProvider(name="responseTypesCodeIdTokenStep4DataProvider")
    public Object[][] responseTypesCodeIdTokenStep4DataProvider(ITestContext context) {
        String authorizePath = context.getCurrentXmlTest().getParameter("authorizePath");
        String userId = context.getCurrentXmlTest().getParameter("userId");
        String userSecret = context.getCurrentXmlTest().getParameter("userSecret");
        String redirectUri = context.getCurrentXmlTest().getParameter("redirectUri");
        return new Object[][]{{authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.ID_TOKEN)}};
    }

    @Test(dependsOnMethods={"omittedResponseTypesStep3b"}, dataProvider="responseTypesCodeIdTokenStep4DataProvider")
    public void responseTypesCodeIdTokenStep4(String authorizePath, final String userId, final String userSecret, final String redirectUri, final List<ResponseType> responseTypes) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, ResponseTypesRestrictionEmbeddedTest.this.clientId1, scopes, redirectUri, nonce);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesCodeIdTokenStep4", response);
                if (response.getStatus() == 400) {
                    Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                    try {
                        JSONObject jsonObj = new JSONObject(response.getContentAsString());
                        Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                        Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                    }
                } else {
                    Assert.fail((String)("Unexpected response code: " + response.getStatus()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void responseTypesTokenIdTokenStep1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesTokenIdTokenStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    ResponseTypesRestrictionEmbeddedTest.this.clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    ResponseTypesRestrictionEmbeddedTest.this.registrationAccessToken3 = jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
                    ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri3 = jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"responseTypesTokenIdTokenStep1"})
    public void responseTypesTokenIdTokenStep2(String registerPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + ResponseTypesRestrictionEmbeddedTest.this.registrationAccessToken3));
                request.setContentType("application/json");
                request.setQueryString(ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri3.substring(ResponseTypesRestrictionEmbeddedTest.this.registrationClientUri3.indexOf("?") + 1));
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesTokenIdTokenStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString()));
                    Assert.assertNotNull((Object)jsonObj.optJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()));
                    HashSet<String> responseTypes = new HashSet<String>();
                    for (int i = 0; i < jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).length(); ++i) {
                        responseTypes.add(jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString()).getString(i));
                    }
                    Assert.assertTrue((boolean)responseTypes.containsAll(Arrays.asList(ResponseType.TOKEN.toString(), ResponseType.ID_TOKEN.toString())));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
                    Assert.assertTrue((boolean)jsonObj.has("scopes"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test
    public void responseTypesTokenIdTokenStep3(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, ResponseTypesRestrictionEmbeddedTest.this.clientId3, scopes, redirectUri, nonce);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesTokenIdTokenStep3", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                        Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                        Assert.assertNotNull(params.get("id_token"), (String)"The id token is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @DataProvider(name="responseTypesTokenIdTokenStep4DataProvider")
    public Object[][] responseTypesTokenIdTokenStep4DataProvider(ITestContext context) {
        String authorizePath = context.getCurrentXmlTest().getParameter("authorizePath");
        String userId = context.getCurrentXmlTest().getParameter("userId");
        String userSecret = context.getCurrentXmlTest().getParameter("userSecret");
        String redirectUri = context.getCurrentXmlTest().getParameter("redirectUri");
        return new Object[][]{{authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN)}, {authorizePath, userId, userSecret, redirectUri, Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN)}};
    }

    @Test(dependsOnMethods={"responseTypesTokenIdTokenStep3"}, dataProvider="responseTypesTokenIdTokenStep4DataProvider")
    public void responseTypesTokenIdTokenStep4(String authorizePath, final String userId, final String userSecret, final String redirectUri, final List<ResponseType> responseTypes) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, ResponseTypesRestrictionEmbeddedTest.this.clientId3, scopes, redirectUri, nonce);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("responseTypesTokenIdTokenStep4", response);
                if (response.getStatus() == 400) {
                    Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                    try {
                        JSONObject jsonObj = new JSONObject(response.getContentAsString());
                        Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                        Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                    }
                } else {
                    Assert.fail((String)("Unexpected response code: " + response.getStatus()));
                }
            }
        }.run();
    }
}

