/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.StringUtils;
import org.xdi.oxauth.ws.rs.ClientTestUtil;

public class OpenIDRequestObjectEmbeddedTest
extends BaseTest {
    private String clientId;
    private String clientSecret;
    private String idToken1;
    private String accessToken1;
    private String accessToken2;
    private String clientId1;
    private String clientSecret1;
    private String clientId2;
    private String clientSecret2;
    private String clientId3;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void dynamicClientRegistration(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("dynamicClientRegistration", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    RegisterResponse registerResponse = RegisterResponse.valueOf((String)response.getContentAsString());
                    ClientTestUtil.assert_((RegisterResponse)registerResponse);
                    OpenIDRequestObjectEmbeddedTest.this.clientId = registerResponse.getClientId();
                    OpenIDRequestObjectEmbeddedTest.this.clientSecret = registerResponse.getClientSecret();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestParameterMethod1Step1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.HS256);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethod1Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectEmbeddedTest.this.clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    OpenIDRequestObjectEmbeddedTest.this.clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestParameterMethod1Step1"})
    public void requestParameterMethod1Step2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId1, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, OpenIDRequestObjectEmbeddedTest.this.clientSecret1);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethod1Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("id_token"), (String)"The idToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    OpenIDRequestObjectEmbeddedTest.this.idToken1 = (String)params.get("id_token");
                    OpenIDRequestObjectEmbeddedTest.this.accessToken1 = (String)params.get("access_token");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestParameterMethod1Step2"})
    public void requestParameterMethodUserInfo(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(OpenIDRequestObjectEmbeddedTest.this.accessToken1);
                userInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodUserInfo", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("sub"));
                    Assert.assertTrue((boolean)jsonObj.has("name"));
                    Assert.assertTrue((boolean)jsonObj.has("given_name"));
                    Assert.assertTrue((boolean)jsonObj.has("family_name"));
                    Assert.assertTrue((boolean)jsonObj.has("email"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestParameterMethod2Step1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.HS256);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethod2Step1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectEmbeddedTest.this.clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    OpenIDRequestObjectEmbeddedTest.this.clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestParameterMethod2Step1"})
    public void requestParameterMethod2Step2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId2, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, OpenIDRequestObjectEmbeddedTest.this.clientSecret2);
                jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createEssential((boolean)true)));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethod2Step2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    OpenIDRequestObjectEmbeddedTest.this.accessToken2 = (String)params.get("access_token");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"requestParameterMethod2Step2"})
    public void requestParameterMethod2Step3(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(OpenIDRequestObjectEmbeddedTest.this.accessToken2);
                userInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethod2Step3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("sub"));
                    Assert.assertTrue((boolean)jsonObj.has("name"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestParameterMethodFail1(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.setRequest("INVALID_OPENID_REQUEST_OBJECT");
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodFail1 (Invalid OpenID Request Object)", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("error"), (String)"The error value is null");
                        Assert.assertNotNull(params.get("error_description"), (String)"The errorDescription value is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestParameterMethodFail2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, OpenIDRequestObjectEmbeddedTest.this.clientSecret);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt + "INVALID_SIGNATURE");
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodFail2 (Invalid OpenID Request Object, due to invalid signature)", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("error"), (String)"The error value is null");
                        Assert.assertNotNull(params.get("error_description"), (String)"The errorDescription value is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestParameterMethodFail3(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, OpenIDRequestObjectEmbeddedTest.this.clientSecret);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
                jwtAuthorizationRequest.setClientId("INVALID_CLIENT_ID");
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodFail3 (Invalid OpenID Request Object)", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("error"), (String)"The error value is null");
                        Assert.assertNotNull(params.get("error_description"), (String)"The errorDescription value is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestParameterMethodFail4(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, OpenIDRequestObjectEmbeddedTest.this.clientSecret);
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("sub", ClaimValue.createSingleValue((String)"INVALID_USER_ID")));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodFail4", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("error"), (String)"The error value is null");
                        Assert.assertNotNull(params.get("error_description"), (String)"The errorDescription value is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestParameterMethodWithMaxAgeRestriction(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, OpenIDRequestObjectEmbeddedTest.this.clientSecret);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodWithMaxAgeRestriction", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("id_token"), (String)"The idToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "requestFileBasePath", "requestFileBaseUrl"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestFileMethod(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String requestFileBasePath, final String requestFileBaseUrl) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                try {
                    JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, OpenIDRequestObjectEmbeddedTest.this.clientSecret);
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                    jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                    jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                    jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
                    String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                    String hash = JwtUtil.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)authJwt));
                    String fileName = UUID.randomUUID().toString() + ".txt";
                    String filePath = requestFileBasePath + File.separator + fileName;
                    String fileUrl = requestFileBaseUrl + "/" + fileName + "#" + hash;
                    FileWriter fw = new FileWriter(filePath);
                    BufferedWriter bw = new BufferedWriter(fw);
                    bw.write(authJwt);
                    bw.close();
                    fw.close();
                    authorizationRequest.setRequestUri(fileUrl);
                    System.out.println("Request JWT: " + authJwt);
                    System.out.println("Request File Path: " + filePath);
                    System.out.println("Request File URL: " + fileUrl);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                catch (NoSuchProviderException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestFileMethod", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("id_token"), (String)"The idToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestFileMethodFail1(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                authorizationRequest.setRequest("FAKE_REQUEST");
                authorizationRequest.setRequestUri("FAKE_REQUEST_URI");
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestFileMethodFail1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("error"), (String)"The error value is null");
                        Assert.assertNotNull(params.get("error_description"), (String)"The errorDescription value is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "requestFileBaseUrl"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestFileMethodFail2(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String requestFileBaseUrl) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                authorizationRequest.setRequestUri(requestFileBaseUrl + "/FAKE_REQUEST_URI");
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestFileMethodFail2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("error"), (String)"The error value is null");
                        Assert.assertNotNull(params.get("error_description"), (String)"The errorDescription value is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri", "requestFileBasePath", "requestFileBaseUrl"})
    @Test(dependsOnMethods={"dynamicClientRegistration"})
    public void requestFileMethodFail3(String authorizePath, final String userId, final String userSecret, final String redirectUri, final String requestFileBasePath, final String requestFileBaseUrl) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                try {
                    JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, OpenIDRequestObjectEmbeddedTest.this.clientSecret);
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                    jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                    jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                    jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                    jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
                    String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                    String hash = "INVALID_HASH";
                    String fileName = UUID.randomUUID().toString() + ".txt";
                    String filePath = requestFileBasePath + File.separator + fileName;
                    String fileUrl = requestFileBaseUrl + "/" + fileName + "#" + hash;
                    FileWriter fw = new FileWriter(filePath);
                    BufferedWriter bw = new BufferedWriter(fw);
                    bw.write(authJwt);
                    bw.close();
                    fw.close();
                    authorizationRequest.setRequestUri(fileUrl);
                    System.out.println("Request JWT: " + authJwt);
                    System.out.println("Request File Path: " + filePath);
                    System.out.println("Request File URL: " + fileUrl);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestFileMethodFail3", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("error"), (String)"The error value is null");
                        Assert.assertNotNull(params.get("error_description"), (String)"The errorDescription value is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertNotNull(params.get("state"), (String)state);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestParameterMethodAlgNoneStep1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.NONE);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodAlgNoneStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    OpenIDRequestObjectEmbeddedTest.this.clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestParameterMethodAlgNoneStep1"})
    public void requestParameterMethodAlgNoneStep2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN);
                List<String> scopes = Arrays.asList("openid");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, OpenIDRequestObjectEmbeddedTest.this.clientId3, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest);
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
                jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
                jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
                String authJwt = jwtAuthorizationRequest.getEncodedJwt();
                authorizationRequest.setRequest(authJwt);
                System.out.println("Request JWT: " + authJwt);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestParameterMethodAlgNoneStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("access_token"), (String)"The accessToken is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }
}

