/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.util.StringUtils;

public class ClientAuthenticationFilterEmbeddedTest
extends BaseTest {
    private String customAttrValue1;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestClientRegistrationWithCustomAttributes(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.TOKEN, ResponseType.ID_TOKEN);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setResponseTypes(responseTypes);
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    ClientAuthenticationFilterEmbeddedTest.this.customAttrValue1 = UUID.randomUUID().toString();
                    registerRequest.addCustomAttribute("myCustomAttr1", ClientAuthenticationFilterEmbeddedTest.this.customAttrValue1);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientRegistrationWithCustomAttributes", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestClientRegistrationWithCustomAttributes"})
    public void requestAccessTokenCustomClientAuth1(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        final String nonce = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, ClientAuthenticationFilterEmbeddedTest.this.customAttrValue1, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomClientAuth1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getFragment(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getFragment());
                    Assert.assertNotNull(params.get("code"), (String)"The code is null");
                    Assert.assertNotNull(params.get("id_token"), (String)"The id token is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                    Assert.assertEquals((String)((String)params.get("state")), (String)state);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestClientRegistrationWithCustomAttributes"})
    public void requestAccessTokenCustomClientAuth2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        final String state = UUID.randomUUID().toString();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
                List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, ClientAuthenticationFilterEmbeddedTest.this.customAttrValue1, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomClientAuth2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                        Map params = QueryStringDecoder.decode((String)uri.getFragment());
                        Assert.assertNotNull(params.get("access_token"), (String)"The access_token is null");
                        Assert.assertNotNull(params.get("id_token"), (String)"The id_token is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                        Assert.assertNotNull(params.get("expires_in"), (String)"The expires_in value is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                        Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                        Assert.assertEquals((String)((String)params.get("state")), (String)state);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "userId", "userSecret"})
    @Test(dependsOnMethods={"requestClientRegistrationWithCustomAttributes"})
    public void requestAccessTokenCustomClientAuth3(String tokenPath, final String userId, final String userSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
                tokenRequest.setUsername(userId);
                tokenRequest.setPassword(userSecret);
                tokenRequest.setScope("openid profile email");
                tokenRequest.setAuthUsername(ClientAuthenticationFilterEmbeddedTest.this.customAttrValue1);
                tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAccessTokenCustomClientAuth3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertTrue((!response.getContentAsString().equals(null) ? 1 : 0) != 0, (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }
}

