/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJacksonProvider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.jboss.seam.resteasy.SeamResteasyProviderFactory;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.uma.ResourceSet;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.TUma;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

public class DebugContentEncodingTest
extends BaseTest {
    public static final ObjectMapper MAPPER = ServerUtil.createJsonMapper();
    private Token m_pat;
    private String m_umaRegisterResourcePath;

    @BeforeSuite
    public void startSeam() throws Exception {
        super.startSeam();
        ResteasyProviderFactory seamInstance = SeamResteasyProviderFactory.peekInstance();
        if (seamInstance != null) {
            System.out.println("SeamResteasyProviderFactory : got resteasy factory");
            MessageBodyReader reader = seamInstance.getMessageBodyReader(ResourceSet.class, ResourceSet.class, new Annotation[0], MediaType.APPLICATION_JSON_TYPE);
            if (reader instanceof ResteasyJacksonProvider) {
                ResteasyJacksonProvider p = (ResteasyJacksonProvider)reader;
                System.out.println("SeamResteasyProviderFactory : set mapper reader provider");
                p.setMapper(MAPPER);
            } else {
                System.out.println("Unable to find reader jackson provider. Reader: " + reader);
            }
            MessageBodyWriter writer = seamInstance.getMessageBodyWriter(ResourceSet.class, ResourceSet.class, new Annotation[0], MediaType.APPLICATION_JSON_TYPE);
            if (writer instanceof ResteasyJacksonProvider) {
                ResteasyJacksonProvider p = (ResteasyJacksonProvider)reader;
                System.out.println("SeamResteasyProviderFactory : set mapper writer provider");
                p.setMapper(MAPPER);
            } else {
                System.out.println("Unable to find writer jackson provider. Writer: " + writer);
            }
        }
    }

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri", "umaRegisterResourcePath"})
    public void init(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri, String umaRegisterResourcePath) {
        this.m_pat = TUma.requestPat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        this.m_umaRegisterResourcePath = umaRegisterResourcePath;
    }

    @Test(dependsOnMethods={"init"})
    public void t1() throws Exception {
        ResourceSet set = UmaTestUtil.createResourceSet();
        String json = ServerUtil.createJsonMapper().writeValueAsString((Object)set);
        this.run(json);
    }

    public void run(final String p_json) {
        try {
            String rsid = String.valueOf(System.currentTimeMillis());
            String path = this.m_umaRegisterResourcePath + "/" + rsid;
            System.out.println("Path: " + path);
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.PUT, path){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    System.out.println("PAT: " + DebugContentEncodingTest.this.m_pat.getAccessToken());
                    request.addHeader("Accept", (Object)"application/json");
                    request.addHeader("Authorization", (Object)("Bearer " + DebugContentEncodingTest.this.m_pat.getAccessToken()));
                    try {
                        System.out.println("Json: " + p_json);
                        request.setContent(Util.getBytes((String)p_json));
                        request.setContentType("application/json");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("UMA : CheckContentEncodingTest.run() : ", response);
                    if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                        System.out.println("Success.");
                    } else {
                        System.out.println("ERROR: Unexpected response code.");
                    }
                    try {
                        ResourceSetStatus status = (ResourceSetStatus)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), ResourceSetStatus.class);
                        System.out.println("Status: " + status);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

