/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseComponentTest;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.SessionIdState;
import org.xdi.oxauth.service.SessionIdService;

public class SessionIdServiceTest
extends BaseComponentTest {
    private SessionIdService m_service;

    @Override
    public void beforeClass() {
        this.m_service = SessionIdService.instance();
    }

    @Override
    public void afterClass() {
    }

    private SessionId generateSession() {
        return this.m_service.generateSessionId("dummyDn", new Date(), SessionIdState.UNAUTHENTICATED, new HashMap(), true);
    }

    @Test
    public void checkOutdatedUnauthenticatedSessionIdentification() {
        Calendar c = Calendar.getInstance();
        c.add(10, -1);
        SessionId m_sessionId = this.generateSession();
        m_sessionId.setLastUsedAt(c.getTime());
        this.m_service.updateSessionId(m_sessionId, false);
        List outdatedSessions = this.m_service.getUnauthenticatedIdsOlderThan(60);
        Assert.assertTrue((boolean)outdatedSessions.contains(m_sessionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void statePersistence() {
        SessionId newId = null;
        try {
            newId = this.m_service.generateAuthenticatedSessionId("dummyDn1");
            Assert.assertEquals((Object)newId.getState(), (Object)SessionIdState.AUTHENTICATED);
            HashMap<String, String> sessionAttributes = new HashMap<String, String>();
            sessionAttributes.put("k1", "v1");
            newId.setSessionAttributes(sessionAttributes);
            this.m_service.updateSessionId(newId);
            SessionId fresh = this.m_service.getSessionByDN(newId.getDn());
            Assert.assertEquals((Object)fresh.getState(), (Object)SessionIdState.AUTHENTICATED);
            Assert.assertTrue((boolean)fresh.getSessionAttributes().containsKey("k1"));
            Assert.assertTrue((boolean)fresh.getSessionAttributes().containsValue("v1"));
        }
        finally {
            if (newId != null) {
                this.getLdapManager().remove((Object)newId);
            }
        }
    }

    @Test
    public void testUpdateLastUsedDate() {
        SessionId m_sessionId = this.generateSession();
        SessionId fromLdap1 = this.m_service.getSessionByDN(m_sessionId.getDn());
        Date createdDate = m_sessionId.getLastUsedAt();
        System.out.println("Created date = " + createdDate);
        Assert.assertEquals((Object)createdDate, (Object)fromLdap1.getLastUsedAt());
        SessionIdServiceTest.sleepSeconds(1);
        this.m_service.updateSessionId(m_sessionId);
        SessionId fromLdap2 = this.m_service.getSessionByDN(m_sessionId.getDn());
        System.out.println("Updated date = " + fromLdap2.getLastUsedAt());
        Assert.assertTrue((boolean)createdDate.before(fromLdap2.getLastUsedAt()));
    }

    @Test
    public void testUpdateAttributes() {
        SessionId m_sessionId = this.generateSession();
        String clientId = "testClientId";
        SessionId fromLdap1 = this.m_service.getSessionByDN(m_sessionId.getDn());
        Date createdDate = m_sessionId.getLastUsedAt();
        Assert.assertEquals((Object)createdDate, (Object)fromLdap1.getLastUsedAt());
        Assert.assertFalse((boolean)fromLdap1.isPermissionGrantedForClient("testClientId"));
        SessionIdServiceTest.sleepSeconds(1);
        m_sessionId.setAuthenticationTime(new Date());
        m_sessionId.addPermission("testClientId", Boolean.valueOf(true));
        this.m_service.updateSessionId(m_sessionId);
        SessionId fromLdap2 = this.m_service.getSessionByDN(m_sessionId.getDn());
        Assert.assertTrue((boolean)createdDate.before(fromLdap2.getLastUsedAt()));
        Assert.assertNotNull((Object)fromLdap2.getAuthenticationTime());
        Assert.assertTrue((boolean)fromLdap2.isPermissionGrantedForClient("testClientId"));
    }

    @Test
    public void testOldSessionsIdentification() {
        SessionId m_sessionId = this.generateSession();
        SessionIdServiceTest.sleepSeconds(2);
        Assert.assertTrue((boolean)this.m_service.getIdsOlderThan(1).contains(m_sessionId));
    }
}

