/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseComponentTestAdapter;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.signature.RSAKeyFactory;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtHeader;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.jwt.PureJwt;
import org.xdi.oxauth.model.util.JwtUtil;

public class FederationSigningTest
extends BaseComponentTestAdapter {
    private static final String TEST_METADATA = "{\"federation_id\"  : \"@!2222!0008!FF8F!7434\",\n \"display_name\" : \"Federation example name\",\n \"OPs\" : [\n          {\n            \"display_name\" : \"Example OP\",\n            \"op_id\" : \"example.com\",\n            \"domain\" : \"example.com\"\n          }          \n         ],\n \"RPs\" : [\n          {\n            \"display_name\" : \"oxGraph client\",\n            \"redirect_uri\" : \"example.com/oxGraph\"\n          }\n         ]        \n}";

    @Test
    public void test() throws InvalidJwtException, JSONException, SignatureException, IOException, IllegalBlockSizeException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, BadPaddingException {
        String keyId = FederationSigningTest.testKeyId();
        SignatureAlgorithm algorithm = SignatureAlgorithm.fromName((String)ConfigurationFactory.instance().getConfiguration().getFederationSigningAlg());
        JSONWebKey JSONWebKey2 = ConfigurationFactory.instance().getWebKeys().getKey(keyId);
        RSAKeyFactory factory = RSAKeyFactory.valueOf((JSONWebKey)JSONWebKey2);
        JSONObject jsonHeader = JwtHeader.instance().setType(JwtType.JWS).setAlgorithm(algorithm).setKeyId(keyId).toJsonObject();
        JSONObject jsonPayload = new JSONObject(TEST_METADATA);
        String signedJwt = JwtUtil.encodeJwt((JSONObject)jsonHeader, (JSONObject)jsonPayload, (SignatureAlgorithm)algorithm, (RSAPrivateKey)factory.getPrivateKey());
        PureJwt jwt = PureJwt.parse((String)signedJwt);
        RSASigner rsaSigner = new RSASigner(algorithm, factory.getPublicKey());
        Assert.assertTrue((boolean)rsaSigner.validateSignature(jwt.getSigningInput(), jwt.getEncodedSignature()));
        JwtHeader header = Jwt.parse((String)signedJwt).getHeader();
        Assert.assertTrue((boolean)header.getClaim("kid").equals(keyId));
    }

    public static String testKeyId() {
        String keyId = ConfigurationFactory.instance().getConfiguration().getFederationSigningKid();
        if (ConfigurationFactory.instance().getWebKeys().getKey(keyId) != null) {
            return keyId;
        }
        keyId = "6898cff9-4f92-4b58-b37c-2a2b6779b0b3";
        if (ConfigurationFactory.instance().getWebKeys().getKey(keyId) != null) {
            return keyId;
        }
        if (!ConfigurationFactory.instance().getWebKeys().getKeys().isEmpty()) {
            return ((JSONWebKey)ConfigurationFactory.instance().getWebKeys().getKeys().get(0)).getKeyId();
        }
        throw new RuntimeException("Failed to identify key id for signing");
    }
}

