/*
 * oxAuth is available under the MIT License (2008). See http://opensource.org/licenses/MIT for full text.
 *
 * Copyright (c) 2014, Gluu
 */

package org.xdi.oxauth.service;

import java.util.Properties;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.security.PropertiesDecrypter;
import org.xdi.util.security.StringEncrypter;
import org.xdi.util.security.StringEncrypter.EncryptionException;

/**
 * Allows to decrypt passwords
 *
 * @author Yuriy Movchan Date: 09/23/2014
 */
@Scope(ScopeType.STATELESS)
@Name("encryptionService")
@AutoCreate
public class EncryptionService {

    @Logger
    private Log log;

    @In
    private StringEncrypter stringEncrypter;

    public String decrypt(String encryptedString) throws EncryptionException {
        return stringEncrypter.decrypt(encryptedString);
    }

	public String encrypt(String unencryptedString) throws EncryptionException {
        return stringEncrypter.encrypt(unencryptedString);
	}

	public Properties decryptProperties(Properties connectionProperties) {
		return PropertiesDecrypter.decryptProperties(stringEncrypter, connectionProperties);
	}

    public static EncryptionService instance() {
        return ServerUtil.instance(EncryptionService.class);
    }

}