/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.fido.u2f;

import com.wordnik.swagger.annotations.Api;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.fido.u2f.RegisterRequestMessageLdap;
import org.xdi.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterRequestMessage;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterStatus;
import org.xdi.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RegistrationService;
import org.xdi.oxauth.util.ServerUtil;

@Path(value="/fido/u2f/registration")
@Api(value="/fido/u2f/registration", description="The endpoint at which the U2F device start registration process.")
@Name(value="u2fRegistrationRestWebService")
public class U2fRegistrationWS {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RegistrationService u2fRegistrationService;
    @In
    private DeviceRegistrationService deviceRegistrationService;

    @GET
    @Produces(value={"application/json"})
    public Response startRegistration(@QueryParam(value="username") String userName, @QueryParam(value="application") String appId) {
        try {
            RegisterRequestMessage registerRequestMessage = this.u2fRegistrationService.builRegisterRequestMessage(appId, userName);
            this.u2fRegistrationService.storeRegisterRequestMessage(registerRequestMessage);
            String entity = ServerUtil.asJson(registerRequestMessage);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response finishRegistration(@FormParam(value="username") String userName, @FormParam(value="tokenResponse") String registerResponseString) {
        try {
            RegisterResponse registerResponse = (RegisterResponse)ServerUtil.jsonMapperWithWrapRoot().readValue(registerResponseString, RegisterResponse.class);
            String requestId = registerResponse.getRequestId();
            RegisterRequestMessageLdap registerRequestMessageLdap = this.u2fRegistrationService.getRegisterRequestMessageByRequestId(requestId);
            if (registerRequestMessageLdap == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SESSION_EXPIRED)).build());
            }
            this.u2fRegistrationService.removeRegisterRequestMessage(registerRequestMessageLdap);
            RegisterRequestMessage registerRequestMessage = registerRequestMessageLdap.getRegisterRequestMessage();
            this.u2fRegistrationService.finishRegistration(registerRequestMessage, registerResponse, userName);
            RegisterStatus registerStatus = new RegisterStatus("success", requestId);
            String entity = ServerUtil.asJson(registerStatus);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            if (ex instanceof BadInputException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.INVALID_REQUEST)).build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }
}

