/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.net.MalformedURLException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class RedirectUtil {
    private static final Log LOG = Logging.getLog(RedirectUtil.class);
    static String JSON_REDIRECT_PROPNAME = "redirect";
    static String NO_REDIRECT_HEADER = "X-Gluu-NoRedirect";
    static int HTTP_REDIRECT = 302;

    public static Response.ResponseBuilder getRedirectResponseBuilder(String location, HttpServletRequest httpRequest) {
        Response.ResponseBuilder builder;
        URI redirectURI = URI.create(location);
        if (httpRequest == null || httpRequest.getHeader(NO_REDIRECT_HEADER) == null) {
            builder = Response.status((int)HTTP_REDIRECT);
            builder.location(redirectURI);
        } else {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(JSON_REDIRECT_PROPNAME, (Object)redirectURI.toURL());
                String jsonResp = jsonObject.toString();
                jsonResp = jsonResp.replace("\\/", "/");
                builder = Response.ok((Object)new GenericEntity((Object)jsonResp, String.class), (MediaType)MediaType.APPLICATION_JSON_TYPE);
            }
            catch (MalformedURLException e) {
                builder = Response.serverError();
                LOG.debug((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (JSONException e) {
                builder = Response.serverError();
                LOG.debug((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return builder;
    }
}

