/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import java.util.UUID;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.crypto.Key;
import org.xdi.oxauth.model.crypto.signature.ECDSAKeyFactory;
import org.xdi.oxauth.model.crypto.signature.RSAKeyFactory;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.util.SecurityProviderUtility;

public class KeyGenerator {
    private static final Logger log;

    public static void main(String[] args) throws Exception {
        SecurityProviderUtility.installBCProvider((boolean)true);
        JSONArray keys = new JSONArray();
        keys.put((Object)KeyGenerator.generateRS256Keys(null));
        keys.put((Object)KeyGenerator.generateRS384Keys(null));
        keys.put((Object)KeyGenerator.generateRS512Keys(null));
        keys.put((Object)KeyGenerator.generateES256Keys(null));
        keys.put((Object)KeyGenerator.generateES384Keys(null));
        keys.put((Object)KeyGenerator.generateES512Keys(null));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("keys", (Object)keys);
        System.out.println(jsonObject.toString(4).replace("\\/", "/"));
    }

    public static JSONObject generateRS256Keys(Long expirationTime) throws Exception {
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS256, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("RSA");
        key.setUse("SIGNATURE");
        key.setAlgorithm(SignatureAlgorithm.RS256.getName());
        key.setKeyId(UUID.randomUUID().toString());
        key.setExpirationTime(expirationTime);
        key.setCurve(JSONObject.NULL);
        return key.toJSONObject();
    }

    public static JSONObject generateRS384Keys(Long expirationTime) throws Exception {
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS384, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("RSA");
        key.setUse("SIGNATURE");
        key.setAlgorithm(SignatureAlgorithm.RS384.getName());
        key.setKeyId(UUID.randomUUID().toString());
        key.setExpirationTime(expirationTime);
        key.setCurve(JSONObject.NULL);
        return key.toJSONObject();
    }

    public static JSONObject generateRS512Keys(Long expirationTime) throws Exception {
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS512, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("RSA");
        key.setUse("SIGNATURE");
        key.setAlgorithm(SignatureAlgorithm.RS512.getName());
        key.setKeyId(UUID.randomUUID().toString());
        key.setExpirationTime(expirationTime);
        key.setCurve(JSONObject.NULL);
        return key.toJSONObject();
    }

    public static JSONObject generateES256Keys(Long expirationTime) throws Exception {
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES256, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("EC");
        key.setUse("SIGNATURE");
        key.setAlgorithm(SignatureAlgorithm.ES256.getName());
        key.setKeyId(UUID.randomUUID().toString());
        key.setExpirationTime(expirationTime);
        key.setCurve((Object)"P-256");
        return key.toJSONObject();
    }

    public static JSONObject generateES384Keys(Long expirationTime) throws Exception {
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES384, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("EC");
        key.setUse("SIGNATURE");
        key.setAlgorithm(SignatureAlgorithm.ES384.getName());
        key.setKeyId(UUID.randomUUID().toString());
        key.setExpirationTime(expirationTime);
        key.setCurve((Object)"P-384");
        return key.toJSONObject();
    }

    public static JSONObject generateES512Keys(Long expirationTime) throws Exception {
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES512, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("EC");
        key.setUse("SIGNATURE");
        key.setAlgorithm(SignatureAlgorithm.ES512.getName());
        key.setKeyId(UUID.randomUUID().toString());
        key.setExpirationTime(expirationTime);
        key.setCurve((Object)"P-521");
        return key.toJSONObject();
    }

    static {
        LogManager.getRootLogger().removeAllAppenders();
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new SimpleLayout(), "System.out");
        LogManager.getRootLogger().addAppender((Appender)consoleAppender);
        log = Logger.getLogger(KeyGenerator.class);
    }
}

