/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.userinfo.ws.rs;

import java.io.UnsupportedEncodingException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.model.GluuAttribute;
import org.xdi.oxauth.model.authorize.Claim;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.DefaultScope;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.exception.InvalidClaimException;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jwe.JweEncrypterImpl;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jws.ECDSASigner;
import org.xdi.oxauth.model.jws.HMACSigner;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.xdi.oxauth.model.userinfo.UserInfoParamsValidator;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.userinfo.ws.rs.UserInfoRestWebService;
import org.xdi.util.security.StringEncrypter;

@Name(value="requestUserInfoRestWebService")
public class UserInfoRestWebServiceImpl
implements UserInfoRestWebService {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ScopeService scopeService;
    @In
    private AttributeService attributeService;
    @In
    private UserService userService;

    @Override
    public Response requestUserInfoGet(String accessToken, String authorization, SecurityContext securityContext) {
        return this.requestUserInfo(accessToken, authorization, securityContext);
    }

    @Override
    public Response requestUserInfoPost(String accessToken, String authorization, SecurityContext securityContext) {
        return this.requestUserInfo(accessToken, authorization, securityContext);
    }

    public Response requestUserInfo(String accessToken, String authorization, SecurityContext securityContext) {
        Response.ResponseBuilder builder;
        block16: {
            if (authorization != null && !authorization.isEmpty() && authorization.startsWith("Bearer ")) {
                accessToken = authorization.substring(7);
            }
            this.log.debug((Object)"Attempting to request User Info, Access token = {0}, Is Secure = {1}", new Object[]{accessToken, securityContext.isSecure()});
            builder = Response.ok();
            try {
                if (!UserInfoParamsValidator.validateParams(accessToken)) {
                    builder = Response.status((int)400);
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)UserInfoErrorResponseType.INVALID_REQUEST));
                    break block16;
                }
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
                if (authorizationGrant == null) {
                    builder = Response.status((int)400);
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)UserInfoErrorResponseType.INVALID_TOKEN));
                    break block16;
                }
                if (!authorizationGrant.getScopes().contains(DefaultScope.OPEN_ID.toString()) && !authorizationGrant.getScopes().contains(DefaultScope.PROFILE.toString())) {
                    builder = Response.status((int)403);
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)UserInfoErrorResponseType.INSUFFICIENT_SCOPE));
                    break block16;
                }
                CacheControl cacheControl = new CacheControl();
                cacheControl.setPrivate(true);
                cacheControl.setNoTransform(false);
                cacheControl.setNoStore(true);
                builder.cacheControl(cacheControl);
                builder.header("Pragma", (Object)"no-cache");
                User currentUser = authorizationGrant.getUser();
                try {
                    currentUser = this.userService.getUserByDn(authorizationGrant.getUserDn());
                }
                catch (EntryPersistenceException ex) {
                    this.log.warn((Object)"Failed to reload user entry: '{0}'", new Object[]{authorizationGrant.getUserDn()});
                }
                if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getUserInfoEncryptedResponseAlg() != null && authorizationGrant.getClient().getUserInfoEncryptedResponseEnc() != null) {
                    KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoEncryptedResponseAlg());
                    BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoEncryptedResponseEnc());
                    builder.type("application/jwt");
                    builder.entity((Object)this.getJweResponse(keyEncryptionAlgorithm, blockEncryptionAlgorithm, currentUser, authorizationGrant, authorizationGrant.getScopes()));
                } else if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getUserInfoSignedResponseAlg() != null) {
                    SignatureAlgorithm algorithm = SignatureAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoSignedResponseAlg());
                    builder.type("application/jwt");
                    builder.entity((Object)this.getJwtResponse(algorithm, currentUser, authorizationGrant, authorizationGrant.getScopes()));
                } else {
                    builder.type("application/json");
                    builder.entity((Object)this.getJSonResponse(currentUser, authorizationGrant, authorizationGrant.getScopes()));
                }
            }
            catch (StringEncrypter.EncryptionException e) {
                builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (InvalidJwtException e) {
                builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (SignatureException e) {
                builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (InvalidClaimException e) {
                builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (Exception e) {
                builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return builder.build();
    }

    public String getJwtResponse(SignatureAlgorithm signatureAlgorithm, User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws StringEncrypter.EncryptionException, InvalidJwtException, InvalidClaimException, SignatureException {
        Jwt jwt = new Jwt();
        JSONWebKeySet jwks = ConfigurationFactory.getWebKeys();
        if (signatureAlgorithm == SignatureAlgorithm.NONE) {
            jwt.getHeader().setType(JwtType.JWT);
        } else {
            jwt.getHeader().setType(JwtType.JWS);
        }
        jwt.getHeader().setAlgorithm(signatureAlgorithm);
        List availableKeys = jwks.getKeys(signatureAlgorithm);
        if (availableKeys.size() > 0) {
            jwt.getHeader().setKeyId(((JSONWebKey)availableKeys.get(0)).getKeyId());
        }
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
            if (scope.getOxAuthClaims() == null) continue;
            for (String claimDn : scope.getOxAuthClaims()) {
                GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                String claimName = gluuAttribute.getOxAuthClaimName();
                String ldapName = gluuAttribute.getGluuLdapAttributeName();
                String attributeValue = null;
                if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
                attributeValue = ldapName.equals("uid") ? user.getUserId() : user.getAttribute(gluuAttribute.getName());
                jwt.getClaims().setClaim(claimName, attributeValue);
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember().getClaims()) {
                String ldapClaimName;
                Object attribute;
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null || (attribute = user.getAttribute(ldapClaimName = gluuAttribute.getGluuLdapAttributeName(), optional)) == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value = jsonArray.optString(i);
                        if (value == null) continue;
                        values.add(value);
                    }
                    jwt.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                String value = (String)attribute;
                jwt.getClaims().setClaim(claim.getName(), value);
            }
        }
        jwt.getClaims().setClaim("sub", authorizationGrant.getClient().getSubjectIdentifier());
        JSONWebKey jwk = null;
        switch (signatureAlgorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                HMACSigner hmacSigner = new HMACSigner(signatureAlgorithm, authorizationGrant.getClient().getClientSecret());
                jwt = hmacSigner.sign(jwt);
                break;
            }
            case RS256: 
            case RS384: 
            case RS512: {
                jwk = jwks.getKey(jwt.getHeader().getClaimAsString("kid"));
                RSAPrivateKey rsaPrivateKey = new RSAPrivateKey(jwk.getPrivateKey().getModulus(), jwk.getPrivateKey().getPrivateExponent());
                RSASigner rsaSigner = new RSASigner(signatureAlgorithm, rsaPrivateKey);
                jwt = rsaSigner.sign(jwt);
                break;
            }
            case ES256: 
            case ES384: 
            case ES512: {
                jwk = jwks.getKey(jwt.getHeader().getClaimAsString("kid"));
                ECDSAPrivateKey ecdsaPrivateKey = new ECDSAPrivateKey(jwk.getPrivateKey().getD());
                ECDSASigner ecdsaSigner = new ECDSASigner(signatureAlgorithm, ecdsaPrivateKey);
                jwt = ecdsaSigner.sign(jwt);
                break;
            }
            case NONE: {
                break;
            }
        }
        return jwt.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getJweResponse(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws InvalidClaimException, InvalidJweException {
        JweEncrypterImpl jweEncrypter;
        Jwe jwe = new Jwe();
        jwe.getHeader().setType(JwtType.JWE);
        jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
            if (scope.getOxAuthClaims() == null) continue;
            for (String claimDn : scope.getOxAuthClaims()) {
                GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                String claimName = gluuAttribute.getOxAuthClaimName();
                String ldapName = gluuAttribute.getGluuLdapAttributeName();
                String attributeValue = null;
                if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
                attributeValue = ldapName.equals("uid") ? user.getUserId() : user.getAttribute(gluuAttribute.getName());
                jwe.getClaims().setClaim(claimName, attributeValue);
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember().getClaims()) {
                String ldapClaimName;
                Object attribute;
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null || (attribute = user.getAttribute(ldapClaimName = gluuAttribute.getGluuLdapAttributeName(), optional)) == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value = jsonArray.optString(i);
                        if (value == null) continue;
                        values.add(value);
                    }
                    jwe.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                String value = (String)attribute;
                jwe.getClaims().setClaim(claim.getName(), value);
            }
        }
        jwe.getClaims().setClaim("sub", authorizationGrant.getClient().getSubjectIdentifier());
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            PublicKey publicKey = JwtUtil.getPublicKey((String)authorizationGrant.getClient().getJwksUri(), null, (SignatureAlgorithm)SignatureAlgorithm.RS256, null);
            if (publicKey == null || !(publicKey instanceof RSAPublicKey)) throw new InvalidJweException("The public key is not valid");
            jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, (RSAPublicKey)publicKey);
            jwe = jweEncrypter.encrypt(jwe);
            return jwe.toString();
        }
        if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A128KW && keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A256KW) return jwe.toString();
        try {
            byte[] sharedSymmetricKey = authorizationGrant.getClient().getClientSecret().getBytes("UTF-8");
            jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedSymmetricKey);
            jwe = jweEncrypter.encrypt(jwe);
            return jwe.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJweException((Throwable)e);
        }
    }

    public String getJSonResponse(User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws JSONException {
        JSONObject jsonObj = new JSONObject();
        try {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
                Map<String, Object> claims = this.getClaims(user, scope);
                if (scope.getIsOxAuthGroupClaims()) {
                    JSONObject jsonObjGroupClaim = new JSONObject();
                    for (Map.Entry<String, Object> entry : claims.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        jsonObjGroupClaim.put(key, value);
                    }
                    jsonObj.put(scope.getDisplayName(), (Object)jsonObjGroupClaim);
                    continue;
                }
                for (Map.Entry<String, Object> entry : claims.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    jsonObj.put(key, value);
                }
            }
            if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember() != null) {
                for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember().getClaims()) {
                    String ldapClaimName;
                    Object attribute;
                    boolean optional = true;
                    GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                    if (gluuAttribute == null || (attribute = user.getAttribute(ldapClaimName = gluuAttribute.getGluuLdapAttributeName(), optional)) == null) continue;
                    jsonObj.put(claim.getName(), attribute);
                }
            }
            jsonObj.put("sub", (Object)authorizationGrant.getClient().getSubjectIdentifier());
        }
        catch (JSONException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return jsonObj.toString(4).replace("\\/", "/");
    }

    public Map<String, Object> getClaims(User user, Scope scope) throws InvalidClaimException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (scope != null && scope.getOxAuthClaims() != null) {
            for (String claimDn : scope.getOxAuthClaims()) {
                GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                String claimName = gluuAttribute.getOxAuthClaimName();
                String ldapName = gluuAttribute.getGluuLdapAttributeName();
                Object attributeValue = null;
                if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName)) continue;
                attributeValue = ldapName.equals("uid") ? user.getUserId() : user.getAttribute(gluuAttribute.getName(), true);
                claims.put(claimName, attributeValue);
            }
        }
        return claims;
    }
}

