/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.userinfo.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/oxauth")
@Api(value="/oxauth", description="The UserInfo Endpoint is an OAuth 2.0 Protected Resource that returns Claims about the authenticated End-User. To obtain the requested Claims about the End-User, the Client makes a request to the UserInfo Endpoint using an Access Token obtained through OpenID Connect Authentication. These Claims are normally represented by a JSON object that contains a collection of name and value pairs for the Claims. ")
public interface UserInfoRestWebService {
    @GET
    @Path(value="/userinfo")
    @ApiOperation(value="Returns Claims about the authenticated End-User.", notes="The Access Token obtained from an OpenID Connect Authentication Request is sent as a Bearer Token.", response=Response.class, responseContainer="JSON")
    public Response requestUserInfoGet(@QueryParam(value="access_token") @ApiParam(value="OAuth 2.0 Access Token.", required=true) String var1, @HeaderParam(value="Authorization") String var2, @Context SecurityContext var3);

    @POST
    @Path(value="/userinfo")
    @ApiOperation(value="Returns Claims about the authenticated End-User.", notes="The Access Token obtained from an OpenID Connect Authentication Request is sent as a Bearer Token.", response=Response.class, responseContainer="JSON")
    public Response requestUserInfoPost(@FormParam(value="access_token") @ApiParam(value="OAuth 2.0 Access Token.", required=true) String var1, @HeaderParam(value="Authorization") String var2, @Context SecurityContext var3);
}

