/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.RegisterPermissionRequest;
import org.xdi.oxauth.model.uma.RptIntrospectionResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.util.ServerUtil;

@Path(value="/rpt/status")
@Api(value="/rpt/status", description="The endpoint at which the host requests the status of an RPT presented to it by a requester. The endpoint is RPT introspection profile implementation defined by UMA specification")
@Name(value="rptStatusRestWebService")
public class RptStatusWS {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RPTManager rptManager;
    @In
    private UmaValidationService umaValidationService;
    @In
    private ScopeService umaScopeService;

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="The resource server MUST determine a received RPT's status, including both whether it is active and, if so, its associated authorization data, before giving or refusing access to the client. An RPT is associated with a set of authorization data that governs whether the client is authorized for access. The token's nature and format are dictated by its profile; the profile might allow it to be self-contained, such that the resource server is able to determine its status locally, or might require or allow the resource server to make a run-time introspection request of the authorization server that issued the token.", produces="application/json", notes="The endpoint MAY allow other parameters to provide further context to\n   the query.  For instance, an authorization service may need to know\n   the IP address of the client accessing the protected resource in\n   order to determine the appropriateness of the token being presented.\n\n   To prevent unauthorized token scanning attacks, the endpoint MUST\n   also require some form of authorization to access this endpoint, such\n   as client authentication as described in OAuth 2.0 [RFC6749] or a\n   separate OAuth 2.0 access token such as the bearer token described in\n   OAuth 2.0 Bearer Token Usage [RFC6750].  The methods of managing and\n   validating these authentication credentials are out of scope of this\n   specification.\n")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public Response requestRptStatus(@HeaderParam(value="Authorization") String authorization, @FormParam(value="token") @ApiParam(value="The string value of the token.  For access tokens,\n      this is the \"access_token\" value returned from the token endpoint\n      defined in OAuth 2.0 [RFC6749] section 5.1.  For refresh tokens,\n      this is the \"refresh_token\" value returned from the token endpoint\n      as defined in OAuth 2.0 [RFC6749] section 5.1.  Other token types\n      are outside the scope of this specification.", required=true) String rptAsString, @FormParam(value="token_type_hint") @ApiParam(value="A hint about the type of the token\n      submitted for introspection.  The protected resource re MAY pass\n      this parameter in order to help the authorization server to\n      optimize the token lookup.  If the server is unable to locate the\n      token using the given hint, it MUST extend its search across all\n      of its supported token types.  An authorization server MAY ignore\n      this parameter, particularly if it is able to detect the token\n      type automatically.  Values for this field are defined in OAuth\n      Token Revocation [RFC7009].", required=false) String tokenTypeHint) {
        try {
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            UmaRPT rpt = this.rptManager.getRPTByCode(rptAsString);
            if (!this.isValid(rpt)) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new RptIntrospectionResponse(false)).cacheControl(ServerUtil.cacheControl(true)).build();
            }
            List<RegisterPermissionRequest> permissions = this.buildStatusResponsePermissions(rpt);
            RptIntrospectionResponse statusResponse = new RptIntrospectionResponse();
            statusResponse.setActive(true);
            statusResponse.setExpiresAt(rpt.getExpirationDate());
            statusResponse.setIssuedAt(rpt.getCreationDate());
            statusResponse.setPermissions(permissions);
            String entity = ServerUtil.asJson(statusResponse);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private boolean isValid(UmaRPT p_rpt) {
        if (p_rpt != null) {
            p_rpt.checkExpired();
            return p_rpt.isValid();
        }
        return false;
    }

    private boolean isValid(ResourceSetPermission resourceSetPermission) {
        if (resourceSetPermission != null) {
            resourceSetPermission.checkExpired();
            return resourceSetPermission.isValid();
        }
        return false;
    }

    private List<RegisterPermissionRequest> buildStatusResponsePermissions(UmaRPT p_rpt) {
        List<ResourceSetPermission> rptPermissions;
        ArrayList<RegisterPermissionRequest> result = new ArrayList<RegisterPermissionRequest>();
        if (p_rpt != null && (rptPermissions = this.rptManager.getRptPermissions(p_rpt)) != null && !rptPermissions.isEmpty()) {
            for (ResourceSetPermission permission : rptPermissions) {
                if (this.isValid(permission)) {
                    RegisterPermissionRequest toAdd = ServerUtil.convert(permission, this.umaScopeService);
                    if (toAdd == null) continue;
                    result.add(toAdd);
                    continue;
                }
                this.log.debug((Object)"Ignore permission, skip it in response because permission is not valid. Permission dn: {0}, rpt dn: {1}", new Object[]{permission.getDn(), p_rpt.getDn()});
            }
        }
        return result;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Not allowed")
    @ApiResponses(value={@ApiResponse(code=405, message="Introspection of RPT is not allowed by GET HTTP method.")})
    public Response requestRptStatusGet(@HeaderParam(value="Authorization") String authorization, @FormParam(value="token") String rpt, @FormParam(value="token_type_hint") String tokenTypeHint) {
        throw new WebApplicationException(Response.status((int)405).entity((Object)"Introspection of RPT is not allowed by GET HTTP method.").build());
    }
}

